/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivewifi;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.location.LocationManager;
import com.github.pwittchen.reactivewifi.R;

public class AccessRequester {
    private AccessRequester() {
    }

    public static boolean isLocationEnabled(Context context) {
        LocationManager manager = (LocationManager)context.getSystemService("location");
        boolean isGpsProviderEnabled = manager.isProviderEnabled("gps");
        boolean isNetworkProviderEnabled = manager.isProviderEnabled("network");
        return isGpsProviderEnabled || isNetworkProviderEnabled;
    }

    public static void requestLocationAccess(final Activity activity) {
        AccessRequester.buildLocationAccessDialog(activity, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                activity.startActivity(intent);
            }
        }).show();
    }

    public static void requestLocationAccess(final Activity activity, String title, String message) {
        AccessRequester.buildLocationAccessDialog(activity, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                activity.startActivity(intent);
            }
        }, title, message).show();
    }

    public static AlertDialog.Builder buildLocationAccessDialog(Activity activity, DialogInterface.OnClickListener onOkClickListener) {
        Resources resources = activity.getResources();
        String title = resources.getString(R.string.requesting_location_access);
        String message = resources.getString(R.string.do_you_want_to_open_location_settings);
        return AccessRequester.buildLocationAccessDialog(activity, onOkClickListener, title, message);
    }

    public static AlertDialog.Builder buildLocationAccessDialog(Activity activity, DialogInterface.OnClickListener onOkClickListener, String title, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton(17039370, onOkClickListener);
        builder.setNegativeButton(17039369, null);
        builder.setCancelable(true);
        return builder;
    }
}

