/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;

public class Connectivity {
    static final int UNKNOWN_TYPE = -1;
    static final int UNKNOWN_SUB_TYPE = -1;
    private NetworkInfo.State state;
    private NetworkInfo.DetailedState detailedState;
    private int type;
    private int subType;
    private boolean available;
    private boolean failover;
    private boolean roaming;
    private String typeName;
    private String subTypeName;
    private String reason;
    private String extraInfo;

    public static Connectivity create() {
        return Connectivity.builder().build();
    }

    public static Connectivity create(@NonNull Context context) {
        Preconditions.checkNotNull(context, "context == null");
        return Connectivity.create(context, Connectivity.getConnectivityManager(context));
    }

    private static ConnectivityManager getConnectivityManager(Context context) {
        String service = "connectivity";
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    protected static Connectivity create(@NonNull Context context, ConnectivityManager manager) {
        Preconditions.checkNotNull(context, "context == null");
        if (manager == null) {
            return Connectivity.create();
        }
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        return networkInfo == null ? Connectivity.create() : Connectivity.create(networkInfo);
    }

    private static Connectivity create(NetworkInfo networkInfo) {
        return new Builder().state(networkInfo.getState()).detailedState(networkInfo.getDetailedState()).type(networkInfo.getType()).subType(networkInfo.getSubtype()).available(networkInfo.isAvailable()).failover(networkInfo.isFailover()).roaming(networkInfo.isRoaming()).typeName(networkInfo.getTypeName()).subTypeName(networkInfo.getSubtypeName()).reason(networkInfo.getReason()).extraInfo(networkInfo.getExtraInfo()).build();
    }

    private Connectivity(Builder builder) {
        this.state = builder.state;
        this.detailedState = builder.detailedState;
        this.type = builder.type;
        this.subType = builder.subType;
        this.available = builder.available;
        this.failover = builder.failover;
        this.roaming = builder.roaming;
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.reason = builder.reason;
        this.extraInfo = builder.extraInfo;
    }

    private Connectivity() {
        this(Connectivity.builder());
    }

    private static Builder builder() {
        return new Builder();
    }

    public NetworkInfo.State state() {
        return this.state;
    }

    public static Builder state(NetworkInfo.State state) {
        return Connectivity.builder().state(state);
    }

    public NetworkInfo.DetailedState detailedState() {
        return this.detailedState;
    }

    public static Builder state(NetworkInfo.DetailedState detailedState) {
        return Connectivity.builder().detailedState(detailedState);
    }

    public int type() {
        return this.type;
    }

    public static Builder type(int type) {
        return Connectivity.builder().type(type);
    }

    public int subType() {
        return this.subType;
    }

    public static Builder subType(int subType) {
        return Connectivity.builder().subType(subType);
    }

    public boolean available() {
        return this.available;
    }

    public static Builder available(boolean available) {
        return Connectivity.builder().available(available);
    }

    public boolean failover() {
        return this.failover;
    }

    public static Builder failover(boolean failover) {
        return Connectivity.builder().failover(failover);
    }

    public boolean roaming() {
        return this.roaming;
    }

    public static Builder roaming(boolean roaming) {
        return Connectivity.builder().roaming(roaming);
    }

    public String typeName() {
        return this.typeName;
    }

    public static Builder typeName(String typeName) {
        return Connectivity.builder().typeName(typeName);
    }

    public String subTypeName() {
        return this.subTypeName;
    }

    public static Builder subTypeName(String subTypeName) {
        return Connectivity.builder().subTypeName(subTypeName);
    }

    public String reason() {
        return this.reason;
    }

    public static Builder reason(String reason) {
        return Connectivity.builder().reason(reason);
    }

    public String extraInfo() {
        return this.extraInfo;
    }

    public static Builder extraInfo(String extraInfo) {
        return Connectivity.builder().extraInfo(extraInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connectivity that = (Connectivity)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.subType != that.subType) {
            return false;
        }
        if (this.available != that.available) {
            return false;
        }
        if (this.failover != that.failover) {
            return false;
        }
        if (this.roaming != that.roaming) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.detailedState != that.detailedState) {
            return false;
        }
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        if (this.subTypeName != null ? !this.subTypeName.equals(that.subTypeName) : that.subTypeName != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return this.extraInfo != null ? this.extraInfo.equals(that.extraInfo) : that.extraInfo == null;
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + (this.detailedState != null ? this.detailedState.hashCode() : 0);
        result = 31 * result + this.type;
        result = 31 * result + this.subType;
        result = 31 * result + (this.available ? 1 : 0);
        result = 31 * result + (this.failover ? 1 : 0);
        result = 31 * result + (this.roaming ? 1 : 0);
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + (this.subTypeName != null ? this.subTypeName.hashCode() : 0);
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        result = 31 * result + (this.extraInfo != null ? this.extraInfo.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Connectivity{state=" + this.state + ", detailedState=" + this.detailedState + ", type=" + this.type + ", subType=" + this.subType + ", available=" + this.available + ", failover=" + this.failover + ", roaming=" + this.roaming + ", typeName='" + this.typeName + '\'' + ", subTypeName='" + this.subTypeName + '\'' + ", reason='" + this.reason + '\'' + ", extraInfo='" + this.extraInfo + '\'' + '}';
    }

    public static class Builder {
        private NetworkInfo.State state = NetworkInfo.State.DISCONNECTED;
        private NetworkInfo.DetailedState detailedState = NetworkInfo.DetailedState.IDLE;
        private int type = -1;
        private int subType = -1;
        private boolean available = false;
        private boolean failover = false;
        private boolean roaming = false;
        private String typeName = "NONE";
        private String subTypeName = "NONE";
        private String reason = "";
        private String extraInfo = "";

        public Builder state(NetworkInfo.State state) {
            this.state = state;
            return this;
        }

        public Builder detailedState(NetworkInfo.DetailedState detailedState) {
            this.detailedState = detailedState;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder subType(int subType) {
            this.subType = subType;
            return this;
        }

        public Builder available(boolean available) {
            this.available = available;
            return this;
        }

        public Builder failover(boolean failover) {
            this.failover = failover;
            return this;
        }

        public Builder roaming(boolean roaming) {
            this.roaming = roaming;
            return this;
        }

        public Builder typeName(String name) {
            this.typeName = name;
            return this;
        }

        public Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder extraInfo(String extraInfo) {
            this.extraInfo = extraInfo;
            return this;
        }

        public Connectivity build() {
            return new Connectivity(this);
        }
    }
}

