/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import com.github.promeg.xlog_android.lib.XLogArrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

final class Strings {
    static final int LOG_CONTENT_MAX_LENGTH = 1000;

    static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return '\"' + Strings.printableToString(obj.toString()) + '\"';
        }
        if (obj instanceof Collection) {
            return Strings.collectionToString((Collection)obj);
        }
        Class<?> cls = obj.getClass();
        if (Byte.class == cls) {
            return Strings.byteToString((Byte)obj);
        }
        if (cls.isArray()) {
            return Strings.arrayToString(cls.getComponentType(), obj);
        }
        return obj.toString();
    }

    private static String printableToString(String string) {
        int codePoint;
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        block10: for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(i);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    switch (codePoint) {
                        case 10: {
                            builder.append("\\n");
                            continue block10;
                        }
                        case 13: {
                            builder.append("\\r");
                            continue block10;
                        }
                        case 9: {
                            builder.append("\\t");
                            continue block10;
                        }
                        case 12: {
                            builder.append("\\f");
                            continue block10;
                        }
                        case 8: {
                            builder.append("\\b");
                            continue block10;
                        }
                    }
                    builder.append("\\u").append(String.format("%04x", codePoint).toUpperCase(Locale.US));
                    continue block10;
                }
                default: {
                    builder.append(Character.toChars(codePoint));
                }
            }
        }
        return builder.toString();
    }

    private static String collectionToString(Collection collection) {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        for (Object element : collection) {
            if (builder.length() > 1000) {
                return builder.append("] (" + count + ":" + collection.size() + ")").toString();
            }
            if (count > 0) {
                builder.append(", ");
            }
            ++count;
            if (element == null) {
                builder.append("null");
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() && elementClass.getComponentType() == Object.class) {
                Object[] arrayElement = (Object[])element;
                Strings.arrayToString(arrayElement, builder, new HashSet<Object[]>());
                continue;
            }
            builder.append(Strings.toString(element));
        }
        return builder.append(']').toString();
    }

    private static String arrayToString(Class<?> cls, Object obj) {
        if (Byte.TYPE == cls) {
            return Strings.byteArrayToString((byte[])obj);
        }
        if (Short.TYPE == cls) {
            return XLogArrays.toStringPartly((short[])obj, 1000);
        }
        if (Character.TYPE == cls) {
            return XLogArrays.toStringPartly((char[])obj, 1000);
        }
        if (Integer.TYPE == cls) {
            return XLogArrays.toStringPartly((int[])obj, 1000);
        }
        if (Long.TYPE == cls) {
            return XLogArrays.toStringPartly((long[])obj, 1000);
        }
        if (Float.TYPE == cls) {
            return XLogArrays.toStringPartly((float[])obj, 1000);
        }
        if (Double.TYPE == cls) {
            return XLogArrays.toStringPartly((double[])obj, 1000);
        }
        if (Boolean.TYPE == cls) {
            return XLogArrays.toStringPartly((boolean[])obj, 1000);
        }
        return Strings.arrayToString((Object[])obj);
    }

    private static String byteArrayToString(byte[] bytes) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < bytes.length && builder.length() < 1000; ++i) {
            if (builder.length() > 1000) {
                return builder.append("] (" + i + ":" + bytes.length + ")").toString();
            }
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Strings.byteToString(bytes[i]));
        }
        return builder.append(']').toString();
    }

    private static String byteToString(Byte b) {
        if (b == null) {
            return "null";
        }
        return "0x" + String.format("%02x", b).toUpperCase(Locale.US);
    }

    private static String arrayToString(Object[] array) {
        StringBuilder buf = new StringBuilder();
        Strings.arrayToString(array, buf, new HashSet<Object[]>());
        return buf.toString();
    }

    private static void arrayToString(Object[] array, StringBuilder builder, Set<Object[]> seen) {
        if (array == null) {
            builder.append("null");
            return;
        }
        seen.add(array);
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            Object element;
            if (builder.length() > 1000) {
                builder.append("] (" + i + ":" + array.length + ")");
                seen.remove(array);
                return;
            }
            if (i > 0) {
                builder.append(", ");
            }
            if ((element = array[i]) == null) {
                builder.append("null");
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() && elementClass.getComponentType() == Object.class) {
                Object[] arrayElement = (Object[])element;
                if (seen.contains(arrayElement)) {
                    builder.append("[...]");
                    continue;
                }
                Strings.arrayToString(arrayElement, builder, seen);
                continue;
            }
            builder.append(Strings.toString(element));
        }
        builder.append(']');
        seen.remove(array);
    }

    private Strings() {
        throw new AssertionError((Object)"No instances.");
    }
}

