/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.github.promeg.xlog_android.lib.Strings;
import com.promegu.xlog.base.MethodToLog;
import com.taobao.android.dexposed.XC_MethodHook;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class XLogMethodHook
extends XC_MethodHook {
    private long startTime;
    private Member mMember;
    private MethodToLog mMethodToLog;
    private final long mTimeThreshold;
    private String mBeforeLogCache;

    public XLogMethodHook(Member member, MethodToLog methodToLog, long timeThreshold) {
        this.mMember = member;
        this.mMethodToLog = methodToLog;
        this.mTimeThreshold = timeThreshold;
    }

    protected void beforeHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
        Class<?>[] parameterTypes = null;
        parameterTypes = this.mMember instanceof Method ? ((Method)this.mMember).getParameterTypes() : ((Constructor)this.mMember).getParameterTypes();
        StringBuilder builder = new StringBuilder("\u21e2 ");
        builder.append(param.method.getName()).append('(');
        for (int i = 0; i < param.args.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            if (this.mMethodToLog != null && this.mMethodToLog.getParameterNames().size() > i) {
                builder.append((String)this.mMethodToLog.getParameterNames().get(i)).append('=');
            } else {
                builder.append(parameterTypes[i].getSimpleName()).append('=');
            }
            builder.append(Strings.toString(param.args[i]));
        }
        builder.append(')');
        if (Looper.myLooper() != Looper.getMainLooper()) {
            builder.append(" [Thread:\"").append(Thread.currentThread().getName()).append("\"]");
        }
        if (this.shouldLog(-2L)) {
            this.mBeforeLogCache = null;
            Log.d((String)XLogMethodHook.asTag(this.mMember.getDeclaringClass()), (String)builder.toString());
        } else {
            this.mBeforeLogCache = builder.toString();
        }
        this.startTime = System.currentTimeMillis();
    }

    protected void afterHookedMethod(XC_MethodHook.MethodHookParam param) throws Throwable {
        long lengthMillis = System.currentTimeMillis() - this.startTime;
        if (this.shouldLog(lengthMillis)) {
            if (!TextUtils.isEmpty((CharSequence)this.mBeforeLogCache)) {
                Log.d((String)XLogMethodHook.asTag(this.mMember.getDeclaringClass()), (String)this.mBeforeLogCache);
            }
            StringBuilder builder = new StringBuilder("\u21e0 ").append(param.method.getName()).append(" [").append(lengthMillis).append("ms]");
            if (param.getResult() != null) {
                builder.append(" = ");
                builder.append(Strings.toString(param.getResult()));
            }
            Log.d((String)XLogMethodHook.asTag(this.mMember.getDeclaringClass()), (String)builder.toString());
        }
    }

    private boolean shouldLog(long timeInMillis) {
        if (this.mTimeThreshold <= 0L || this.mTimeThreshold == -1L) {
            return true;
        }
        return timeInMillis >= this.mTimeThreshold;
    }

    private static String asTag(Class<?> cls) {
        if (cls.isAnonymousClass()) {
            return XLogMethodHook.asTag(cls.getEnclosingClass());
        }
        return cls.getSimpleName();
    }
}

