/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed;

import android.content.res.Resources;
import com.taobao.android.dexposed.ClassUtils;
import com.taobao.android.dexposed.DexposedBridge;
import com.taobao.android.dexposed.XC_MethodHook;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class XposedHelpers {
    private static final HashMap<String, Field> fieldCache = new HashMap();
    private static final HashMap<String, Method> methodCache = new HashMap();
    private static final HashMap<String, Constructor<?>> constructorCache = new HashMap();
    private static final WeakHashMap<Object, HashMap<String, Object>> additionalFields = new WeakHashMap();

    public static Class<?> findClass(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = DexposedBridge.BOOTCLASSLOADER;
        }
        try {
            return ClassUtils.getClass(classLoader, className, false);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundError(e);
        }
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder(clazz.getName());
        sb.append('#');
        sb.append(fieldName);
        String fullFieldName = sb.toString();
        if (fieldCache.containsKey(fullFieldName)) {
            Field field = fieldCache.get(fullFieldName);
            if (field == null) {
                throw new NoSuchFieldError(fullFieldName);
            }
            return field;
        }
        try {
            Field field = XposedHelpers.findFieldRecursiveImpl(clazz, fieldName);
            field.setAccessible(true);
            fieldCache.put(fullFieldName, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            fieldCache.put(fullFieldName, null);
            throw new NoSuchFieldError(fullFieldName);
        }
    }

    private static Field findFieldRecursiveImpl(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            throw e;
        }
    }

    public static Field findFirstFieldByExactType(Class<?> clazz, Class<?> type) {
        Class<?> clz = clazz;
        do {
            Field[] fieldArray = clz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType() == type) {
                    field.setAccessible(true);
                    return field;
                }
                ++n2;
            }
        } while ((clz = clz.getSuperclass()) != null);
        throw new NoSuchFieldError("Field of type " + type.getName() + " in class " + clazz.getName());
    }

    public static Method findMethodExact(Class<?> clazz, String methodName, Object ... parameterTypes) {
        Class[] parameterClasses = null;
        int i = parameterTypes.length - 1;
        while (i >= 0) {
            Object type = parameterTypes[i];
            if (type == null) {
                throw new ClassNotFoundError("parameter type must not be null", null);
            }
            if (!(type instanceof XC_MethodHook)) {
                if (parameterClasses == null) {
                    parameterClasses = new Class[i + 1];
                }
                if (type instanceof Class) {
                    parameterClasses[i] = (Class)type;
                } else if (type instanceof String) {
                    parameterClasses[i] = XposedHelpers.findClass((String)type, clazz.getClassLoader());
                } else {
                    throw new ClassNotFoundError("parameter type must either be specified as Class or String", null);
                }
            }
            --i;
        }
        if (parameterClasses == null) {
            parameterClasses = new Class[]{};
        }
        return XposedHelpers.findMethodExact(clazz, methodName, parameterClasses);
    }

    public static Method findMethodExact(String className, ClassLoader classLoader, String methodName, Object ... parameterTypes) {
        return XposedHelpers.findMethodExact(XposedHelpers.findClass(className, classLoader), methodName, parameterTypes);
    }

    public static Method findMethodExact(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder(clazz.getName());
        sb.append('#');
        sb.append(methodName);
        sb.append(XposedHelpers.getParametersString(parameterTypes));
        sb.append("#exact");
        String fullMethodName = sb.toString();
        if (methodCache.containsKey(fullMethodName)) {
            Method method = methodCache.get(fullMethodName);
            if (method == null) {
                throw new NoSuchMethodError(fullMethodName);
            }
            return method;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            methodCache.put(fullMethodName, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            methodCache.put(fullMethodName, null);
            throw new NoSuchMethodError(fullMethodName);
        }
    }

    public static Method[] findMethodsByExactParameters(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        LinkedList<Method> result = new LinkedList<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] methodParameterTypes;
            Method method = methodArray[n2];
            if ((returnType == null || returnType == method.getReturnType()) && parameterTypes.length == (methodParameterTypes = method.getParameterTypes()).length) {
                boolean match = true;
                int i = 0;
                while (i < parameterTypes.length) {
                    if (parameterTypes[i] != methodParameterTypes[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (match) {
                    method.setAccessible(true);
                    result.add(method);
                }
            }
            ++n2;
        }
        return result.toArray(new Method[result.size()]);
    }

    /*
     * Exception decompiling
     */
    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CATCHBLOCK]], but top level block is 2[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Object ... args) {
        return XposedHelpers.findMethodBestMatch(clazz, methodName, XposedHelpers.getParameterTypes(args));
    }

    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Class<?>[] argsClasses = null;
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] == null) {
                if (argsClasses == null) {
                    argsClasses = XposedHelpers.getParameterTypes(args);
                }
                parameterTypes[i] = argsClasses[i];
            }
            ++i;
        }
        return XposedHelpers.findMethodBestMatch(clazz, methodName, parameterTypes);
    }

    public static Class<?>[] getParameterTypes(Object ... args) {
        Class[] clazzes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            clazzes[i] = args[i] != null ? args[i].getClass() : null;
            ++i;
        }
        return clazzes;
    }

    public static Class<?>[] getClassesAsArray(Class<?> ... clazzes) {
        return clazzes;
    }

    private static String getParametersString(Class<?> ... clazzes) {
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        Class<?>[] classArray = clazzes;
        int n = clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (clazz != null) {
                sb.append(clazz.getCanonicalName());
            } else {
                sb.append("null");
            }
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    public static Constructor<?> findConstructorExact(Class<?> clazz, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder(clazz.getName());
        sb.append(XposedHelpers.getParametersString(parameterTypes));
        sb.append("#exact");
        String fullConstructorName = sb.toString();
        if (constructorCache.containsKey(fullConstructorName)) {
            Constructor<?> constructor = constructorCache.get(fullConstructorName);
            if (constructor == null) {
                throw new NoSuchMethodError(fullConstructorName);
            }
            return constructor;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            constructorCache.put(fullConstructorName, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            constructorCache.put(fullConstructorName, null);
            throw new NoSuchMethodError(fullConstructorName);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Constructor<?> findConstructorBestMatch(Class<?> clazz, Class<?> ... parameterTypes) {
        sb = new StringBuilder(clazz.getName());
        sb.append(XposedHelpers.getParametersString(parameterTypes));
        sb.append("#bestmatch");
        fullConstructorName = sb.toString();
        if (XposedHelpers.constructorCache.containsKey(fullConstructorName)) {
            constructor = XposedHelpers.constructorCache.get(fullConstructorName);
            if (constructor == null) {
                throw new NoSuchMethodError(fullConstructorName);
            }
            return constructor;
        }
        try {
            constructor = XposedHelpers.findConstructorExact(clazz, parameterTypes);
            XposedHelpers.constructorCache.put(fullConstructorName, constructor);
            return constructor;
        }
        catch (NoSuchMethodError constructor) {
            bestMatch = null;
            var9_9 = constructors = clazz.getDeclaredConstructors();
            var8_10 = constructors.length;
            var7_11 = 0;
            ** while (var7_11 < var8_10)
        }
lbl-1000:
        // 1 sources

        {
            var6_12 = var9_9[var7_11];
            ++var7_11;
            continue;
        }
lbl26:
        // 1 sources

        if (bestMatch != null) {
            bestMatch.setAccessible(true);
            XposedHelpers.constructorCache.put(fullConstructorName, bestMatch);
            return bestMatch;
        }
        e = new NoSuchMethodError(fullConstructorName);
        XposedHelpers.constructorCache.put(fullConstructorName, null);
        throw e;
    }

    public static Constructor<?> findConstructorBestMatch(Class<?> clazz, Object ... args) {
        return XposedHelpers.findConstructorBestMatch(clazz, XposedHelpers.getParameterTypes(args));
    }

    public static Constructor<?> findConstructorBestMatch(Class<?> clazz, Class<?>[] parameterTypes, Object[] args) {
        Class<?>[] argsClasses = null;
        int i = 0;
        while (i < parameterTypes.length) {
            if (parameterTypes[i] == null) {
                if (argsClasses == null) {
                    argsClasses = XposedHelpers.getParameterTypes(args);
                }
                parameterTypes[i] = argsClasses[i];
            }
            ++i;
        }
        return XposedHelpers.findConstructorBestMatch(clazz, parameterTypes);
    }

    public static void setObjectField(Object obj, String fieldName, Object value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).set(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setBooleanField(Object obj, String fieldName, boolean value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setBoolean(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setByteField(Object obj, String fieldName, byte value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setByte(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setCharField(Object obj, String fieldName, char value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setChar(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setDoubleField(Object obj, String fieldName, double value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setDouble(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setFloatField(Object obj, String fieldName, float value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setFloat(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setIntField(Object obj, String fieldName, int value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setInt(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setLongField(Object obj, String fieldName, long value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setLong(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setShortField(Object obj, String fieldName, short value) {
        try {
            XposedHelpers.findField(obj.getClass(), fieldName).setShort(obj, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static Object getObjectField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).get(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static Object getSurroundingThis(Object obj) {
        return XposedHelpers.getObjectField(obj, "this$0");
    }

    public static boolean getBooleanField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getBoolean(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static byte getByteField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getByte(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static char getCharField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getChar(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static double getDoubleField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getDouble(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static float getFloatField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getFloat(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static int getIntField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getInt(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static long getLongField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getLong(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static short getShortField(Object obj, String fieldName) {
        try {
            return XposedHelpers.findField(obj.getClass(), fieldName).getShort(obj);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticObjectField(Class<?> clazz, String fieldName, Object value) {
        try {
            XposedHelpers.findField(clazz, fieldName).set(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticBooleanField(Class<?> clazz, String fieldName, boolean value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setBoolean(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticByteField(Class<?> clazz, String fieldName, byte value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setByte(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticCharField(Class<?> clazz, String fieldName, char value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setChar(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticDoubleField(Class<?> clazz, String fieldName, double value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setDouble(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticFloatField(Class<?> clazz, String fieldName, float value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setFloat(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticIntField(Class<?> clazz, String fieldName, int value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setInt(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticLongField(Class<?> clazz, String fieldName, long value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setLong(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setStaticShortField(Class<?> clazz, String fieldName, short value) {
        try {
            XposedHelpers.findField(clazz, fieldName).setShort(null, value);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static Object getStaticObjectField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).get(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static boolean getStaticBooleanField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getBoolean(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static byte getStaticByteField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getByte(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static char getStaticCharField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getChar(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static double getStaticDoubleField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getDouble(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static float getStaticFloatField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getFloat(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static int getStaticIntField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getInt(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static long getStaticLongField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getLong(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static short getStaticShortField(Class<?> clazz, String fieldName) {
        try {
            return XposedHelpers.findField(clazz, fieldName).getShort(null);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static Object callMethod(Object obj, String methodName, Object ... args) {
        try {
            return XposedHelpers.findMethodBestMatch(obj.getClass(), methodName, args).invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
    }

    public static Object callMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return XposedHelpers.findMethodBestMatch(obj.getClass(), methodName, parameterTypes, args).invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
    }

    public static Object callStaticMethod(Class<?> clazz, String methodName, Object ... args) {
        try {
            return XposedHelpers.findMethodBestMatch(clazz, methodName, args).invoke(null, args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
    }

    public static Object callStaticMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return XposedHelpers.findMethodBestMatch(clazz, methodName, parameterTypes, args).invoke(null, args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
    }

    public static Object newInstance(Class<?> clazz, Object ... args) {
        try {
            return XposedHelpers.findConstructorBestMatch(clazz, args).newInstance(args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
    }

    public static Object newInstance(Class<?> clazz, Class<?>[] parameterTypes, Object ... args) {
        try {
            return XposedHelpers.findConstructorBestMatch(clazz, parameterTypes, args).newInstance(args);
        }
        catch (IllegalAccessException e) {
            DexposedBridge.log(e);
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetError(e.getCause());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object setAdditionalInstanceField(Object obj, String key, Object value) {
        HashMap<String, Object> objectFields;
        if (obj == null) {
            throw new NullPointerException("object must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        AbstractMap abstractMap = additionalFields;
        synchronized (abstractMap) {
            objectFields = additionalFields.get(obj);
            if (objectFields == null) {
                objectFields = new HashMap();
                additionalFields.put(obj, objectFields);
            }
        }
        abstractMap = objectFields;
        synchronized (abstractMap) {
            return objectFields.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getAdditionalInstanceField(Object obj, String key) {
        HashMap<String, Object> objectFields;
        if (obj == null) {
            throw new NullPointerException("object must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        WeakHashMap<Object, HashMap<String, Object>> weakHashMap = additionalFields;
        synchronized (weakHashMap) {
            objectFields = additionalFields.get(obj);
            if (objectFields == null) {
                return null;
            }
        }
        HashMap<String, Object> hashMap = objectFields;
        synchronized (hashMap) {
            return objectFields.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object removeAdditionalInstanceField(Object obj, String key) {
        HashMap<String, Object> objectFields;
        if (obj == null) {
            throw new NullPointerException("object must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        WeakHashMap<Object, HashMap<String, Object>> weakHashMap = additionalFields;
        synchronized (weakHashMap) {
            objectFields = additionalFields.get(obj);
            if (objectFields == null) {
                return null;
            }
        }
        HashMap<String, Object> hashMap = objectFields;
        synchronized (hashMap) {
            return objectFields.remove(key);
        }
    }

    public static Object setAdditionalStaticField(Object obj, String key, Object value) {
        return XposedHelpers.setAdditionalInstanceField(obj.getClass(), key, value);
    }

    public static Object getAdditionalStaticField(Object obj, String key) {
        return XposedHelpers.getAdditionalInstanceField(obj.getClass(), key);
    }

    public static Object removeAdditionalStaticField(Object obj, String key) {
        return XposedHelpers.removeAdditionalInstanceField(obj.getClass(), key);
    }

    public static Object setAdditionalStaticField(Class<?> clazz, String key, Object value) {
        return XposedHelpers.setAdditionalInstanceField(clazz, key, value);
    }

    public static Object getAdditionalStaticField(Class<?> clazz, String key) {
        return XposedHelpers.getAdditionalInstanceField(clazz, key);
    }

    public static Object removeAdditionalStaticField(Class<?> clazz, String key) {
        return XposedHelpers.removeAdditionalInstanceField(clazz, key);
    }

    public static byte[] assetAsByteArray(Resources res, String path) throws IOException {
        int read;
        InputStream is = res.getAssets().open(path);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] temp = new byte[1024];
        while ((read = is.read(temp)) > 0) {
            buf.write(temp, 0, read);
        }
        is.close();
        return buf.toByteArray();
    }

    public static String getMD5Sum(String file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            ((InputStream)is).close();
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            return bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static class ClassNotFoundError
    extends Error {
        private static final long serialVersionUID = -1070936889459514628L;

        public ClassNotFoundError(Throwable cause) {
            super(cause);
        }

        public ClassNotFoundError(String detailMessage, Throwable cause) {
            super(detailMessage, cause);
        }
    }

    public static class InvocationTargetError
    extends Error {
        private static final long serialVersionUID = -1070936889459514628L;

        public InvocationTargetError(Throwable cause) {
            super(cause);
        }

        public InvocationTargetError(String detailMessage, Throwable cause) {
            super(detailMessage, cause);
        }
    }
}

