/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import android.content.Context;
import android.content.SharedPreferences;
import com.github.promeg.xlog_android.lib.XLogInitializer;

public class XLogConfig {
    public static final String XLOG_SharedPreferences = "xlog_settings";
    public static final String PREF_CONFIG = "xlog_config";
    public static final int NONE = 0;
    public static final int ANNOTATED = 1;
    public static final int SPECIFIED = 2;
    public static final int ALL = 3;

    private XLogConfig() {
    }

    public static ConfigBuilder newConfigBuilder(Context context) {
        return new ConfigBuilder(context);
    }

    public static void config(XLogInitializer initializer) {
        SharedPreferences sharedPreferences = initializer.getContext().getSharedPreferences(XLOG_SharedPreferences, 0);
        sharedPreferences.edit().putString(PREF_CONFIG, initializer.toString()).commit();
    }

    public static class ConfigBuilder {
        final Context mContext;
        int mBenchmark = 0;

        private ConfigBuilder(Context context) {
            this.mContext = context.getApplicationContext();
        }

        public ConfigBuilder benchmark(int benchmark) {
            this.mBenchmark = benchmark;
            return this;
        }

        public XLogInitializer build() {
            return new XLogInitializer(this.mContext, this.mBenchmark);
        }
    }
}

