/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarPagerAdapter;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.WeekView;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.WeekFields;

public class WeekPagerAdapter
extends CalendarPagerAdapter<WeekView> {
    public WeekPagerAdapter(MaterialCalendarView mcv) {
        super(mcv);
    }

    @Override
    protected WeekView createView(int position) {
        return new WeekView(this.mcv, this.getItem(position), this.mcv.getFirstDayOfWeek(), this.showWeekDays);
    }

    @Override
    protected int indexOf(WeekView view) {
        CalendarDay week = view.getFirstViewDay();
        return this.getRangeIndex().indexOf(week);
    }

    @Override
    protected boolean isInstanceOfView(Object object) {
        return object instanceof WeekView;
    }

    @Override
    protected DateRangeIndex createRangeIndex(CalendarDay min, CalendarDay max) {
        return new Weekly(min, max, this.mcv.getFirstDayOfWeek());
    }

    public static class Weekly
    implements DateRangeIndex {
        private final CalendarDay min;
        private final int count;
        private final DayOfWeek firstDayOfWeek;

        public Weekly(@NonNull CalendarDay min, @NonNull CalendarDay max, DayOfWeek firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            this.min = this.getFirstDayOfWeek(min);
            this.count = this.indexOf(max) + 1;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int indexOf(CalendarDay day) {
            WeekFields weekFields = WeekFields.of((DayOfWeek)this.firstDayOfWeek, (int)1);
            LocalDate temp = day.getDate().with(weekFields.dayOfWeek(), 1L);
            return (int)ChronoUnit.WEEKS.between((Temporal)this.min.getDate(), (Temporal)temp);
        }

        @Override
        public CalendarDay getItem(int position) {
            return CalendarDay.from(this.min.getDate().plusWeeks((long)position));
        }

        private CalendarDay getFirstDayOfWeek(@NonNull CalendarDay day) {
            LocalDate temp = day.getDate().with(WeekFields.of((DayOfWeek)this.firstDayOfWeek, (int)1).dayOfWeek(), 1L);
            return CalendarDay.from(temp);
        }
    }
}

