/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayView;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.WeekDayView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

abstract class CalendarPagerView
extends ViewGroup
implements View.OnClickListener,
View.OnLongClickListener {
    protected static final int DEFAULT_DAYS_IN_WEEK = 7;
    protected static final int DEFAULT_MAX_WEEKS = 6;
    protected static final int DAY_NAMES_ROW = 1;
    private static final Calendar tempWorkingCalendar = CalendarUtils.getInstance();
    private final ArrayList<WeekDayView> weekDayViews = new ArrayList();
    private final ArrayList<DecoratorResult> decoratorResults = new ArrayList();
    protected int showOtherDates = 4;
    private MaterialCalendarView mcv;
    private CalendarDay firstViewDay;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private int firstDayOfWeek;
    protected boolean showWeekDays;
    private final Collection<DayView> dayViews = new ArrayList<DayView>();

    public CalendarPagerView(@NonNull MaterialCalendarView view, CalendarDay firstViewDay, int firstDayOfWeek, boolean showWeekDays) {
        super(view.getContext());
        this.mcv = view;
        this.firstViewDay = firstViewDay;
        this.firstDayOfWeek = firstDayOfWeek;
        this.showWeekDays = showWeekDays;
        this.setClipChildren(false);
        this.setClipToPadding(false);
        if (showWeekDays) {
            this.buildWeekDays(this.resetAndGetWorkingCalendar());
        }
        this.buildDayViews(this.dayViews, this.resetAndGetWorkingCalendar());
    }

    private void buildWeekDays(Calendar calendar) {
        for (int i = 0; i < 7; ++i) {
            WeekDayView weekDayView = new WeekDayView(this.getContext(), CalendarUtils.getDayOfWeek(calendar));
            if (Build.VERSION.SDK_INT >= 16) {
                weekDayView.setImportantForAccessibility(2);
            }
            this.weekDayViews.add(weekDayView);
            this.addView((View)weekDayView);
            calendar.add(5, 1);
        }
    }

    protected void addDayView(Collection<DayView> dayViews, Calendar calendar) {
        CalendarDay day = CalendarDay.from(calendar);
        DayView dayView = new DayView(this.getContext(), day);
        dayView.setOnClickListener(this);
        dayView.setOnLongClickListener(this);
        dayViews.add(dayView);
        this.addView((View)dayView, (ViewGroup.LayoutParams)new LayoutParams());
        calendar.add(5, 1);
    }

    protected Calendar resetAndGetWorkingCalendar() {
        boolean removeRow;
        this.getFirstViewDay().copyTo(tempWorkingCalendar);
        tempWorkingCalendar.setFirstDayOfWeek(this.getFirstDayOfWeek());
        int dow = CalendarUtils.getDayOfWeek(tempWorkingCalendar);
        int delta = this.getFirstDayOfWeek() - dow;
        boolean bl = MaterialCalendarView.showOtherMonths(this.showOtherDates) ? delta >= 0 : (removeRow = delta > 0);
        if (removeRow) {
            delta -= 7;
        }
        tempWorkingCalendar.add(5, delta);
        return tempWorkingCalendar;
    }

    protected int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    protected abstract void buildDayViews(Collection<DayView> var1, Calendar var2);

    protected abstract boolean isDayEnabled(CalendarDay var1);

    void setDayViewDecorators(List<DecoratorResult> results) {
        this.decoratorResults.clear();
        if (results != null) {
            this.decoratorResults.addAll(results);
        }
        this.invalidateDecorators();
    }

    public void setWeekDayTextAppearance(int taId) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setDateTextAppearance(int taId) {
        for (DayView dayView : this.dayViews) {
            dayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setShowOtherDates(int showFlags) {
        this.showOtherDates = showFlags;
        this.updateUi();
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        for (DayView dayView : this.dayViews) {
            dayView.setOnClickListener(selectionEnabled ? this : null);
            dayView.setClickable(selectionEnabled);
        }
    }

    public void setSelectionColor(int color) {
        for (DayView dayView : this.dayViews) {
            dayView.setSelectionColor(color);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        for (WeekDayView dayView : this.weekDayViews) {
            dayView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        for (DayView dayView : this.dayViews) {
            dayView.setDayFormatter(formatter);
        }
    }

    public void setDayFormatterContentDescription(DayFormatter formatter) {
        for (DayView dayView : this.dayViews) {
            dayView.setDayFormatterContentDescription(formatter);
        }
    }

    public void setMinimumDate(CalendarDay minDate) {
        this.minDate = minDate;
        this.updateUi();
    }

    public void setMaximumDate(CalendarDay maxDate) {
        this.maxDate = maxDate;
        this.updateUi();
    }

    public void setSelectedDates(Collection<CalendarDay> dates) {
        for (DayView dayView : this.dayViews) {
            CalendarDay day = dayView.getDate();
            dayView.setChecked(dates != null && dates.contains(day));
        }
        this.postInvalidate();
    }

    protected void updateUi() {
        for (DayView dayView : this.dayViews) {
            CalendarDay day = dayView.getDate();
            dayView.setupSelection(this.showOtherDates, day.isInRange(this.minDate, this.maxDate), this.isDayEnabled(day));
        }
        this.postInvalidate();
    }

    protected void invalidateDecorators() {
        DayViewFacade facadeAccumulator = new DayViewFacade();
        for (DayView dayView : this.dayViews) {
            facadeAccumulator.reset();
            for (DecoratorResult result : this.decoratorResults) {
                if (!result.decorator.shouldDecorate(dayView.getDate())) continue;
                result.result.applyTo(facadeAccumulator);
            }
            dayView.applyFacade(facadeAccumulator);
        }
    }

    public void onClick(View v) {
        if (v instanceof DayView) {
            DayView dayView = (DayView)v;
            this.mcv.onDateClicked(dayView);
        }
    }

    public boolean onLongClick(View v) {
        if (v instanceof DayView) {
            DayView dayView = (DayView)v;
            this.mcv.onDateLongClicked(dayView);
            return true;
        }
        return false;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int specHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (specHeightMode == 0 || specWidthMode == 0) {
            throw new IllegalStateException("CalendarPagerView should never be left to decide it's size");
        }
        int measureTileWidth = specWidthSize / 7;
        int measureTileHeight = specHeightSize / this.getRows();
        this.setMeasuredDimension(specWidthSize, specHeightSize);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measureTileWidth, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measureTileHeight, (int)0x40000000);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    protected abstract int getRows();

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        boolean parentLeft = false;
        int childTop = 0;
        int childLeft = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
            childLeft += width;
            if (i % 7 != 6) continue;
            childLeft = 0;
            childTop += height;
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams();
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)CalendarPagerView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)CalendarPagerView.class.getName());
    }

    protected CalendarDay getFirstViewDay() {
        return this.firstViewDay;
    }

    protected static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams() {
            super(-2, -2);
        }
    }
}

