/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.widget.CheckedTextView;
import com.prolificinteractive.materialcalendarview.CalendarDay;

class DayView
extends CheckedTextView {
    private CalendarDay date = new CalendarDay();
    private int selectionColor = -7829368;
    private final int fadeTime = this.getResources().getInteger(0x10E0000);
    private Drawable customBackground = null;

    public DayView(Context context) {
        super(context);
        this.setSelectionColor(this.selectionColor);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        if (this.isInEditMode()) {
            this.setText("99");
        }
    }

    public void setDay(CalendarDay date) {
        this.date = date;
        this.setText(String.valueOf(date.getDay()));
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
        this.regenerateBackground();
    }

    public void setCustomBackground(Drawable customBackground) {
        this.customBackground = customBackground;
        this.regenerateBackground();
    }

    public CalendarDay getDate() {
        return this.date;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    protected void setupSelection(boolean showOtherDates, boolean inRange, boolean inMonth) {
        boolean enabled = inMonth && inRange;
        this.setEnabled(enabled);
        this.setVisibility(enabled || showOtherDates ? 0 : 4);
    }

    private void regenerateBackground() {
        this.setBackgroundDrawable(DayView.generateBackground(this.selectionColor, this.fadeTime, this.customBackground));
    }

    private static Drawable generateBackground(int color, int fadeTime, Drawable customBackground) {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.setExitFadeDuration(fadeTime);
        drawable2.addState(new int[]{0x10100A0}, DayView.generateCircleDrawable(color));
        if (Build.VERSION.SDK_INT >= 21) {
            drawable2.addState(new int[]{16842919}, DayView.generateRippleDrawable(color));
        } else {
            drawable2.addState(new int[]{16842919}, DayView.generateCircleDrawable(color));
        }
        if (customBackground == null) {
            drawable2.addState(new int[0], DayView.generateCircleDrawable(0));
        } else {
            drawable2.addState(new int[0], customBackground);
        }
        return drawable2;
    }

    private static Drawable generateCircleDrawable(final int color) {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new OvalShape());
        drawable2.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient(0.0f, 0.0f, 0.0f, 0.0f, color, color, Shader.TileMode.REPEAT);
            }
        });
        return drawable2;
    }

    @TargetApi(value=21)
    private static Drawable generateRippleDrawable(int color) {
        ColorStateList list = ColorStateList.valueOf((int)color);
        Drawable mask = DayView.generateCircleDrawable(-1);
        return new RippleDrawable(list, null, mask);
    }
}

