/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.utils;

import android.nfc.tech.IsoDep;
import android.util.Log;
import com.pro100svitlo.creditCardNfcReader.enums.SwEnum;
import com.pro100svitlo.creditCardNfcReader.exception.CommunicationException;
import com.pro100svitlo.creditCardNfcReader.parser.IProvider;
import com.pro100svitlo.creditCardNfcReader.utils.BytesUtils;
import com.pro100svitlo.creditCardNfcReader.utils.TlvUtil;
import java.io.IOException;

public class Provider
implements IProvider {
    private static final String TAG = Provider.class.getName();
    private StringBuffer log = new StringBuffer();
    private IsoDep mTagCom;

    public void setmTagCom(IsoDep mTagCom) {
        this.mTagCom = mTagCom;
    }

    public StringBuffer getLog() {
        return this.log;
    }

    @Override
    public byte[] transceive(byte[] pCommand) throws CommunicationException {
        this.log.append("=================<br/>");
        this.log.append("<font color='green'><b>send:</b> " + BytesUtils.bytesToString(pCommand)).append("</font><br/>");
        byte[] response = null;
        try {
            response = this.mTagCom.transceive(pCommand);
        }
        catch (IOException e) {
            throw new CommunicationException(e.getMessage());
        }
        this.log.append("<font color='blue'><b>resp:</b> " + BytesUtils.bytesToString(response)).append("</font><br/>");
        Log.d((String)TAG, (String)("resp: " + BytesUtils.bytesToString(response)));
        try {
            Log.d((String)TAG, (String)("resp: " + TlvUtil.prettyPrintAPDUResponse(response)));
            SwEnum val = SwEnum.getSW(response);
            if (val != null) {
                Log.d((String)TAG, (String)("resp: " + val.getDetail()));
            }
            this.log.append("<pre>").append(TlvUtil.prettyPrintAPDUResponse(response).replace("\n", "<br/>").replace(" ", "&nbsp;")).append("</pre><br/>");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }
}

