/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.utils;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.apache.commons.collections4.MultiMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class AtrUtils {
    private static String TAG = "creditCardNfcReader";
    private static final MultiMap<String, String> MAP = new MultiValueMap();

    public static final Collection<String> getDescription(String pAtr) {
        Collection ret = null;
        if (StringUtils.isNotBlank((CharSequence)pAtr)) {
            String val = StringUtils.deleteWhitespace((String)pAtr);
            for (String key : MAP.keySet()) {
                if (!val.matches("^" + key + "$")) continue;
                ret = (Collection)MAP.get((Object)key);
                break;
            }
        }
        return ret;
    }

    public static final Collection<String> getDescriptionFromAts(String pAts) {
        Collection ret = null;
        if (StringUtils.isNotBlank((CharSequence)pAts)) {
            String val = StringUtils.deleteWhitespace((String)pAts);
            for (String key : MAP.keySet()) {
                if (!key.contains(val)) continue;
                ret = (Collection)MAP.get((Object)key);
                break;
            }
        }
        return ret;
    }

    private AtrUtils() {
    }

    static {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            is = AtrUtils.class.getResourceAsStream("/smartcard_list.txt");
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            int lineNumber = 0;
            String currentATR = null;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.startsWith("\t") && currentATR != null) {
                    MAP.put((Object)currentATR, (Object)line.replace("\t", "").trim());
                    continue;
                }
                if (line.startsWith("3")) {
                    currentATR = StringUtils.deleteWhitespace((String)line.toUpperCase());
                    continue;
                }
                Log.d((String)TAG, (String)("Encountered unexpected line in atr list: currentATR=" + currentATR + " Line(" + lineNumber + ") = " + line));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)br);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)is);
    }
}

