/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.parser.apdu.impl;

import com.pro100svitlo.creditCardNfcReader.iso7816emv.ITag;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.TagAndLength;
import com.pro100svitlo.creditCardNfcReader.model.AbstractData;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.IFile;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation.AnnotationData;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation.AnnotationUtils;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.impl.DataFactory;
import fr.devnied.bitlib.BitUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractByteBean<T>
extends AbstractData
implements IFile {
    private static final long serialVersionUID = -2016039522844322383L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractByteBean.class.getName());

    private Collection<AnnotationData> getAnnotationSet(List<TagAndLength> pTags) {
        ArrayList<AnnotationData> ret = null;
        if (pTags != null) {
            Map<ITag, AnnotationData> data = AnnotationUtils.getInstance().getMap().get(this.getClass().getName());
            ret = new ArrayList<AnnotationData>(data.size());
            for (TagAndLength tal : pTags) {
                AnnotationData ann = data.get(tal.getTag());
                if (ann != null) {
                    ann.setSize(tal.getLength() * 8);
                } else {
                    ann = new AnnotationData();
                    ann.setSkip(true);
                    ann.setSize(tal.getLength() * 8);
                }
                ret.add(ann);
            }
        } else {
            ret = (ArrayList<AnnotationData>)((Object)AnnotationUtils.getInstance().getMapSet().get(this.getClass().getName()));
        }
        return ret;
    }

    @Override
    public void parse(byte[] pData, List<TagAndLength> pTags) {
        Collection<AnnotationData> set = this.getAnnotationSet(pTags);
        BitUtils bit = new BitUtils(pData);
        for (AnnotationData data : set) {
            if (data.isSkip()) {
                bit.addCurrentBitIndex(data.getSize());
                continue;
            }
            Object obj = DataFactory.getObject(data, bit);
            this.setField(data.getField(), this, obj);
        }
    }

    protected void setField(Field field, IFile pData, Object pValue) {
        if (field != null) {
            try {
                field.set(pData, pValue);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Parameters of fied.set are not valid", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Impossible to set the Field :" + field.getName(), (Throwable)e);
            }
        }
    }
}

