/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.iso7816emv.impl;

import com.pro100svitlo.creditCardNfcReader.enums.TagTypeEnum;
import com.pro100svitlo.creditCardNfcReader.enums.TagValueTypeEnum;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.ITag;
import com.pro100svitlo.creditCardNfcReader.utils.BytesUtils;
import java.util.Arrays;

public final class TagImpl
implements ITag {
    private final byte[] idBytes;
    public final String name;
    private final String description;
    private final TagValueTypeEnum tagValueType;
    private final ITag.Class tagClass;
    private final TagTypeEnum type;

    public TagImpl(String id, TagValueTypeEnum tagValueType, String name, String description) {
        this(BytesUtils.fromString(id), tagValueType, name, description);
    }

    public TagImpl(byte[] idBytes, TagValueTypeEnum tagValueType, String name, String description) {
        if (idBytes == null) {
            throw new IllegalArgumentException("Param id cannot be null");
        }
        if (idBytes.length == 0) {
            throw new IllegalArgumentException("Param id cannot be empty");
        }
        if (tagValueType == null) {
            throw new IllegalArgumentException("Param tagValueType cannot be null");
        }
        this.idBytes = idBytes;
        this.name = name;
        this.description = description;
        this.tagValueType = tagValueType;
        this.type = BytesUtils.matchBitByBitIndex(this.idBytes[0], 5) ? TagTypeEnum.CONSTRUCTED : TagTypeEnum.PRIMITIVE;
        byte classValue = (byte)(this.idBytes[0] >>> 6 & 3);
        switch (classValue) {
            case 1: {
                this.tagClass = ITag.Class.APPLICATION;
                break;
            }
            case 2: {
                this.tagClass = ITag.Class.CONTEXT_SPECIFIC;
                break;
            }
            case 3: {
                this.tagClass = ITag.Class.PRIVATE;
                break;
            }
            default: {
                this.tagClass = ITag.Class.UNIVERSAL;
            }
        }
    }

    @Override
    public boolean isConstructed() {
        return this.type == TagTypeEnum.CONSTRUCTED;
    }

    @Override
    public byte[] getTagBytes() {
        return this.idBytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public TagValueTypeEnum getTagValueType() {
        return this.tagValueType;
    }

    @Override
    public TagTypeEnum getType() {
        return this.type;
    }

    @Override
    public ITag.Class getTagClass() {
        return this.tagClass;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ITag)) {
            return false;
        }
        ITag that = (ITag)other;
        if (this.getTagBytes().length != that.getTagBytes().length) {
            return false;
        }
        return Arrays.equals(this.getTagBytes(), that.getTagBytes());
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Arrays.hashCode(this.idBytes);
        return hash;
    }

    @Override
    public int getNumTagBytes() {
        return this.idBytes.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tag[");
        sb.append(BytesUtils.bytesToString(this.getTagBytes()));
        sb.append("] Name=");
        sb.append(this.getName());
        sb.append(", TagType=");
        sb.append((Object)this.getType());
        sb.append(", ValueType=");
        sb.append((Object)this.getTagValueType());
        sb.append(", Class=");
        sb.append((Object)this.tagClass);
        return sb.toString();
    }
}

