/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.core;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.enums.ShowPattern;
import com.lzf.easyfloat.enums.SidePattern;
import com.lzf.easyfloat.interfaces.FloatCallbacks;
import com.lzf.easyfloat.utils.DisplayUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002J \u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J&\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'J\u001e\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/lzf/easyfloat/core/TouchUtils;", "", "context", "Landroid/content/Context;", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "(Landroid/content/Context;Lcom/lzf/easyfloat/data/FloatConfig;)V", "bottomBorder", "", "bottomDistance", "getConfig", "()Lcom/lzf/easyfloat/data/FloatConfig;", "getContext", "()Landroid/content/Context;", "emptyHeight", "lastX", "", "lastY", "leftBorder", "leftDistance", "location", "", "minX", "minY", "parentHeight", "parentRect", "Landroid/graphics/Rect;", "parentWidth", "rightBorder", "rightDistance", "statusBarHeight", "topBorder", "topDistance", "dragEnd", "", "view", "Landroid/view/View;", "initBoarderValue", "params", "Landroid/view/WindowManager$LayoutParams;", "initDistanceValue", "sideAnim", "windowManager", "Landroid/view/WindowManager;", "updateFloat", "event", "Landroid/view/MotionEvent;", "easyfloat_release"})
public final class TouchUtils {
    @NotNull
    private final Context context;
    @NotNull
    private final FloatConfig config;
    @NotNull
    private Rect parentRect;
    private int parentHeight;
    private int parentWidth;
    private int leftBorder;
    private int topBorder;
    private int rightBorder;
    private int bottomBorder;
    private float lastX;
    private float lastY;
    private int leftDistance;
    private int rightDistance;
    private int topDistance;
    private int bottomDistance;
    private int minX;
    private int minY;
    @NotNull
    private final int[] location;
    private int statusBarHeight;
    private int emptyHeight;

    public TouchUtils(@NotNull Context context, @NotNull FloatConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        this.parentRect = new Rect();
        this.location = new int[2];
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final FloatConfig getConfig() {
        return this.config;
    }

    public final void updateFloat(@NotNull View view, @NotNull MotionEvent event, @NotNull WindowManager windowManager, @NotNull WindowManager.LayoutParams params) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Object object3 = this.config.getCallbacks();
        if (object3 != null) {
            object3.touchEvent(view, event);
        }
        object3 = this.config.getFloatCallbacks();
        if (object3 != null && (object2 = ((FloatCallbacks)object3).getBuilder()) != null && (object = ((FloatCallbacks.Builder)object2).getTouchEvent$easyfloat_release()) != null) {
            object.invoke((Object)view, (Object)event);
        }
        if (!this.config.getDragEnable() || this.config.isAnim()) {
            this.config.setDrag(false);
            return;
        }
        int n = event.getAction() & 0xFF;
        block0 : switch (n) {
            case 0: {
                this.config.setDrag(false);
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                this.initBoarderValue(view, params);
                break;
            }
            case 2: {
                Function2<View, MotionEvent, Unit> function2;
                FloatCallbacks.Builder builder;
                if (event.getRawX() < (float)this.leftBorder || event.getRawX() > (float)(this.rightBorder + view.getWidth()) || event.getRawY() < (float)this.topBorder || event.getRawY() > (float)(this.bottomBorder + view.getHeight())) {
                    return;
                }
                float dx = event.getRawX() - this.lastX;
                float dy = event.getRawY() - this.lastY;
                if (!this.config.isDrag() && dx * dx + dy * dy < 81.0f) {
                    return;
                }
                this.config.setDrag(true);
                int x = params.x + (int)dx;
                int y = params.y + (int)dy;
                int n2 = x < this.leftBorder ? this.leftBorder : (x = x > this.rightBorder ? this.rightBorder : x);
                if (this.config.getShowPattern() == ShowPattern.CURRENT_ACTIVITY && y < this.statusBarHeight(view) && !this.config.getImmersionStatusBar()) {
                    y = this.statusBarHeight(view);
                }
                y = y < this.topBorder ? this.topBorder : (y < 0 ? (this.config.getImmersionStatusBar() ? (y < -this.statusBarHeight ? -this.statusBarHeight : y) : 0) : (y > this.bottomBorder ? this.bottomBorder : y));
                Object object4 = this.config.getSidePattern();
                int n3 = WhenMappings.$EnumSwitchMapping$0[((Enum)object4).ordinal()];
                switch (n3) {
                    case 1: {
                        x = 0;
                        break;
                    }
                    case 2: {
                        x = this.parentWidth - view.getWidth();
                        break;
                    }
                    case 3: {
                        y = 0;
                        break;
                    }
                    case 4: {
                        y = this.emptyHeight;
                        break;
                    }
                    case 5: {
                        x = event.getRawX() * (float)2 > (float)this.parentWidth ? this.parentWidth - view.getWidth() : 0;
                        break;
                    }
                    case 6: {
                        y = (event.getRawY() - (float)this.parentRect.top) * (float)2 > (float)this.parentHeight ? this.parentHeight - view.getHeight() : 0;
                        break;
                    }
                    case 7: {
                        this.leftDistance = (int)event.getRawX();
                        this.rightDistance = this.parentWidth - (int)event.getRawX();
                        this.topDistance = (int)event.getRawY() - this.parentRect.top;
                        this.bottomDistance = this.parentHeight + this.parentRect.top - (int)event.getRawY();
                        int n4 = this.leftDistance;
                        int n5 = this.rightDistance;
                        boolean bl = false;
                        this.minX = Math.min(n4, n5);
                        n4 = this.topDistance;
                        n5 = this.bottomDistance;
                        bl = false;
                        this.minY = Math.min(n4, n5);
                        if (this.minX < this.minY) {
                            x = this.leftDistance == this.minX ? 0 : this.parentWidth - view.getWidth();
                            break;
                        }
                        y = this.topDistance == this.minY ? 0 : this.emptyHeight;
                    }
                }
                params.x = x;
                params.y = y;
                windowManager.updateViewLayout(view, (ViewGroup.LayoutParams)params);
                object4 = this.config.getCallbacks();
                if (object4 != null) {
                    object4.drag(view, event);
                }
                object4 = this.config.getFloatCallbacks();
                if (object4 != null && (builder = ((FloatCallbacks)object4).getBuilder()) != null && (function2 = builder.getDrag$easyfloat_release()) != null) {
                    function2.invoke((Object)view, (Object)event);
                }
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                break;
            }
            case 1: 
            case 3: {
                Function1<View, Unit> function1;
                FloatCallbacks.Builder builder;
                Object object5;
                if (!this.config.isDrag()) {
                    return;
                }
                object2 = this.config.getCallbacks();
                if (object2 != null) {
                    object2.drag(view, event);
                }
                object2 = this.config.getFloatCallbacks();
                if (object2 != null && (object = ((FloatCallbacks)object2).getBuilder()) != null && (object5 = ((FloatCallbacks.Builder)object).getDrag$easyfloat_release()) != null) {
                    object5.invoke((Object)view, (Object)event);
                }
                object2 = this.config.getSidePattern();
                int n6 = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
                switch (n6) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        this.sideAnim(view, params, windowManager);
                        break block0;
                    }
                }
                object5 = this.config.getCallbacks();
                if (object5 != null) {
                    object5.dragEnd(view);
                }
                object5 = this.config.getFloatCallbacks();
                if (object5 == null || (builder = ((FloatCallbacks)object5).getBuilder()) == null || (function1 = builder.getDragEnd$easyfloat_release()) == null) break;
                function1.invoke((Object)view);
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void updateFloat(@NotNull View view, @NotNull WindowManager.LayoutParams params, @NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        this.initBoarderValue(view, params);
        this.sideAnim(view, params, windowManager);
    }

    private final void initBoarderValue(View view, WindowManager.LayoutParams params) {
        int n;
        this.parentWidth = DisplayUtils.INSTANCE.getScreenWidth(this.context);
        this.parentHeight = this.config.getDisplayHeight().getDisplayRealHeight(this.context);
        view.getLocationOnScreen(this.location);
        this.statusBarHeight = this.location[1] > params.y ? this.statusBarHeight(view) : 0;
        this.emptyHeight = this.parentHeight - view.getHeight() - this.statusBarHeight;
        int n2 = 0;
        int n3 = this.config.getLeftBorder();
        boolean bl = false;
        this.leftBorder = Math.max(n2, n3);
        n2 = this.parentWidth;
        n3 = this.config.getRightBorder();
        bl = false;
        this.rightBorder = Math.min(n2, n3) - view.getWidth();
        int n4 = this.config.getShowPattern() == ShowPattern.CURRENT_ACTIVITY ? (this.config.getImmersionStatusBar() ? this.config.getTopBorder() : this.config.getTopBorder() + this.statusBarHeight(view)) : (this.topBorder = this.config.getImmersionStatusBar() ? this.config.getTopBorder() - this.statusBarHeight(view) : this.config.getTopBorder());
        if (this.config.getShowPattern() == ShowPattern.CURRENT_ACTIVITY) {
            if (this.config.getImmersionStatusBar()) {
                n2 = this.emptyHeight;
                n3 = this.config.getBottomBorder() - view.getHeight();
                bl = false;
                n = Math.min(n2, n3);
            } else {
                n2 = this.emptyHeight;
                n3 = this.config.getBottomBorder() + this.statusBarHeight(view) - view.getHeight();
                bl = false;
                n = Math.min(n2, n3);
            }
        } else if (this.config.getImmersionStatusBar()) {
            n2 = this.emptyHeight;
            n3 = this.config.getBottomBorder() - this.statusBarHeight(view) - view.getHeight();
            bl = false;
            n = Math.min(n2, n3);
        } else {
            n2 = this.emptyHeight;
            n3 = this.config.getBottomBorder() - view.getHeight();
            bl = false;
            n = Math.min(n2, n3);
        }
        this.bottomBorder = n;
    }

    private final void sideAnim(View view, WindowManager.LayoutParams params, WindowManager windowManager) {
        int n;
        this.initDistanceValue(params);
        boolean isX = false;
        SidePattern sidePattern = this.config.getSidePattern();
        int n2 = WhenMappings.$EnumSwitchMapping$0[sidePattern.ordinal()];
        switch (n2) {
            case 8: {
                isX = true;
                n = this.leftBorder;
                break;
            }
            case 9: {
                isX = true;
                n = params.x + this.rightDistance;
                break;
            }
            case 12: {
                isX = true;
                if (this.leftDistance < this.rightDistance) {
                    n = this.leftBorder;
                    break;
                }
                n = params.x + this.rightDistance;
                break;
            }
            case 10: {
                isX = false;
                n = this.topBorder;
                break;
            }
            case 11: {
                isX = false;
                n = this.bottomBorder;
                break;
            }
            case 13: {
                isX = false;
                if (this.topDistance < this.bottomDistance) {
                    n = this.topBorder;
                    break;
                }
                n = this.bottomBorder;
                break;
            }
            case 14: {
                if (this.minX < this.minY) {
                    isX = true;
                    if (this.leftDistance < this.rightDistance) {
                        n = this.leftBorder;
                        break;
                    }
                    n = params.x + this.rightDistance;
                    break;
                }
                isX = false;
                if (this.topDistance < this.bottomDistance) {
                    n = this.topBorder;
                    break;
                }
                n = this.bottomBorder;
                break;
            }
            default: {
                return;
            }
        }
        int end = n;
        int[] nArray = new int[]{isX ? params.x : params.y, end};
        ValueAnimator animator = ValueAnimator.ofInt((int[])nArray);
        animator.addUpdateListener(arg_0 -> TouchUtils.sideAnim$lambda-0(isX, params, windowManager, view, animator, arg_0));
        animator.addListener(new Animator.AnimatorListener(this, view){
            final /* synthetic */ TouchUtils this$0;
            final /* synthetic */ View $view;
            {
                this.this$0 = $receiver;
                this.$view = $view;
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                TouchUtils.access$dragEnd(this.this$0, this.$view);
            }

            public void onAnimationCancel(@Nullable Animator animation) {
                TouchUtils.access$dragEnd(this.this$0, this.$view);
            }

            public void onAnimationStart(@Nullable Animator animation) {
                this.this$0.getConfig().setAnim(true);
            }
        });
        animator.start();
    }

    private final void dragEnd(View view) {
        Function1<View, Unit> function1;
        FloatCallbacks.Builder builder;
        this.config.setAnim(false);
        Object object = this.config.getCallbacks();
        if (object != null) {
            object.dragEnd(view);
        }
        object = this.config.getFloatCallbacks();
        if (object != null && (builder = ((FloatCallbacks)object).getBuilder()) != null && (function1 = builder.getDragEnd$easyfloat_release()) != null) {
            function1.invoke((Object)view);
        }
    }

    private final void initDistanceValue(WindowManager.LayoutParams params) {
        this.leftDistance = params.x - this.leftBorder;
        this.rightDistance = this.rightBorder - params.x;
        this.topDistance = params.y - this.topBorder;
        this.bottomDistance = this.bottomBorder - params.y;
        int n = this.leftDistance;
        int n2 = this.rightDistance;
        boolean bl = false;
        this.minX = Math.min(n, n2);
        n = this.topDistance;
        n2 = this.bottomDistance;
        bl = false;
        this.minY = Math.min(n, n2);
    }

    private final int statusBarHeight(View view) {
        return DisplayUtils.INSTANCE.statusBarHeight(view);
    }

    private static final void sideAnim$lambda-0(boolean $isX, WindowManager.LayoutParams $params, WindowManager $windowManager, View $view, ValueAnimator $animator, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Intrinsics.checkNotNullParameter((Object)$windowManager, (String)"$windowManager");
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        try {
            if ($isX) {
                Object object = it.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                $params.x = (Integer)object;
            } else {
                Object object = it.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                $params.y = (Integer)object;
            }
            $windowManager.updateViewLayout($view, (ViewGroup.LayoutParams)$params);
        }
        catch (Exception e) {
            $animator.cancel();
        }
    }

    public static final /* synthetic */ void access$dragEnd(TouchUtils $this, View view) {
        $this.dragEnd(view);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SidePattern.values().length];
            nArray[SidePattern.LEFT.ordinal()] = 1;
            nArray[SidePattern.RIGHT.ordinal()] = 2;
            nArray[SidePattern.TOP.ordinal()] = 3;
            nArray[SidePattern.BOTTOM.ordinal()] = 4;
            nArray[SidePattern.AUTO_HORIZONTAL.ordinal()] = 5;
            nArray[SidePattern.AUTO_VERTICAL.ordinal()] = 6;
            nArray[SidePattern.AUTO_SIDE.ordinal()] = 7;
            nArray[SidePattern.RESULT_LEFT.ordinal()] = 8;
            nArray[SidePattern.RESULT_RIGHT.ordinal()] = 9;
            nArray[SidePattern.RESULT_TOP.ordinal()] = 10;
            nArray[SidePattern.RESULT_BOTTOM.ordinal()] = 11;
            nArray[SidePattern.RESULT_HORIZONTAL.ordinal()] = 12;
            nArray[SidePattern.RESULT_VERTICAL.ordinal()] = 13;
            nArray[SidePattern.RESULT_SIDE.ordinal()] = 14;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

