/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.lzf.easyfloat.permission.rom.RomUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/lzf/easyfloat/utils/DisplayUtils;", "", "()V", "TAG", "", "dp2px", "", "context", "Landroid/content/Context;", "dpVal", "", "getNavigationBarCurrentHeight", "getNavigationBarHeight", "getScreenHeight", "getScreenSize", "Landroid/graphics/Point;", "getScreenWidth", "getStatusBarHeight", "hasNavigationBar", "", "isHasNavigationBar", "isHuaWeiHideNav", "isMiuiFullScreen", "isVivoFullScreen", "px2dp", "pxVal", "px2sp", "pxValue", "rejectedNavHeight", "sp2px", "spValue", "statusBarHeight", "view", "Landroid/view/View;", "easyfloat_release"})
public final class DisplayUtils {
    private static final String TAG = "DisplayUtils--->";
    @NotNull
    public static final DisplayUtils INSTANCE;

    public final int px2dp(@NotNull Context context, float pxVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(pxVal / density + 0.5f);
    }

    public final int dp2px(@NotNull Context context, float dpVal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(dpVal * density + 0.5f);
    }

    public final int px2sp(@NotNull Context context, float pxValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        DisplayMetrics outMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getScreenSize((Context)context).y;
    }

    @NotNull
    public final Point getScreenSize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point point = new Point();
        boolean bl = false;
        boolean bl2 = false;
        Point $this$apply = point;
        boolean bl3 = false;
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        display.getRealSize($this$apply);
        return point;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public final int statusBarHeight(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"view.context.applicationContext");
        return this.getStatusBarHeight(context2);
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public final int getNavigationBarCurrentHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.hasNavigationBar(context) ? this.getNavigationBarHeight(context) : 0;
    }

    public final boolean hasNavigationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getNavigationBarHeight(context) == 0 ? false : (RomUtils.INSTANCE.checkIsHuaweiRom() && this.isHuaWeiHideNav(context) ? false : (RomUtils.INSTANCE.checkIsMiuiRom() && this.isMiuiFullScreen(context) ? false : (RomUtils.INSTANCE.checkIsVivoRom() && this.isVivoFullScreen(context) ? false : this.isHasNavigationBar(context))));
    }

    public final int rejectedNavHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point point = this.getScreenSize(context);
        if (point.x > point.y) {
            return point.y;
        }
        return point.y - this.getNavigationBarCurrentHeight(context);
    }

    private final boolean isHuaWeiHideNav(Context context) {
        return (Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0) : Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0)) != 0;
    }

    private final boolean isMiuiFullScreen(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0;
    }

    private final boolean isVivoFullScreen(Context context) {
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_gesture_on", (int)0) != 0;
    }

    private final boolean isHasNavigationBar(Context context) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display d = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            d.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        if (displayHeight + this.getNavigationBarHeight(context) > realHeight) {
            return false;
        }
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    private DisplayUtils() {
    }

    static {
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
    }
}

