/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.permission.rom;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.util.Log;
import android.widget.Toast;
import com.lzf.easyfloat.permission.rom.RomUtils;
import java.lang.reflect.Method;

public class HuaweiUtils {
    private static final String TAG = "HuaweiUtils";

    public static boolean checkFloatWindowPermission(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return HuaweiUtils.checkOp(context, 24);
        }
        return true;
    }

    public static void applyPermission(Fragment fragment) {
        try {
            Intent intent = new Intent();
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.systemmanager.addviewmonitor.AddViewMonitorActivity");
            intent.setComponent(comp);
            if (RomUtils.getEmuiVersion() == 3.1) {
                fragment.startActivityForResult(intent, 199);
            } else {
                comp = new ComponentName("com.huawei.systemmanager", "com.huawei.notificationmanager.ui.NotificationManagmentActivity");
                intent.setComponent(comp);
                fragment.startActivityForResult(intent, 199);
            }
        }
        catch (SecurityException e) {
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            fragment.startActivityForResult(intent, 199);
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        catch (ActivityNotFoundException e) {
            Intent intent = new Intent();
            ComponentName comp = new ComponentName("com.Android.settings", "com.android.settings.permission.TabItem");
            intent.setComponent(comp);
            fragment.startActivityForResult(intent, 199);
            e.printStackTrace();
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        catch (Exception e) {
            Toast.makeText((Context)fragment.getActivity(), (CharSequence)"\u8fdb\u5165\u8bbe\u7f6e\u9875\u9762\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u8bbe\u7f6e", (int)1).show();
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @TargetApi(value=19)
    private static boolean checkOp(Context context, int op) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            try {
                Class<AppOpsManager> clazz = AppOpsManager.class;
                Method method = clazz.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                return 0 == (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        } else {
            Log.e((String)TAG, (String)"Below API 19 cannot invoke!");
        }
        return false;
    }
}

