/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.anim;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.lzf.easyfloat.anim.DefaultAnimator$WhenMappings;
import com.lzf.easyfloat.enums.SidePattern;
import com.lzf.easyfloat.interfaces.OnFloatAnimator;
import com.lzf.easyfloat.utils.DisplayUtils;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J:\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/lzf/easyfloat/anim/DefaultAnimator;", "Lcom/lzf/easyfloat/interfaces/OnFloatAnimator;", "()V", "enterAnim", "Landroid/animation/Animator;", "view", "Landroid/view/View;", "params", "Landroid/view/WindowManager$LayoutParams;", "windowManager", "Landroid/view/WindowManager;", "sidePattern", "Lcom/lzf/easyfloat/enums/SidePattern;", "exitAnim", "getAnimator", "isExit", "", "getCompensationHeight", "", "initValue", "Lkotlin/Triple;", "easyfloat_release"})
public class DefaultAnimator
implements OnFloatAnimator {
    @Override
    @Nullable
    public Animator enterAnim(@NotNull View view, @NotNull WindowManager.LayoutParams params, @NotNull WindowManager windowManager, @NotNull SidePattern sidePattern) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)((Object)sidePattern), (String)"sidePattern");
        return this.getAnimator(view, params, windowManager, sidePattern, false);
    }

    @Override
    @Nullable
    public Animator exitAnim(@NotNull View view, @NotNull WindowManager.LayoutParams params, @NotNull WindowManager windowManager, @NotNull SidePattern sidePattern) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)((Object)sidePattern), (String)"sidePattern");
        return this.getAnimator(view, params, windowManager, sidePattern, true);
    }

    private final Animator getAnimator(View view, WindowManager.LayoutParams params, WindowManager windowManager, SidePattern sidePattern, boolean isExit) {
        Triple<Integer, Integer, Boolean> triple = this.initValue(view, params, windowManager, sidePattern);
        int start = isExit ? ((Number)triple.getSecond()).intValue() : ((Number)triple.getFirst()).intValue();
        int end = isExit ? ((Number)triple.getFirst()).intValue() : ((Number)triple.getSecond()).intValue();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{start, end});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener($this$apply, triple, params, windowManager, view){
            final /* synthetic */ ValueAnimator $this_apply;
            final /* synthetic */ Triple $triple$inlined;
            final /* synthetic */ WindowManager.LayoutParams $params$inlined;
            final /* synthetic */ WindowManager $windowManager$inlined;
            final /* synthetic */ View $view$inlined;
            {
                this.$this_apply = valueAnimator;
                this.$triple$inlined = triple;
                this.$params$inlined = layoutParams;
                this.$windowManager$inlined = windowManager;
                this.$view$inlined = view;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                try {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int value = (Integer)object;
                    if (((Boolean)this.$triple$inlined.getThird()).booleanValue()) {
                        this.$params$inlined.x = value;
                    } else {
                        this.$params$inlined.y = value;
                    }
                    this.$windowManager$inlined.updateViewLayout(this.$view$inlined, (ViewGroup.LayoutParams)this.$params$inlined);
                }
                catch (Exception e) {
                    this.$this_apply.cancel();
                }
            }
        });
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"ValueAnimator.ofInt(star\u2026}\n            }\n        }");
        return (Animator)valueAnimator2;
    }

    private final Triple<Integer, Integer, Boolean> initValue(View view, WindowManager.LayoutParams params, WindowManager windowManager, SidePattern sidePattern) {
        int n;
        Rect parentRect = new Rect();
        windowManager.getDefaultDisplay().getRectSize(parentRect);
        int leftDistance = params.x;
        int rightDistance = parentRect.right - (leftDistance + view.getRight());
        int topDistance = params.y;
        int bottomDistance = parentRect.bottom - (topDistance + view.getBottom());
        boolean bl = false;
        int minX = Math.min(leftDistance, rightDistance);
        boolean bl2 = false;
        int minY = Math.min(topDistance, bottomDistance);
        boolean isHorizontal = false;
        int endValue = 0;
        switch (DefaultAnimator$WhenMappings.$EnumSwitchMapping$0[sidePattern.ordinal()]) {
            case 1: 
            case 2: {
                isHorizontal = true;
                endValue = params.x;
                n = -view.getRight();
                break;
            }
            case 3: 
            case 4: {
                isHorizontal = true;
                endValue = params.x;
                n = parentRect.right;
                break;
            }
            case 5: 
            case 6: {
                isHorizontal = false;
                endValue = params.y;
                n = -view.getBottom();
                break;
            }
            case 7: 
            case 8: {
                isHorizontal = false;
                endValue = params.y;
                n = parentRect.bottom + this.getCompensationHeight(view, params);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                isHorizontal = true;
                endValue = params.x;
                if (leftDistance < rightDistance) {
                    n = -view.getRight();
                    break;
                }
                n = parentRect.right;
                break;
            }
            case 12: 
            case 13: {
                isHorizontal = false;
                endValue = params.y;
                if (topDistance < bottomDistance) {
                    n = -view.getBottom();
                    break;
                }
                n = parentRect.bottom + this.getCompensationHeight(view, params);
                break;
            }
            default: {
                if (minX <= minY) {
                    isHorizontal = true;
                    endValue = params.x;
                    if (leftDistance < rightDistance) {
                        n = -view.getRight();
                        break;
                    }
                    n = parentRect.right;
                    break;
                }
                isHorizontal = false;
                endValue = params.y;
                n = topDistance < bottomDistance ? -view.getBottom() : parentRect.bottom + this.getCompensationHeight(view, params);
            }
        }
        int startValue = n;
        return new Triple((Object)startValue, (Object)endValue, (Object)isHorizontal);
    }

    private final int getCompensationHeight(View view, WindowManager.LayoutParams params) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return location[1] == params.y ? DisplayUtils.INSTANCE.statusBarHeight(view) : 0;
    }
}

