/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.permission.rom;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.util.Log;
import com.lzf.easyfloat.permission.rom.RomUtils;
import java.lang.reflect.Method;

public class MiuiUtils {
    private static final String TAG = "MiuiUtils";

    public static int getMiuiVersion() {
        String version = RomUtils.getSystemProperty("ro.miui.ui.version.name");
        if (version != null) {
            try {
                return Integer.parseInt(version.substring(1));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("get miui version code error, version : " + version));
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        }
        return -1;
    }

    public static boolean checkFloatWindowPermission(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            return MiuiUtils.checkOp(context, 24);
        }
        return true;
    }

    @TargetApi(value=19)
    private static boolean checkOp(Context context, int op) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            try {
                Class<AppOpsManager> clazz = AppOpsManager.class;
                Method method = clazz.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                return 0 == (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        } else {
            Log.e((String)TAG, (String)"Below API 19 cannot invoke!");
        }
        return false;
    }

    public static void applyMiuiPermission(Context context) {
        int versionCode = MiuiUtils.getMiuiVersion();
        if (versionCode == 5) {
            MiuiUtils.goToMiuiPermissionActivity_V5(context);
        } else if (versionCode == 6) {
            MiuiUtils.goToMiuiPermissionActivity_V6(context);
        } else if (versionCode == 7) {
            MiuiUtils.goToMiuiPermissionActivity_V7(context);
        } else if (versionCode >= 8) {
            MiuiUtils.goToMiuiPermissionActivity_V8(context);
        } else {
            Log.e((String)TAG, (String)("this is a special MIUI rom version, its version code " + versionCode));
        }
    }

    private static boolean isIntentAvailable(Intent intent, Context context) {
        if (intent == null) {
            return false;
        }
        return context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    public static void goToMiuiPermissionActivity_V5(Context context) {
        Intent intent = null;
        String packageName = context.getPackageName();
        intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)packageName, null);
        intent.setData(uri);
        intent.setFlags(0x10000000);
        if (MiuiUtils.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"intent is not available!");
        }
    }

    public static void goToMiuiPermissionActivity_V6(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        intent.putExtra("extra_pkgname", context.getPackageName());
        intent.setFlags(0x10000000);
        if (MiuiUtils.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"Intent is not available!");
        }
    }

    public static void goToMiuiPermissionActivity_V7(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        intent.putExtra("extra_pkgname", context.getPackageName());
        intent.setFlags(0x10000000);
        if (MiuiUtils.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            Log.e((String)TAG, (String)"Intent is not available!");
        }
    }

    public static void goToMiuiPermissionActivity_V8(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        intent.putExtra("extra_pkgname", context.getPackageName());
        intent.setFlags(0x10000000);
        if (MiuiUtils.isIntentAvailable(intent, context)) {
            context.startActivity(intent);
        } else {
            intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            intent.setPackage("com.miui.securitycenter");
            intent.putExtra("extra_pkgname", context.getPackageName());
            intent.setFlags(0x10000000);
            if (MiuiUtils.isIntentAvailable(intent, context)) {
                context.startActivity(intent);
            } else {
                Log.e((String)TAG, (String)"Intent is not available!");
            }
        }
    }
}

