/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.lzf.easyfloat.interfaces.OnPermissionResult;
import com.lzf.easyfloat.permission.PermissionFragment;
import com.lzf.easyfloat.permission.rom.HuaweiUtils;
import com.lzf.easyfloat.permission.rom.MeizuUtils;
import com.lzf.easyfloat.permission.rom.MiuiUtils;
import com.lzf.easyfloat.permission.rom.OppoUtils;
import com.lzf.easyfloat.permission.rom.QikuUtils;
import com.lzf.easyfloat.permission.rom.RomUtils;
import com.lzf.easyfloat.utils.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0015\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/lzf/easyfloat/permission/PermissionUtils;", "", "()V", "TAG", "", "requestCode", "", "checkPermission", "", "context", "Landroid/content/Context;", "commonROMPermissionApply", "", "fragment", "Landroid/app/Fragment;", "commonROMPermissionApplyInternal", "commonROMPermissionCheck", "huaweiPermissionCheck", "meizuPermissionCheck", "miuiPermissionCheck", "oppoROMPermissionCheck", "qikuPermissionCheck", "requestPermission", "activity", "Landroid/app/Activity;", "onPermissionResult", "Lcom/lzf/easyfloat/interfaces/OnPermissionResult;", "requestPermission$easyfloat_release", "easyfloat_release"})
public final class PermissionUtils {
    public static final int requestCode = 199;
    private static final String TAG = "PermissionUtils--->";
    public static final PermissionUtils INSTANCE;

    @JvmStatic
    public static final boolean checkPermission(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 ? (RomUtils.INSTANCE.checkIsHuaweiRom() ? INSTANCE.huaweiPermissionCheck(context) : (RomUtils.INSTANCE.checkIsMiuiRom() ? INSTANCE.miuiPermissionCheck(context) : (RomUtils.INSTANCE.checkIsOppoRom() ? INSTANCE.oppoROMPermissionCheck(context) : (RomUtils.INSTANCE.checkIsMeizuRom() ? INSTANCE.meizuPermissionCheck(context) : (RomUtils.INSTANCE.checkIs360Rom() ? INSTANCE.qikuPermissionCheck(context) : true))))) : INSTANCE.commonROMPermissionCheck(context);
    }

    @JvmStatic
    public static final void requestPermission(@NotNull Activity activity, @NotNull OnPermissionResult onPermissionResult) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)onPermissionResult, (String)"onPermissionResult");
        PermissionFragment.Companion.requestPermission(activity, onPermissionResult);
    }

    public final void requestPermission$easyfloat_release(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        if (Build.VERSION.SDK_INT < 23) {
            if (RomUtils.INSTANCE.checkIsHuaweiRom()) {
                HuaweiUtils.applyPermission((Context)fragment.getActivity());
            } else if (RomUtils.INSTANCE.checkIsMiuiRom()) {
                MiuiUtils.applyMiuiPermission((Context)fragment.getActivity());
            } else if (RomUtils.INSTANCE.checkIsOppoRom()) {
                OppoUtils.applyOppoPermission((Context)fragment.getActivity());
            } else if (RomUtils.INSTANCE.checkIsMeizuRom()) {
                MeizuUtils.applyPermission(fragment);
            } else if (RomUtils.INSTANCE.checkIs360Rom()) {
                QikuUtils.applyPermission((Context)fragment.getActivity());
            } else {
                Logger.INSTANCE.i(TAG, "\u539f\u751f Android 6.0 \u4ee5\u4e0b\u65e0\u9700\u6743\u9650\u7533\u8bf7");
            }
        } else {
            this.commonROMPermissionApply(fragment);
        }
    }

    private final boolean huaweiPermissionCheck(Context context) {
        return HuaweiUtils.checkFloatWindowPermission(context);
    }

    private final boolean miuiPermissionCheck(Context context) {
        return MiuiUtils.checkFloatWindowPermission(context);
    }

    private final boolean meizuPermissionCheck(Context context) {
        return MeizuUtils.checkFloatWindowPermission(context);
    }

    private final boolean qikuPermissionCheck(Context context) {
        return QikuUtils.checkFloatWindowPermission(context);
    }

    private final boolean oppoROMPermissionCheck(Context context) {
        return OppoUtils.checkFloatWindowPermission(context);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean commonROMPermissionCheck(Context context) {
        boolean bl;
        if (RomUtils.INSTANCE.checkIsMeizuRom()) {
            bl = this.meizuPermissionCheck(context);
        } else {
            void var2_2;
            boolean result = true;
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<Settings> clazz = Settings.class;
                    Method canDrawOverlays = clazz.getDeclaredMethod("canDrawOverlays", Context.class);
                    Object object = canDrawOverlays.invoke(null, context);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    result = (Boolean)object;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
                }
            }
            bl = var2_2;
        }
        return bl;
    }

    private final void commonROMPermissionApply(Fragment fragment) {
        if (RomUtils.INSTANCE.checkIsMeizuRom()) {
            MeizuUtils.applyPermission(fragment);
        } else if (Build.VERSION.SDK_INT >= 23) {
            try {
                PermissionUtils.commonROMPermissionApplyInternal(fragment);
            }
            catch (Exception e) {
                String string = Log.getStackTraceString((Throwable)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Log.getStackTraceString(e)");
                Logger.INSTANCE.e(TAG, string);
            }
        } else {
            Logger.INSTANCE.d(TAG, "user manually refuse OVERLAY_PERMISSION");
        }
    }

    @JvmStatic
    public static final void commonROMPermissionApplyInternal(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        try {
            Class<Settings> clazz = Settings.class;
            Field field = clazz.getDeclaredField("ACTION_MANAGE_OVERLAY_PERMISSION");
            Intent intent = new Intent(field.get(null).toString());
            StringBuilder stringBuilder = new StringBuilder().append("package:");
            Activity activity = fragment.getActivity();
            Intrinsics.checkExpressionValueIsNotNull((Object)activity, (String)"fragment.activity");
            intent.setData(Uri.parse((String)stringBuilder.append(activity.getPackageName()).toString()));
            fragment.startActivityForResult(intent, 199);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, String.valueOf(e));
        }
    }

    private PermissionUtils() {
    }

    static {
        PermissionUtils permissionUtils;
        INSTANCE = permissionUtils = new PermissionUtils();
    }
}

