/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.lzf.easyfloat.permission.rom.RomUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/lzf/easyfloat/utils/DisplayUtils;", "", "()V", "TAG", "", "dp2px", "", "context", "Landroid/content/Context;", "dpVal", "", "getNavigationBarCurrentHeight", "getNavigationBarHeight", "getScreenHeight", "getScreenWidth", "getStatusBarHeight", "isMiuiFullScreen", "", "isNavigationBarShow", "px2dp", "pxVal", "px2sp", "pxValue", "rejectedNavHeight", "sp2px", "spValue", "statusBarHeight", "view", "Landroid/view/View;", "easyfloat_release"})
public final class DisplayUtils {
    private static final String TAG = "DisplayUtils--->";
    public static final DisplayUtils INSTANCE;

    public final int px2dp(@NotNull Context context, float pxVal) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(pxVal / density + 0.5f);
    }

    public final int dp2px(@NotNull Context context, float dpVal) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(dpVal * density + 0.5f);
    }

    public final int px2sp(@NotNull Context context, float pxValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int getScreenWidth(@NotNull Context context) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics dm = resources2.getDisplayMetrics();
        return dm.widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        Display display = ((WindowManager)object).getDefaultDisplay();
        Point point = new Point();
        display.getRealSize(point);
        return point.y;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public final int statusBarHeight(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"view.context.applicationContext");
        return this.getStatusBarHeight(context2);
    }

    public final int getNavigationBarCurrentHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.isNavigationBarShow(context) ? this.getNavigationBarHeight(context) : 0;
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        Log.d((String)TAG, (String)("getNavigationBarHeight = " + result));
        return result;
    }

    @SuppressLint(value={"PrivateApi"})
    public final boolean isNavigationBarShow(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.isMiuiFullScreen(context)) {
            return false;
        }
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id > 0) {
            hasNavigationBar = rs.getBoolean(id);
        }
        try {
            int navigationBarIsMin;
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            Object object = m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            int n = navigationBarIsMin = Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0) : Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0);
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride) || 1 == navigationBarIsMin) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasNavigationBar;
    }

    public final int rejectedNavHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getScreenHeight(context) - this.getNavigationBarCurrentHeight(context);
    }

    private final boolean isMiuiFullScreen(Context context) {
        return RomUtils.checkIsMiuiRom() && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0;
    }

    private DisplayUtils() {
    }

    static {
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
    }
}

