/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.anim;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.lzf.easyfloat.anim.DefaultAnimator$WhenMappings;
import com.lzf.easyfloat.enum.SidePattern;
import com.lzf.easyfloat.interfaces.OnFloatAnimator;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/lzf/easyfloat/anim/DefaultAnimator;", "Lcom/lzf/easyfloat/interfaces/OnFloatAnimator;", "()V", "bottomDistance", "", "floatRect", "Landroid/graphics/Rect;", "leftDistance", "minX", "minY", "parentRect", "rightDistance", "topDistance", "animTriple", "Lkotlin/Triple;", "", "", "view", "Landroid/view/View;", "sidePattern", "Lcom/lzf/easyfloat/enum/SidePattern;", "bottomValue", "enterAnim", "Landroid/animation/Animator;", "parentView", "Landroid/view/ViewGroup;", "exitAnim", "initValue", "", "leftValue", "rightValue", "topValue", "easyfloat_release"})
public class DefaultAnimator
implements OnFloatAnimator {
    private int leftDistance;
    private int rightDistance;
    private int topDistance;
    private int bottomDistance;
    private int minX;
    private int minY;
    private Rect floatRect = new Rect();
    private Rect parentRect = new Rect();

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Animator enterAnim(@NotNull View view, @NotNull ViewGroup parentView, @NotNull SidePattern sidePattern) {
        void startValue;
        void animType;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)parentView, (String)"parentView");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sidePattern), (String)"sidePattern");
        this.initValue(view, parentView);
        Triple<String, Float, Float> triple = this.animTriple(view, sidePattern);
        String string = (String)triple.component1();
        float f = ((Number)triple.component2()).floatValue();
        float endValue = ((Number)triple.component3()).floatValue();
        return (Animator)ObjectAnimator.ofFloat((Object)view, (String)animType, (float[])new float[]{startValue, endValue}).setDuration(500L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Animator exitAnim(@NotNull View view, @NotNull ViewGroup parentView, @NotNull SidePattern sidePattern) {
        void startValue;
        void animType;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)parentView, (String)"parentView");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sidePattern), (String)"sidePattern");
        this.initValue(view, parentView);
        Triple<String, Float, Float> triple = this.animTriple(view, sidePattern);
        String string = (String)triple.component1();
        float f = ((Number)triple.component2()).floatValue();
        float endValue = ((Number)triple.component3()).floatValue();
        return (Animator)ObjectAnimator.ofFloat((Object)view, (String)animType, (float[])new float[]{endValue, startValue}).setDuration(500L);
    }

    private final Triple<String, Float, Float> animTriple(View view, SidePattern sidePattern) {
        float f;
        String animType = null;
        switch (DefaultAnimator$WhenMappings.$EnumSwitchMapping$0[sidePattern.ordinal()]) {
            case 1: 
            case 2: {
                animType = "translationX";
                f = this.leftValue(view);
                break;
            }
            case 3: 
            case 4: {
                animType = "translationX";
                f = this.rightValue(view);
                break;
            }
            case 5: 
            case 6: {
                animType = "translationY";
                f = this.topValue(view);
                break;
            }
            case 7: 
            case 8: {
                animType = "translationY";
                f = this.rightValue(view);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                animType = "translationX";
                if (this.leftDistance < this.rightDistance) {
                    f = this.leftValue(view);
                    break;
                }
                f = this.rightValue(view);
                break;
            }
            case 12: 
            case 13: {
                animType = "translationY";
                if (this.topDistance < this.bottomDistance) {
                    f = this.topValue(view);
                    break;
                }
                f = this.bottomValue(view);
                break;
            }
            default: {
                if (this.minX <= this.minY) {
                    animType = "translationX";
                    if (this.leftDistance < this.rightDistance) {
                        f = this.leftValue(view);
                        break;
                    }
                    f = this.rightValue(view);
                    break;
                }
                animType = "translationY";
                f = this.topDistance < this.bottomDistance ? this.topValue(view) : this.bottomValue(view);
            }
        }
        float startValue = f;
        float endValue = Intrinsics.areEqual((Object)animType, (Object)"translationX") ? view.getTranslationX() : view.getTranslationY();
        return new Triple((Object)animType, (Object)Float.valueOf(startValue), (Object)Float.valueOf(endValue));
    }

    private final float leftValue(View view) {
        return (float)(-(this.leftDistance + view.getWidth())) + view.getTranslationX();
    }

    private final float rightValue(View view) {
        return (float)(this.rightDistance + view.getWidth()) + view.getTranslationX();
    }

    private final float topValue(View view) {
        return (float)(-(this.topDistance + view.getHeight())) + view.getTranslationY();
    }

    private final float bottomValue(View view) {
        return (float)(this.bottomDistance + view.getHeight()) + view.getTranslationY();
    }

    private final void initValue(View view, ViewGroup parentView) {
        int n;
        view.getGlobalVisibleRect(this.floatRect);
        parentView.getGlobalVisibleRect(this.parentRect);
        this.leftDistance = this.floatRect.left;
        this.rightDistance = this.parentRect.right - this.floatRect.right;
        this.topDistance = this.floatRect.top - this.parentRect.top;
        this.bottomDistance = this.parentRect.bottom - this.floatRect.bottom;
        int n2 = this.leftDistance;
        int n3 = this.rightDistance;
        DefaultAnimator defaultAnimator = this;
        boolean bl = false;
        defaultAnimator.minX = n = Math.min(n2, n3);
        n2 = this.topDistance;
        n3 = this.bottomDistance;
        defaultAnimator = this;
        bl = false;
        defaultAnimator.minY = n = Math.min(n2, n3);
    }
}

