/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.widget.appfloat;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.lzf.easyfloat.anim.AppFloatAnimatorManager;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.interfaces.OnFloatCallbacks;
import com.lzf.easyfloat.interfaces.OnFloatTouchListener;
import com.lzf.easyfloat.interfaces.OnInvokeView;
import com.lzf.easyfloat.service.FloatService;
import com.lzf.easyfloat.utils.DisplayUtils;
import com.lzf.easyfloat.widget.appfloat.ParentFrameLayout;
import com.lzf.easyfloat.widget.appfloat.TouchUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020\"J\b\u0010$\u001a\u00020\"H\u0002J\u0006\u0010%\u001a\u00020\"J\b\u0010&\u001a\u00020\"H\u0002J\b\u0010'\u001a\u00020\"H\u0002J\u0012\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010*H\u0003J\u000e\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lcom/lzf/easyfloat/widget/appfloat/AppFloatManager;", "", "context", "Landroid/content/Context;", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "(Landroid/content/Context;Lcom/lzf/easyfloat/data/FloatConfig;)V", "getConfig", "()Lcom/lzf/easyfloat/data/FloatConfig;", "setConfig", "(Lcom/lzf/easyfloat/data/FloatConfig;)V", "getContext", "()Landroid/content/Context;", "frameLayout", "Lcom/lzf/easyfloat/widget/appfloat/ParentFrameLayout;", "getFrameLayout", "()Lcom/lzf/easyfloat/widget/appfloat/ParentFrameLayout;", "setFrameLayout", "(Lcom/lzf/easyfloat/widget/appfloat/ParentFrameLayout;)V", "params", "Landroid/view/WindowManager$LayoutParams;", "getParams", "()Landroid/view/WindowManager$LayoutParams;", "setParams", "(Landroid/view/WindowManager$LayoutParams;)V", "touchUtils", "Lcom/lzf/easyfloat/widget/appfloat/TouchUtils;", "windowManager", "Landroid/view/WindowManager;", "getWindowManager", "()Landroid/view/WindowManager;", "setWindowManager", "(Landroid/view/WindowManager;)V", "addView", "", "createFloat", "enterAnim", "exitAnim", "floatOver", "initParams", "setGravity", "view", "Landroid/view/View;", "setVisible", "visible", "", "easyfloat_release"})
public final class AppFloatManager {
    @NotNull
    public WindowManager windowManager;
    @NotNull
    public WindowManager.LayoutParams params;
    @Nullable
    private ParentFrameLayout frameLayout;
    private TouchUtils touchUtils;
    @NotNull
    private final Context context;
    @NotNull
    private FloatConfig config;

    @NotNull
    public final WindowManager getWindowManager() {
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        return windowManager;
    }

    public final void setWindowManager(@NotNull WindowManager windowManager) {
        Intrinsics.checkParameterIsNotNull((Object)windowManager, (String)"<set-?>");
        this.windowManager = windowManager;
    }

    @NotNull
    public final WindowManager.LayoutParams getParams() {
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        return layoutParams;
    }

    public final void setParams(@NotNull WindowManager.LayoutParams layoutParams) {
        Intrinsics.checkParameterIsNotNull((Object)layoutParams, (String)"<set-?>");
        this.params = layoutParams;
    }

    @Nullable
    public final ParentFrameLayout getFrameLayout() {
        return this.frameLayout;
    }

    public final void setFrameLayout(@Nullable ParentFrameLayout parentFrameLayout) {
        this.frameLayout = parentFrameLayout;
    }

    public final void createFloat() {
        block2: {
            try {
                this.touchUtils = new TouchUtils(this.config);
                this.initParams();
                this.addView();
                this.config.setShow(true);
            }
            catch (Exception e) {
                OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
                if (onFloatCallbacks == null) break block2;
                onFloatCallbacks.createdResult(false, String.valueOf(e), null);
            }
        }
    }

    private final void initParams() {
        WindowManager.LayoutParams layoutParams;
        Object object = this.context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        this.windowManager = (WindowManager)object;
        WindowManager.LayoutParams layoutParams2 = new WindowManager.LayoutParams();
        AppFloatManager appFloatManager = this;
        boolean bl = false;
        boolean bl2 = false;
        WindowManager.LayoutParams $this$apply = layoutParams2;
        boolean bl3 = false;
        $this$apply.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        $this$apply.format = 1;
        $this$apply.gravity = 0x800033;
        $this$apply.flags = 552;
        $this$apply.width = this.config.getWidthMatch() ? -1 : -2;
        int n = $this$apply.height = this.config.getHeightMatch() ? -1 : -2;
        if (Intrinsics.areEqual(this.config.getLocationPair(), (Object)new Pair((Object)0, (Object)0)) ^ true) {
            $this$apply.x = ((Number)this.config.getLocationPair().getFirst()).intValue();
            $this$apply.y = ((Number)this.config.getLocationPair().getSecond()).intValue();
        }
        appFloatManager.params = layoutParams = layoutParams2;
    }

    private final void addView() {
        block7: {
            Context context = this.context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context.applicationContext");
            ParentFrameLayout parentFrameLayout = this.frameLayout = new ParentFrameLayout(context, this.config, null, 0, 12, null);
            if (parentFrameLayout != null) {
                parentFrameLayout.setTag(this.config.getFloatTag());
            }
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context.getApplicationContext());
            Integer n = this.config.getLayoutId();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            View floatingView2 = layoutInflater.inflate(n.intValue(), (ViewGroup)this.frameLayout, true);
            WindowManager windowManager = this.windowManager;
            if (windowManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
            }
            View view = (View)this.frameLayout;
            WindowManager.LayoutParams layoutParams = this.params;
            if (layoutParams == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            windowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
            ParentFrameLayout parentFrameLayout2 = this.frameLayout;
            if (parentFrameLayout2 != null) {
                parentFrameLayout2.setTouchListener(new OnFloatTouchListener(this){
                    final /* synthetic */ AppFloatManager this$0;

                    public void onTouch(@NotNull MotionEvent event) {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        TouchUtils touchUtils = AppFloatManager.access$getTouchUtils$p(this.this$0);
                        ParentFrameLayout parentFrameLayout = this.this$0.getFrameLayout();
                        if (parentFrameLayout == null) {
                            Intrinsics.throwNpe();
                        }
                        touchUtils.updateFloat((View)parentFrameLayout, event, this.this$0.getWindowManager(), this.this$0.getParams());
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            }
            ParentFrameLayout parentFrameLayout3 = this.frameLayout;
            if (parentFrameLayout3 != null) {
                parentFrameLayout3.setLayoutListener(new ParentFrameLayout.OnLayoutListener(this){
                    final /* synthetic */ AppFloatManager this$0;

                    public void onLayout() {
                        AppFloatManager.access$setGravity(this.this$0, (View)this.this$0.getFrameLayout());
                        AppFloatManager.access$enterAnim(this.this$0);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            }
            OnInvokeView onInvokeView = this.config.getInvokeView();
            if (onInvokeView != null) {
                onInvokeView.invoke(floatingView2);
            }
            OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
            if (onFloatCallbacks == null) break block7;
            onFloatCallbacks.createdResult(true, null, floatingView2);
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private final void setGravity(View view) {
        if (Intrinsics.areEqual(this.config.getLocationPair(), (Object)new Pair((Object)0, (Object)0)) ^ true || view == null) {
            return;
        }
        Rect parentRect = new Rect();
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        windowManager.getDefaultDisplay().getRectSize(parentRect);
        int parentBottom = parentRect.bottom - DisplayUtils.INSTANCE.statusBarHeight(view);
        switch (this.config.getGravity()) {
            case 5: 
            case 53: 
            case 0x800005: 
            case 8388661: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                break;
            }
            case 3: 
            case 83: 
            case 8388691: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 85: 
            case 0x800055: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 17: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = (int)((float)(parentRect.right - view.getWidth()) * 0.5f);
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = (int)((float)(parentBottom - view.getHeight()) * 0.5f);
                break;
            }
            case 1: 
            case 49: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = (int)((float)(parentRect.right - view.getWidth()) * 0.5f);
                break;
            }
            case 81: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = (int)((float)(parentRect.right - view.getWidth()) * 0.5f);
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = parentBottom - view.getHeight();
                break;
            }
            case 16: 
            case 19: 
            case 8388627: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = (int)((float)(parentBottom - view.getHeight()) * 0.5f);
                break;
            }
            case 21: 
            case 8388629: {
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.x = parentRect.right - view.getWidth();
                if (this.params == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                }
                this.params.y = (int)((float)(parentBottom - view.getHeight()) * 0.5f);
            }
        }
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        layoutParams.x += ((Number)this.config.getOffsetPair().getFirst()).intValue();
        WindowManager.LayoutParams layoutParams2 = this.params;
        if (layoutParams2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        layoutParams2.y += ((Number)this.config.getOffsetPair().getSecond()).intValue();
        WindowManager windowManager2 = this.windowManager;
        if (windowManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        WindowManager.LayoutParams layoutParams3 = this.params;
        if (layoutParams3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        windowManager2.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams3);
    }

    public final void setVisible(int visible) {
        block9: {
            block8: {
                if (this.frameLayout == null) {
                    return;
                }
                ParentFrameLayout parentFrameLayout = this.frameLayout;
                if (parentFrameLayout != null) {
                    parentFrameLayout.setVisibility(visible);
                }
                if (visible != 0) break block8;
                this.config.setShow(true);
                ParentFrameLayout parentFrameLayout2 = this.frameLayout;
                if (parentFrameLayout2 == null) {
                    Intrinsics.throwNpe();
                }
                if (parentFrameLayout2.getChildCount() <= 0) break block9;
                OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
                if (onFloatCallbacks != null) {
                    ParentFrameLayout parentFrameLayout3 = this.frameLayout;
                    if (parentFrameLayout3 == null) {
                        Intrinsics.throwNpe();
                    }
                    View view = parentFrameLayout3.getChildAt(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"frameLayout!!.getChildAt(0)");
                    onFloatCallbacks.show(view);
                }
                break block9;
            }
            this.config.setShow(false);
            ParentFrameLayout parentFrameLayout = this.frameLayout;
            if (parentFrameLayout == null) {
                Intrinsics.throwNpe();
            }
            if (parentFrameLayout.getChildCount() <= 0) break block9;
            OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
            if (onFloatCallbacks != null) {
                ParentFrameLayout parentFrameLayout4 = this.frameLayout;
                if (parentFrameLayout4 == null) {
                    Intrinsics.throwNpe();
                }
                View view = parentFrameLayout4.getChildAt(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"frameLayout!!.getChildAt(0)");
                onFloatCallbacks.hide(view);
            }
        }
    }

    private final void enterAnim() {
        AppFloatAnimatorManager manager;
        Animator animator;
        if (this.frameLayout == null || this.config.isAnim()) {
            return;
        }
        ParentFrameLayout parentFrameLayout = this.frameLayout;
        if (parentFrameLayout == null) {
            Intrinsics.throwNpe();
        }
        View view = (View)parentFrameLayout;
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        if ((animator = (manager = new AppFloatAnimatorManager(view, layoutParams, windowManager, this.config)).enterAnim()) == null) {
            if (this.params == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            this.params.flags = 40;
        } else {
            animator.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ AppFloatManager this$0;

                public void onAnimationRepeat(@Nullable Animator animation) {
                }

                public void onAnimationEnd(@Nullable Animator animation) {
                    this.this$0.getConfig().setAnim(false);
                    this.this$0.getParams().flags = 40;
                }

                public void onAnimationCancel(@Nullable Animator animation) {
                }

                public void onAnimationStart(@Nullable Animator animation) {
                    this.this$0.getConfig().setAnim(true);
                }
                {
                    this.this$0 = $outer;
                }
            });
            animator.start();
        }
    }

    public final void exitAnim() {
        AppFloatAnimatorManager manager;
        Animator animator;
        if (this.frameLayout == null || this.config.isAnim()) {
            return;
        }
        ParentFrameLayout parentFrameLayout = this.frameLayout;
        if (parentFrameLayout == null) {
            Intrinsics.throwNpe();
        }
        View view = (View)parentFrameLayout;
        WindowManager.LayoutParams layoutParams = this.params;
        if (layoutParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        }
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        if ((animator = (manager = new AppFloatAnimatorManager(view, layoutParams, windowManager, this.config)).exitAnim()) == null) {
            this.floatOver();
        } else {
            if (this.params == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            }
            this.params.flags = 552;
            animator.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ AppFloatManager this$0;

                public void onAnimationRepeat(@Nullable Animator animation) {
                }

                public void onAnimationEnd(@Nullable Animator animation) {
                    AppFloatManager.access$floatOver(this.this$0);
                }

                public void onAnimationCancel(@Nullable Animator animation) {
                }

                public void onAnimationStart(@Nullable Animator animation) {
                    this.this$0.getConfig().setAnim(true);
                }
                {
                    this.this$0 = $outer;
                }
            });
            animator.start();
        }
    }

    private final void floatOver() {
        this.config.setAnim(false);
        OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
        if (onFloatCallbacks != null) {
            onFloatCallbacks.dismiss();
        }
        WindowManager windowManager = this.windowManager;
        if (windowManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManager");
        }
        windowManager.removeView((View)this.frameLayout);
        FloatService.Companion.checkStop(this.context, this.config.getFloatTag());
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final FloatConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull FloatConfig floatConfig) {
        Intrinsics.checkParameterIsNotNull((Object)floatConfig, (String)"<set-?>");
        this.config = floatConfig;
    }

    public AppFloatManager(@NotNull Context context, @NotNull FloatConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.context = context;
        this.config = config;
    }

    public static final /* synthetic */ TouchUtils access$getTouchUtils$p(AppFloatManager $this) {
        TouchUtils touchUtils = $this.touchUtils;
        if (touchUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchUtils");
        }
        return touchUtils;
    }

    public static final /* synthetic */ void access$setTouchUtils$p(AppFloatManager $this, TouchUtils touchUtils) {
        $this.touchUtils = touchUtils;
    }

    public static final /* synthetic */ void access$setGravity(AppFloatManager $this, View view) {
        $this.setGravity(view);
    }

    public static final /* synthetic */ void access$enterAnim(AppFloatManager $this) {
        $this.enterAnim();
    }

    public static final /* synthetic */ void access$floatOver(AppFloatManager $this) {
        $this.floatOver();
    }
}

