/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.widget.appfloat;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.interfaces.OnFloatCallbacks;
import com.lzf.easyfloat.utils.DisplayUtils;
import com.lzf.easyfloat.widget.appfloat.TouchUtils$WhenMappings;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J&\u0010!\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/lzf/easyfloat/widget/appfloat/TouchUtils;", "", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "(Lcom/lzf/easyfloat/data/FloatConfig;)V", "bottomDistance", "", "getConfig", "()Lcom/lzf/easyfloat/data/FloatConfig;", "setConfig", "lastX", "", "lastY", "leftDistance", "minX", "minY", "parentHeight", "parentRect", "Landroid/graphics/Rect;", "parentWidth", "rightDistance", "topDistance", "initDistanceValue", "", "params", "Landroid/view/WindowManager$LayoutParams;", "floatingView", "Landroid/view/View;", "sideAnim", "view", "windowManager", "Landroid/view/WindowManager;", "statusBarHeight", "updateFloat", "event", "Landroid/view/MotionEvent;", "easyfloat_release"})
public final class TouchUtils {
    private Rect parentRect;
    private int parentHeight;
    private int parentWidth;
    private float lastX;
    private float lastY;
    private int leftDistance;
    private int rightDistance;
    private int topDistance;
    private int bottomDistance;
    private int minX;
    private int minY;
    @NotNull
    private FloatConfig config;

    public final void updateFloat(@NotNull View view, @NotNull MotionEvent event, @NotNull WindowManager windowManager, @NotNull WindowManager.LayoutParams params) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)windowManager, (String)"windowManager");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        OnFloatCallbacks onFloatCallbacks = this.config.getCallbacks();
        if (onFloatCallbacks != null) {
            onFloatCallbacks.touchEvent(view, event);
        }
        if (!this.config.getDragEnable() || this.config.isAnim()) {
            this.config.setDrag(false);
            return;
        }
        block0 : switch (event.getAction() & 0xFF) {
            case 0: {
                this.config.setDrag(false);
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                windowManager.getDefaultDisplay().getRectSize(this.parentRect);
                this.parentWidth = this.parentRect.width();
                this.parentHeight = this.parentRect.height();
                break;
            }
            case 2: {
                float dx = event.getRawX() - this.lastX;
                float dy = event.getRawY() - this.lastY;
                if (!this.config.isDrag() && dx * dx + dy * dy < (float)81) {
                    return;
                }
                this.config.setDrag(true);
                int x = params.x + (int)dx;
                int y = params.y + (int)dy;
                x = x < 0 ? 0 : (x > this.parentWidth - view.getWidth() ? this.parentWidth - view.getWidth() : x);
                y = y < 0 ? 0 : (y > this.parentHeight - view.getHeight() - this.statusBarHeight(view) ? this.parentHeight - view.getHeight() - this.statusBarHeight(view) : y);
                switch (TouchUtils$WhenMappings.$EnumSwitchMapping$0[this.config.getSidePattern().ordinal()]) {
                    case 1: {
                        x = 0;
                        break;
                    }
                    case 2: {
                        x = this.parentWidth - view.getWidth();
                        break;
                    }
                    case 3: {
                        y = 0;
                        break;
                    }
                    case 4: {
                        y = this.parentHeight - view.getHeight();
                        break;
                    }
                    case 5: {
                        x = event.getRawX() * (float)2 > (float)this.parentWidth ? this.parentWidth - view.getWidth() : 0;
                        break;
                    }
                    case 6: {
                        y = (event.getRawY() - (float)this.parentRect.top) * (float)2 > (float)this.parentHeight ? this.parentHeight - view.getHeight() : 0;
                        break;
                    }
                    case 7: {
                        int n;
                        this.leftDistance = (int)event.getRawX();
                        this.rightDistance = this.parentWidth - (int)event.getRawX();
                        this.topDistance = (int)event.getRawY() - this.parentRect.top;
                        this.bottomDistance = this.parentHeight + this.parentRect.top - (int)event.getRawY();
                        int n2 = this.leftDistance;
                        int n3 = this.rightDistance;
                        TouchUtils touchUtils = this;
                        boolean bl = false;
                        touchUtils.minX = n = Math.min(n2, n3);
                        n2 = this.topDistance;
                        n3 = this.bottomDistance;
                        touchUtils = this;
                        bl = false;
                        touchUtils.minY = n = Math.min(n2, n3);
                        if (this.minX < this.minY) {
                            x = this.leftDistance == this.minX ? 0 : this.parentWidth - view.getWidth();
                            break;
                        }
                        y = this.topDistance == this.minY ? 0 : this.parentHeight - view.getHeight();
                    }
                }
                params.x = x;
                params.y = y;
                windowManager.updateViewLayout(view, (ViewGroup.LayoutParams)params);
                OnFloatCallbacks onFloatCallbacks2 = this.config.getCallbacks();
                if (onFloatCallbacks2 != null) {
                    onFloatCallbacks2.drag(view, event);
                }
                this.lastX = event.getRawX();
                this.lastY = event.getRawY();
                break;
            }
            case 1: {
                if (!this.config.isDrag()) {
                    return;
                }
                switch (TouchUtils$WhenMappings.$EnumSwitchMapping$1[this.config.getSidePattern().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.sideAnim(view, params, windowManager);
                        break block0;
                    }
                }
                OnFloatCallbacks onFloatCallbacks3 = this.config.getCallbacks();
                if (onFloatCallbacks3 != null) {
                    onFloatCallbacks3.dragEnd(view);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void sideAnim(View view, WindowManager.LayoutParams params, WindowManager windowManager) {
        int n;
        this.initDistanceValue(params, view);
        boolean isX = false;
        switch (TouchUtils$WhenMappings.$EnumSwitchMapping$2[this.config.getSidePattern().ordinal()]) {
            case 1: {
                isX = true;
                n = 0;
                break;
            }
            case 2: {
                isX = true;
                n = params.x + this.rightDistance;
                break;
            }
            case 3: {
                isX = true;
                if (this.leftDistance < this.rightDistance) {
                    n = 0;
                    break;
                }
                n = params.x + this.rightDistance;
                break;
            }
            case 4: {
                isX = false;
                n = 0;
                break;
            }
            case 5: {
                isX = false;
                n = this.parentHeight - view.getHeight() - this.statusBarHeight(view);
                break;
            }
            case 6: {
                isX = false;
                if (this.topDistance < this.bottomDistance) {
                    n = 0;
                    break;
                }
                n = this.parentHeight - view.getHeight() - this.statusBarHeight(view);
                break;
            }
            case 7: {
                if (this.minX < this.minY) {
                    isX = true;
                    if (this.leftDistance < this.rightDistance) {
                        n = 0;
                        break;
                    }
                    n = params.x + this.rightDistance;
                    break;
                }
                isX = false;
                if (this.topDistance < this.bottomDistance) {
                    n = 0;
                    break;
                }
                n = this.parentHeight - view.getHeight() - this.statusBarHeight(view);
                break;
            }
            default: {
                return;
            }
        }
        int end = n;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{isX ? params.x : params.y, end});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(isX, params, windowManager, view){
            final /* synthetic */ boolean $isX;
            final /* synthetic */ WindowManager.LayoutParams $params;
            final /* synthetic */ WindowManager $windowManager;
            final /* synthetic */ View $view;

            public final void onAnimationUpdate(ValueAnimator it) {
                if (this.$isX) {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.$params.x = (Integer)object;
                } else {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.$params.y = (Integer)object;
                }
                this.$windowManager.updateViewLayout(this.$view, (ViewGroup.LayoutParams)this.$params);
            }
            {
                this.$isX = bl;
                this.$params = layoutParams;
                this.$windowManager = windowManager;
                this.$view = view;
            }
        });
        animator.addListener(new Animator.AnimatorListener(this, view){
            final /* synthetic */ TouchUtils this$0;
            final /* synthetic */ View $view;

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                block0: {
                    this.this$0.getConfig().setAnim(false);
                    OnFloatCallbacks onFloatCallbacks = this.this$0.getConfig().getCallbacks();
                    if (onFloatCallbacks == null) break block0;
                    onFloatCallbacks.dragEnd(this.$view);
                }
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }

            public void onAnimationStart(@Nullable Animator animation) {
                this.this$0.getConfig().setAnim(true);
            }
            {
                this.this$0 = $outer;
                this.$view = $captured_local_variable$1;
            }
        });
        animator.start();
    }

    private final void initDistanceValue(WindowManager.LayoutParams params, View floatingView2) {
        int n;
        this.leftDistance = params.x;
        this.rightDistance = this.parentWidth - (this.leftDistance + floatingView2.getRight());
        this.topDistance = params.y;
        this.bottomDistance = this.parentRect.bottom - this.statusBarHeight(floatingView2) - (params.y + floatingView2.getBottom());
        int n2 = this.leftDistance;
        int n3 = this.rightDistance;
        TouchUtils touchUtils = this;
        boolean bl = false;
        touchUtils.minX = n = Math.min(n2, n3);
        n2 = this.topDistance;
        n3 = this.bottomDistance;
        touchUtils = this;
        bl = false;
        touchUtils.minY = n = Math.min(n2, n3);
    }

    private final int statusBarHeight(View view) {
        return DisplayUtils.INSTANCE.statusBarHeight(view);
    }

    @NotNull
    public final FloatConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull FloatConfig floatConfig) {
        Intrinsics.checkParameterIsNotNull((Object)floatConfig, (String)"<set-?>");
        this.config = floatConfig;
    }

    public TouchUtils(@NotNull FloatConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.parentRect = new Rect();
    }
}

