/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nJ\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001dJ\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/lzf/easyfloat/utils/DisplayUtils;", "", "()V", "TAG", "", "dp2px", "", "context", "Landroid/content/Context;", "dpVal", "", "getNavigationBarCurrentHeight", "activity", "Landroid/app/Activity;", "getNavigationBarHeight", "getScreenHeight", "getScreenWidth", "getStatusBarHeight", "isNavigationBarShow", "", "px2dp", "pxVal", "px2sp", "pxValue", "setLayoutLocation", "", "view", "Landroid/view/View;", "pair", "Lkotlin/Pair;", "sp2px", "spValue", "statusBarHeight", "easyfloat_release"})
public final class DisplayUtils {
    private static final String TAG = "DisplayUtils--->";
    public static final DisplayUtils INSTANCE;

    public final int px2dp(@NotNull Context context, float pxVal) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(pxVal / density + 0.5f);
    }

    public final int dp2px(@NotNull Context context, float dpVal) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)(dpVal * density + 0.5f);
    }

    public final int px2sp(@NotNull Context context, float pxValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float fontScale = resources.getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public final int getScreenWidth(@NotNull Context context) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics dm = resources2.getDisplayMetrics();
        return dm.widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Resources resources;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources2 = resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics dm = resources2.getDisplayMetrics();
        return dm.heightPixels;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public final int statusBarHeight(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"view.context.applicationContext");
        return INSTANCE.getStatusBarHeight(context2);
    }

    public final int getNavigationBarCurrentHeight(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        return this.isNavigationBarShow(activity) ? this.getNavigationBarHeight((Context)activity) : 0;
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        Log.d((String)TAG, (String)("getNavigationBarHeight = " + result));
        return result;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final boolean isNavigationBarShow(@NotNull Activity activity) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager windowManager = activity.getWindowManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"activity.windowManager");
            Display display = windowManager.getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            bl = realSize.y != size.y;
        } else {
            boolean menu = ViewConfiguration.get((Context)((Context)activity)).hasPermanentMenuKey();
            boolean back = KeyCharacterMap.deviceHasKey((int)4);
            bl = !menu && !back;
        }
        return bl;
    }

    public final void setLayoutLocation(@NotNull View view, @NotNull Pair<Integer, Integer> pair) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull(pair, (String)"pair");
        ViewGroup.MarginLayoutParams margin = new ViewGroup.MarginLayoutParams(view.getLayoutParams());
        margin.setMargins(((Number)pair.getFirst()).intValue(), ((Number)pair.getSecond()).intValue(), 0, 0);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(margin);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private DisplayUtils() {
    }

    static {
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
    }
}

