/*
 * Decompiled with CFR 0.152.
 */
package com.github.premnirmal.textcounter;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.TextView;
import com.github.premnirmal.textcounter.Counter;
import com.github.premnirmal.textcounter.CounterType;
import com.github.premnirmal.textcounter.Formatter;
import com.github.premnirmal.textcounter.R;
import com.github.premnirmal.textcounter.formatters.CommaSeparatedDecimalFormatter;
import com.github.premnirmal.textcounter.formatters.DecimalFormatter;
import com.github.premnirmal.textcounter.formatters.IntegerFormatter;
import com.github.premnirmal.textcounter.formatters.NoFormatter;

public class CounterView
extends TextView {
    public static final long DEFAULT_INTERVAL = 5L;
    public static final float DEFAULT_INCREMENT = 10.0f;
    protected String text;
    protected String prefix;
    protected String suffix;
    protected long timeInterval;
    protected float increment;
    protected float startValue;
    protected float endValue;
    protected CounterType counterType;
    protected boolean autoStart;
    protected boolean autoFormat;
    protected Counter counter;
    protected Formatter formatter;

    public CounterView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public CounterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public CounterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CounterView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            this.prefix = "";
            this.suffix = "";
            this.text = "";
            this.timeInterval = 5L;
            this.increment = 10.0f;
            this.startValue = 0.0f;
            this.endValue = 0.0f;
            this.autoStart = false;
            this.autoFormat = true;
            this.counterType = CounterType.NUMBER;
            return;
        }
        typedArray = context.obtainStyledAttributes(attrs, R.styleable.CounterView, defStyleAttr, defStyleRes);
        try {
            prefix = typedArray.getText(R.styleable.CounterView_prefix);
            this.prefix = prefix != null ? prefix.toString() : "";
            suffix = typedArray.getText(R.styleable.CounterView_suffix);
            this.suffix = suffix != null ? suffix.toString() : "";
            text = typedArray.getText(R.styleable.CounterView_android_text);
            this.text = text != null ? text.toString() : "";
            this.timeInterval = (long)typedArray.getFloat(R.styleable.CounterView_timeInterval, 5.0f);
            this.increment = typedArray.getFloat(R.styleable.CounterView_incrementValue, 10.0f);
            this.startValue = typedArray.getFloat(R.styleable.CounterView_startValue, 0.0f);
            this.endValue = typedArray.getFloat(R.styleable.CounterView_endValue, 0.0f);
            this.autoStart = typedArray.getBoolean(R.styleable.CounterView_autoStart, true);
            this.autoFormat = typedArray.getBoolean(R.styleable.CounterView_formatText, true);
            type = typedArray.getInteger(R.styleable.CounterView_type, 0);
            switch (type) {
                case 0: {
                    this.counterType = CounterType.NUMBER;
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.counterType = CounterType.DECIMAL;
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.counterType = CounterType.BOTH;
                    break;
                }
                ** default:
lbl41:
                // 1 sources

                break;
            }
        }
        finally {
            typedArray.recycle();
        }
        this.counter = new Counter(this, this.startValue, this.endValue, this.timeInterval, this.increment);
        this.updateCounterType();
    }

    protected void updateCounterType() {
        switch (this.counterType) {
            case NUMBER: {
                this.formatter = new IntegerFormatter();
                break;
            }
            case DECIMAL: {
                this.formatter = new DecimalFormatter();
                break;
            }
            case BOTH: {
                this.formatter = new CommaSeparatedDecimalFormatter();
            }
        }
    }

    void setCurrentTextValue(float number) {
        this.text = this.formatter.format(this.prefix, this.suffix, number);
        this.setText(this.text);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autoStart) {
            this.start();
        }
    }

    public void start() {
        this.removeCallbacks(this.counter);
        this.post(this.counter);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
        this.counter = new Counter(this, this.startValue, this.endValue, timeInterval, this.increment);
    }

    public void setIncrement(float increment) {
        this.increment = increment;
        this.counter = new Counter(this, this.startValue, this.endValue, this.timeInterval, increment);
    }

    public void setStartValue(float startValue) {
        this.startValue = startValue;
        this.counter = new Counter(this, startValue, this.endValue, this.timeInterval, this.increment);
    }

    public void setEndValue(float endValue) {
        this.endValue = endValue;
        this.counter = new Counter(this, this.startValue, endValue, this.timeInterval, this.increment);
    }

    public void setCounterType(CounterType counterType) {
        this.counterType = counterType;
        this.updateCounterType();
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setAutoFormat(boolean formatText) {
        this.formatter = this.autoFormat ? (this.counterType == CounterType.NUMBER ? new IntegerFormatter() : new DecimalFormatter()) : new NoFormatter();
        this.autoFormat = formatText;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }
}

