/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.smartcropperlib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ImageView;
import me.pqpo.smartcropperlib.R;
import me.pqpo.smartcropperlib.SmartCropper;
import me.pqpo.smartcropperlib.utils.CropUtils;

public class CropImageView
extends ImageView {
    private static final String TAG = "CropImageView";
    private static final float TOUCH_POINT_CATCH_DISTANCE = 15.0f;
    private static final float POINT_RADIUS = 10.0f;
    private static final float MAGNIFIER_CROSS_LINE_WIDTH = 0.8f;
    private static final float MAGNIFIER_CROSS_LINE_LENGTH = 3.0f;
    private static final float MAGNIFIER_BORDER_WIDTH = 1.0f;
    private static final int DEFAULT_LINE_COLOR = -16711681;
    private static final float DEFAULT_LINE_WIDTH = 1.0f;
    private static final int DEFAULT_MASK_ALPHA = 86;
    private static final int DEFAULT_MAGNIFIER_CROSS_COLOR = -49023;
    private static final float DEFAULT_GUIDE_LINE_WIDTH = 0.3f;
    private static final int DEFAULT_GUIDE_LINE_COLOR = -1;
    private static final int DEFAULT_POINT_FILL_COLOR = -1;
    private static final int DEFAULT_POINT_FILL_ALPHA = 175;
    private Paint mPointPaint;
    private Paint mPointFillPaint;
    private Paint mLinePaint;
    private Paint mMaskPaint;
    private Paint mGuideLinePaint;
    private Paint mMagnifierPaint;
    private Paint mMagnifierCrossPaint;
    private float mScaleX;
    private float mScaleY;
    private int mActWidth;
    private int mActHeight;
    private int mActLeft;
    private int mActTop;
    private Point mDraggingPoint = null;
    private float mDensity;
    private ShapeDrawable mMagnifierDrawable;
    private float[] mMatrixValue = new float[9];
    private Xfermode mMaskXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
    private Path mPointLinePath = new Path();
    private Matrix mMagnifierMatrix = new Matrix();
    Point[] mCropPoints;
    Point[] mEdgeMidPoints;
    float mLineWidth;
    int mPointColor;
    float mPointWidth;
    float mGuideLineWidth;
    int mPointFillColor = -1;
    int mPointFillAlpha = 175;
    int mLineColor = -16711681;
    int mMagnifierCrossColor = -49023;
    int mGuideLineColor = -1;
    int mMaskAlpha = 86;
    boolean mShowGuideLine = true;
    boolean mShowMagnifier = true;
    boolean mShowEdgeMidPoint = true;
    boolean mAutoScanEnable = true;
    boolean mDragLimit = true;
    private static final int P_LT = 0;
    private static final int P_RT = 1;
    private static final int P_RB = 2;
    private static final int P_LB = 3;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ImageView.ScaleType scaleType = this.getScaleType();
        if (scaleType == ImageView.ScaleType.FIT_END || scaleType == ImageView.ScaleType.FIT_START || scaleType == ImageView.ScaleType.MATRIX) {
            throw new RuntimeException("Image in CropImageView must be in center");
        }
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.initAttrs(context, attrs);
        this.initPaints();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView);
        this.mMaskAlpha = Math.min(Math.max(0, ta.getInt(R.styleable.CropImageView_civMaskAlpha, 86)), 255);
        this.mShowGuideLine = ta.getBoolean(R.styleable.CropImageView_civShowGuideLine, true);
        this.mLineColor = ta.getColor(R.styleable.CropImageView_civLineColor, -16711681);
        this.mLineWidth = ta.getDimension(R.styleable.CropImageView_civLineWidth, this.dp2px(1.0f));
        this.mPointColor = ta.getColor(R.styleable.CropImageView_civPointColor, -16711681);
        this.mPointWidth = ta.getDimension(R.styleable.CropImageView_civPointWidth, this.dp2px(1.0f));
        this.mMagnifierCrossColor = ta.getColor(R.styleable.CropImageView_civMagnifierCrossColor, -49023);
        this.mShowMagnifier = ta.getBoolean(R.styleable.CropImageView_civShowMagnifier, true);
        this.mGuideLineWidth = ta.getDimension(R.styleable.CropImageView_civGuideLineWidth, this.dp2px(0.3f));
        this.mGuideLineColor = ta.getColor(R.styleable.CropImageView_civGuideLineColor, -1);
        this.mPointFillColor = ta.getColor(R.styleable.CropImageView_civPointFillColor, -1);
        this.mShowEdgeMidPoint = ta.getBoolean(R.styleable.CropImageView_civShowEdgeMidPoint, true);
        this.mAutoScanEnable = ta.getBoolean(R.styleable.CropImageView_civAutoScanEnable, true);
        this.mPointFillAlpha = Math.min(Math.max(0, ta.getInt(R.styleable.CropImageView_civPointFillAlpha, 175)), 255);
        ta.recycle();
    }

    public void setAutoScanEnable(boolean mAutoScanEnable) {
        this.mAutoScanEnable = mAutoScanEnable;
    }

    public void setCropPoints(Point[] cropPoints) {
        if (this.getDrawable() == null) {
            Log.w((String)TAG, (String)"should call after set drawable");
            return;
        }
        if (!this.checkPoints(cropPoints)) {
            this.setFullImgCrop();
        } else {
            this.mCropPoints = cropPoints;
            this.invalidate();
        }
    }

    public void setEdgeMidPoints() {
        if (this.mEdgeMidPoints == null) {
            this.mEdgeMidPoints = new Point[4];
            for (int i = 0; i < this.mEdgeMidPoints.length; ++i) {
                this.mEdgeMidPoints[i] = new Point();
            }
        }
        int len = this.mCropPoints.length;
        for (int i = 0; i < len; ++i) {
            this.mEdgeMidPoints[i].set(this.mCropPoints[i].x + (this.mCropPoints[(i + 1) % len].x - this.mCropPoints[i].x) / 2, this.mCropPoints[i].y + (this.mCropPoints[(i + 1) % len].y - this.mCropPoints[i].y) / 2);
        }
    }

    public void setFullImgCrop() {
        if (this.getDrawable() == null) {
            Log.w((String)TAG, (String)"should call after set drawable");
            return;
        }
        this.mCropPoints = this.getFullImgCropPoints();
        this.invalidate();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mMagnifierDrawable = null;
    }

    public void setImageToCrop(Bitmap bmp) {
        this.setImageBitmap(bmp);
        this.setCropPoints(this.mAutoScanEnable ? SmartCropper.scan(bmp) : null);
    }

    public Point[] getCropPoints() {
        return this.mCropPoints;
    }

    public void setPointFillColor(int pointFillColor) {
        this.mPointFillColor = pointFillColor;
    }

    public void setPointFillAlpha(int pointFillAlpha) {
        this.mPointFillAlpha = pointFillAlpha;
    }

    public void setMaskAlpha(int maskAlpha) {
        this.mMaskAlpha = maskAlpha = Math.min(Math.max(0, maskAlpha), 255);
        this.invalidate();
    }

    public void setShowGuideLine(boolean showGuideLine) {
        this.mShowGuideLine = showGuideLine;
        this.invalidate();
    }

    public void setGuideLineColor(int guideLineColor) {
        this.mGuideLineColor = guideLineColor;
    }

    public void setGuideLineWidth(float guideLineWidth) {
        this.mGuideLineWidth = guideLineWidth;
    }

    public void setLineColor(int lineColor) {
        this.mLineColor = lineColor;
        this.invalidate();
    }

    public void setMagnifierCrossColor(int magnifierCrossColor) {
        this.mMagnifierCrossColor = magnifierCrossColor;
    }

    public void setLineWidth(int lineWidth) {
        this.mLineWidth = lineWidth;
        this.invalidate();
    }

    public void setPointColor(int pointColor) {
        this.mPointColor = pointColor;
        this.invalidate();
    }

    public void setPointWidth(float pointWidth) {
        this.mPointWidth = pointWidth;
        this.invalidate();
    }

    public void setShowMagnifier(boolean showMagnifier) {
        this.mShowMagnifier = showMagnifier;
    }

    public void setDragLimit(boolean dragLimit) {
        this.mDragLimit = dragLimit;
    }

    public Bitmap crop() {
        return this.crop(this.mCropPoints);
    }

    public Bitmap crop(Point[] points) {
        if (!this.checkPoints(points)) {
            return null;
        }
        Bitmap bmp = this.getBitmap();
        return bmp == null ? null : SmartCropper.crop(bmp, points);
    }

    public boolean canRightCrop() {
        if (!this.checkPoints(this.mCropPoints)) {
            return false;
        }
        Point lt = this.mCropPoints[0];
        Point rt = this.mCropPoints[1];
        Point rb = this.mCropPoints[2];
        Point lb = this.mCropPoints[3];
        return this.pointSideLine(lt, rb, lb) * this.pointSideLine(lt, rb, rt) < 0L && this.pointSideLine(lb, rt, lt) * this.pointSideLine(lb, rt, rb) < 0L;
    }

    public boolean checkPoints(Point[] points) {
        return points != null && points.length == 4 && points[0] != null && points[1] != null && points[2] != null && points[3] != null;
    }

    private long pointSideLine(Point lineP1, Point lineP2, Point point) {
        return this.pointSideLine(lineP1, lineP2, point.x, point.y);
    }

    private long pointSideLine(Point lineP1, Point lineP2, int x, int y) {
        long x1 = lineP1.x;
        long y1 = lineP1.y;
        long x2 = lineP2.x;
        long y2 = lineP2.y;
        return ((long)x - x1) * (y2 - y1) - ((long)y - y1) * (x2 - x1);
    }

    public Bitmap getBitmap() {
        Bitmap bmp = null;
        Drawable drawable = this.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            bmp = ((BitmapDrawable)drawable).getBitmap();
        }
        return bmp;
    }

    private void initPaints() {
        this.mPointPaint = new Paint(1);
        this.mPointPaint.setColor(this.mPointColor);
        this.mPointPaint.setStrokeWidth(this.mPointWidth);
        this.mPointPaint.setStyle(Paint.Style.STROKE);
        this.mPointFillPaint = new Paint(1);
        this.mPointFillPaint.setColor(this.mPointFillColor);
        this.mPointFillPaint.setStyle(Paint.Style.FILL);
        this.mPointFillPaint.setAlpha(this.mPointFillAlpha);
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setColor(this.mLineColor);
        this.mLinePaint.setStrokeWidth(this.mLineWidth);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mMaskPaint = new Paint(1);
        this.mMaskPaint.setColor(-16777216);
        this.mMaskPaint.setStyle(Paint.Style.FILL);
        this.mGuideLinePaint = new Paint(1);
        this.mGuideLinePaint.setColor(this.mGuideLineColor);
        this.mGuideLinePaint.setStyle(Paint.Style.FILL);
        this.mGuideLinePaint.setStrokeWidth(this.mGuideLineWidth);
        this.mMagnifierPaint = new Paint(1);
        this.mMagnifierPaint.setColor(-1);
        this.mMagnifierPaint.setStyle(Paint.Style.FILL);
        this.mMagnifierCrossPaint = new Paint(1);
        this.mMagnifierCrossPaint.setColor(this.mMagnifierCrossColor);
        this.mMagnifierCrossPaint.setStyle(Paint.Style.FILL);
        this.mMagnifierCrossPaint.setStrokeWidth(this.dp2px(0.8f));
    }

    private void initMagnifier() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-16777216);
        canvas.drawBitmap(this.getBitmap(), null, new Rect(this.mActLeft, this.mActTop, this.mActWidth + this.mActLeft, this.mActHeight + this.mActTop), null);
        canvas.save();
        BitmapShader magnifierShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mMagnifierDrawable = new ShapeDrawable((Shape)new OvalShape());
        this.mMagnifierDrawable.getPaint().setShader((Shader)magnifierShader);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.getDrawablePosition();
        this.onDrawCropPoint(canvas);
    }

    protected void onDrawCropPoint(Canvas canvas) {
        this.onDrawMask(canvas);
        this.onDrawGuideLine(canvas);
        this.onDrawLines(canvas);
        this.onDrawPoints(canvas);
        this.onDrawMagnifier(canvas);
    }

    protected void onDrawCusMagnifier(Canvas canvas) {
        DragPointType pointType = this.getPointType(this.mDraggingPoint);
        if (pointType == null || DragPointType.isEdgePoint(pointType)) {
            return;
        }
        if (this.mShowMagnifier && this.mDraggingPoint != null) {
            float radius;
            if (this.mMagnifierDrawable == null) {
                this.initMagnifier();
            }
            float draggingX = this.getViewPointX(this.mDraggingPoint);
            float draggingY = this.getViewPointY(this.mDraggingPoint);
            float cx = radius = (float)(this.getWidth() / 8);
            int lineOffset = (int)this.dp2px(1.0f);
            if (0 <= this.mDraggingPoint.x && this.mDraggingPoint.x < this.getDrawable().getIntrinsicWidth() / 2) {
                this.mMagnifierDrawable.setBounds(this.getWidth() - (int)radius * 2 + lineOffset, lineOffset, this.getWidth() - lineOffset, (int)radius * 2 - lineOffset);
                cx = (float)this.getWidth() - radius;
            } else {
                this.mMagnifierDrawable.setBounds(lineOffset, lineOffset, (int)radius * 2 - lineOffset, (int)radius * 2 - lineOffset);
            }
            canvas.drawCircle(cx, radius, radius, this.mMagnifierPaint);
            this.mMagnifierMatrix.setTranslate(radius - draggingX, radius - draggingY);
            this.mMagnifierDrawable.getPaint().getShader().setLocalMatrix(this.mMagnifierMatrix);
            this.mMagnifierDrawable.draw(canvas);
            canvas.drawCircle(cx, radius, this.dp2px(10.0f), this.mPointFillPaint);
            canvas.drawCircle(cx, radius, this.dp2px(10.0f), this.mPointPaint);
        }
    }

    protected void onDrawMagnifier(Canvas canvas) {
        if (this.mShowMagnifier && this.mDraggingPoint != null) {
            float radius;
            if (this.mMagnifierDrawable == null) {
                this.initMagnifier();
            }
            float draggingX = this.getViewPointX(this.mDraggingPoint);
            float draggingY = this.getViewPointY(this.mDraggingPoint);
            float cx = radius = (float)(this.getWidth() / 8);
            int lineOffset = (int)this.dp2px(1.0f);
            this.mMagnifierDrawable.setBounds(lineOffset, lineOffset, (int)radius * 2 - lineOffset, (int)radius * 2 - lineOffset);
            double pointsDistance = CropUtils.getPointsDistance(draggingX, draggingY, 0.0f, 0.0f);
            if (pointsDistance < (double)radius * 2.5) {
                this.mMagnifierDrawable.setBounds(this.getWidth() - (int)radius * 2 + lineOffset, lineOffset, this.getWidth() - lineOffset, (int)radius * 2 - lineOffset);
                cx = (float)this.getWidth() - radius;
            }
            canvas.drawCircle(cx, radius, radius, this.mMagnifierPaint);
            this.mMagnifierMatrix.setTranslate(radius - draggingX, radius - draggingY);
            this.mMagnifierDrawable.getPaint().getShader().setLocalMatrix(this.mMagnifierMatrix);
            this.mMagnifierDrawable.draw(canvas);
            float crossLength = this.dp2px(3.0f);
            canvas.drawLine(cx, radius - crossLength, cx, radius + crossLength, this.mMagnifierCrossPaint);
            canvas.drawLine(cx - crossLength, radius, cx + crossLength, radius, this.mMagnifierCrossPaint);
        }
    }

    protected void onDrawGuideLine(Canvas canvas) {
        if (!this.mShowGuideLine) {
            return;
        }
        int widthStep = this.mActWidth / 3;
        int heightStep = this.mActHeight / 3;
        canvas.drawLine((float)(this.mActLeft + widthStep), (float)this.mActTop, (float)(this.mActLeft + widthStep), (float)(this.mActTop + this.mActHeight), this.mGuideLinePaint);
        canvas.drawLine((float)(this.mActLeft + widthStep * 2), (float)this.mActTop, (float)(this.mActLeft + widthStep * 2), (float)(this.mActTop + this.mActHeight), this.mGuideLinePaint);
        canvas.drawLine((float)this.mActLeft, (float)(this.mActTop + heightStep), (float)(this.mActLeft + this.mActWidth), (float)(this.mActTop + heightStep), this.mGuideLinePaint);
        canvas.drawLine((float)this.mActLeft, (float)(this.mActTop + heightStep * 2), (float)(this.mActLeft + this.mActWidth), (float)(this.mActTop + heightStep * 2), this.mGuideLinePaint);
    }

    protected void onDrawMask(Canvas canvas) {
        if (this.mMaskAlpha <= 0) {
            return;
        }
        Path path = this.resetPointPath();
        if (path != null) {
            int sc = canvas.saveLayer((float)this.mActLeft, (float)this.mActTop, (float)(this.mActLeft + this.mActWidth), (float)(this.mActTop + this.mActHeight), this.mMaskPaint, 31);
            this.mMaskPaint.setAlpha(this.mMaskAlpha);
            canvas.drawRect((float)this.mActLeft, (float)this.mActTop, (float)(this.mActLeft + this.mActWidth), (float)(this.mActTop + this.mActHeight), this.mMaskPaint);
            this.mMaskPaint.setXfermode(this.mMaskXfermode);
            this.mMaskPaint.setAlpha(255);
            canvas.drawPath(path, this.mMaskPaint);
            this.mMaskPaint.setXfermode(null);
            canvas.restoreToCount(sc);
        }
    }

    private Path resetPointPath() {
        if (!this.checkPoints(this.mCropPoints)) {
            return null;
        }
        this.mPointLinePath.reset();
        Point lt = this.mCropPoints[0];
        Point rt = this.mCropPoints[1];
        Point rb = this.mCropPoints[2];
        Point lb = this.mCropPoints[3];
        this.mPointLinePath.moveTo(this.getViewPointX(lt), this.getViewPointY(lt));
        this.mPointLinePath.lineTo(this.getViewPointX(rt), this.getViewPointY(rt));
        this.mPointLinePath.lineTo(this.getViewPointX(rb), this.getViewPointY(rb));
        this.mPointLinePath.lineTo(this.getViewPointX(lb), this.getViewPointY(lb));
        this.mPointLinePath.close();
        return this.mPointLinePath;
    }

    private void getDrawablePosition() {
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            this.getImageMatrix().getValues(this.mMatrixValue);
            this.mScaleX = this.mMatrixValue[0];
            this.mScaleY = this.mMatrixValue[4];
            int origW = drawable.getIntrinsicWidth();
            int origH = drawable.getIntrinsicHeight();
            this.mActWidth = Math.round((float)origW * this.mScaleX);
            this.mActHeight = Math.round((float)origH * this.mScaleY);
            this.mActLeft = (this.getWidth() - this.mActWidth) / 2;
            this.mActTop = (this.getHeight() - this.mActHeight) / 2;
        }
    }

    protected void onDrawLines(Canvas canvas) {
        Path path = this.resetPointPath();
        if (path != null) {
            canvas.drawPath(path, this.mLinePaint);
        }
    }

    protected void onDrawPoints(Canvas canvas) {
        if (!this.checkPoints(this.mCropPoints)) {
            return;
        }
        for (Point point : this.mCropPoints) {
            canvas.drawCircle(this.getViewPointX(point), this.getViewPointY(point), this.dp2px(10.0f), this.mPointFillPaint);
            canvas.drawCircle(this.getViewPointX(point), this.getViewPointY(point), this.dp2px(10.0f), this.mPointPaint);
        }
        if (this.mShowEdgeMidPoint) {
            this.setEdgeMidPoints();
            for (Point point : this.mEdgeMidPoints) {
                canvas.drawCircle(this.getViewPointX(point), this.getViewPointY(point), this.dp2px(10.0f), this.mPointFillPaint);
                canvas.drawCircle(this.getViewPointX(point), this.getViewPointY(point), this.dp2px(10.0f), this.mPointPaint);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handle = true;
        switch (action) {
            case 0: {
                this.mDraggingPoint = this.getNearbyPoint(event);
                if (this.mDraggingPoint != null) break;
                handle = false;
                break;
            }
            case 2: {
                this.toImagePointSize(this.mDraggingPoint, event);
                break;
            }
            case 1: {
                this.mDraggingPoint = null;
            }
        }
        this.invalidate();
        return handle || super.onTouchEvent(event);
    }

    private Point getNearbyPoint(MotionEvent event) {
        if (this.checkPoints(this.mCropPoints)) {
            for (Point p : this.mCropPoints) {
                if (!this.isTouchPoint(p, event)) continue;
                return p;
            }
        }
        if (this.checkPoints(this.mEdgeMidPoints)) {
            for (Point p : this.mEdgeMidPoints) {
                if (!this.isTouchPoint(p, event)) continue;
                return p;
            }
        }
        return null;
    }

    private boolean isTouchPoint(Point p, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        float px = this.getViewPointX(p);
        float py = this.getViewPointY(p);
        double distance = Math.sqrt(Math.pow(x - px, 2.0) + Math.pow(y - py, 2.0));
        return distance < (double)this.dp2px(15.0f);
    }

    private void toImagePointSize(Point dragPoint, MotionEvent event) {
        if (dragPoint == null) {
            return;
        }
        DragPointType pointType = this.getPointType(dragPoint);
        int x = (int)((Math.min(Math.max(event.getX(), (float)this.mActLeft), (float)(this.mActLeft + this.mActWidth)) - (float)this.mActLeft) / this.mScaleX);
        int y = (int)((Math.min(Math.max(event.getY(), (float)this.mActTop), (float)(this.mActTop + this.mActHeight)) - (float)this.mActTop) / this.mScaleY);
        if (this.mDragLimit && pointType != null) {
            switch (pointType) {
                case LEFT_TOP: {
                    if (this.canMoveLeftTop(x, y)) break;
                    return;
                }
                case RIGHT_TOP: {
                    if (this.canMoveRightTop(x, y)) break;
                    return;
                }
                case RIGHT_BOTTOM: {
                    if (this.canMoveRightBottom(x, y)) break;
                    return;
                }
                case LEFT_BOTTOM: {
                    if (this.canMoveLeftBottom(x, y)) break;
                    return;
                }
                case TOP: {
                    if (this.canMoveLeftTop(x, y) && this.canMoveRightTop(x, y)) break;
                    return;
                }
                case RIGHT: {
                    if (this.canMoveRightTop(x, y) && this.canMoveRightBottom(x, y)) break;
                    return;
                }
                case BOTTOM: {
                    if (this.canMoveLeftBottom(x, y) && this.canMoveRightBottom(x, y)) break;
                    return;
                }
                case LEFT: {
                    if (this.canMoveLeftBottom(x, y) && this.canMoveLeftTop(x, y)) break;
                    return;
                }
            }
        }
        if (DragPointType.isEdgePoint(pointType)) {
            int xoff = x - dragPoint.x;
            int yoff = y - dragPoint.y;
            this.moveEdge(pointType, xoff, yoff);
        } else {
            dragPoint.y = y;
            dragPoint.x = x;
        }
    }

    private void moveEdge(DragPointType type, int xoff, int yoff) {
        switch (type) {
            case TOP: {
                this.movePoint(this.mCropPoints[0], 0, yoff);
                this.movePoint(this.mCropPoints[1], 0, yoff);
                break;
            }
            case RIGHT: {
                this.movePoint(this.mCropPoints[1], xoff, 0);
                this.movePoint(this.mCropPoints[2], xoff, 0);
                break;
            }
            case BOTTOM: {
                this.movePoint(this.mCropPoints[3], 0, yoff);
                this.movePoint(this.mCropPoints[2], 0, yoff);
                break;
            }
            case LEFT: {
                this.movePoint(this.mCropPoints[0], xoff, 0);
                this.movePoint(this.mCropPoints[3], xoff, 0);
                break;
            }
        }
    }

    private void movePoint(Point point, int xoff, int yoff) {
        if (point == null) {
            return;
        }
        int x = point.x + xoff;
        int y = point.y + yoff;
        if (x < 0 || x > this.getDrawable().getIntrinsicWidth()) {
            return;
        }
        if (y < 0 || y > this.getDrawable().getIntrinsicHeight()) {
            return;
        }
        point.x = x;
        point.y = y;
    }

    private boolean canMoveLeftTop(int x, int y) {
        if (this.pointSideLine(this.mCropPoints[1], this.mCropPoints[3], x, y) * this.pointSideLine(this.mCropPoints[1], this.mCropPoints[3], this.mCropPoints[2]) > 0L) {
            return false;
        }
        if (this.pointSideLine(this.mCropPoints[1], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[1], this.mCropPoints[2], this.mCropPoints[3]) < 0L) {
            return false;
        }
        return this.pointSideLine(this.mCropPoints[3], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[3], this.mCropPoints[2], this.mCropPoints[1]) >= 0L;
    }

    private boolean canMoveRightTop(int x, int y) {
        if (this.pointSideLine(this.mCropPoints[0], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[2], this.mCropPoints[3]) > 0L) {
            return false;
        }
        if (this.pointSideLine(this.mCropPoints[0], this.mCropPoints[3], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[3], this.mCropPoints[2]) < 0L) {
            return false;
        }
        return this.pointSideLine(this.mCropPoints[3], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[3], this.mCropPoints[2], this.mCropPoints[0]) >= 0L;
    }

    private boolean canMoveRightBottom(int x, int y) {
        if (this.pointSideLine(this.mCropPoints[1], this.mCropPoints[3], x, y) * this.pointSideLine(this.mCropPoints[1], this.mCropPoints[3], this.mCropPoints[0]) > 0L) {
            return false;
        }
        if (this.pointSideLine(this.mCropPoints[0], this.mCropPoints[1], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[1], this.mCropPoints[3]) < 0L) {
            return false;
        }
        return this.pointSideLine(this.mCropPoints[0], this.mCropPoints[3], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[3], this.mCropPoints[1]) >= 0L;
    }

    private boolean canMoveLeftBottom(int x, int y) {
        if (this.pointSideLine(this.mCropPoints[0], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[2], this.mCropPoints[1]) > 0L) {
            return false;
        }
        if (this.pointSideLine(this.mCropPoints[0], this.mCropPoints[1], x, y) * this.pointSideLine(this.mCropPoints[0], this.mCropPoints[1], this.mCropPoints[2]) < 0L) {
            return false;
        }
        return this.pointSideLine(this.mCropPoints[1], this.mCropPoints[2], x, y) * this.pointSideLine(this.mCropPoints[1], this.mCropPoints[2], this.mCropPoints[0]) >= 0L;
    }

    private DragPointType getPointType(Point dragPoint) {
        int i;
        if (dragPoint == null) {
            return null;
        }
        if (this.checkPoints(this.mCropPoints)) {
            for (i = 0; i < this.mCropPoints.length; ++i) {
                if (dragPoint != this.mCropPoints[i]) continue;
                DragPointType type = DragPointType.values()[i];
                return type;
            }
        }
        if (this.checkPoints(this.mEdgeMidPoints)) {
            for (i = 0; i < this.mEdgeMidPoints.length; ++i) {
                if (dragPoint != this.mEdgeMidPoints[i]) continue;
                DragPointType type = DragPointType.values()[4 + i];
                return type;
            }
        }
        return null;
    }

    private float getViewPointX(Point point) {
        return this.getViewPointX(point.x);
    }

    private float getViewPointX(float x) {
        return x * this.mScaleX + (float)this.mActLeft;
    }

    private float getViewPointY(Point point) {
        return this.getViewPointY(point.y);
    }

    private float getViewPointY(float y) {
        return y * this.mScaleY + (float)this.mActTop;
    }

    private float dp2px(float dp) {
        return dp * this.mDensity;
    }

    private Point[] getFullImgCropPoints() {
        Point[] points = new Point[4];
        Drawable drawable = this.getDrawable();
        if (drawable != null) {
            int width = drawable.getIntrinsicWidth();
            int height = drawable.getIntrinsicHeight();
            points[0] = new Point(0, 0);
            points[1] = new Point(width, 0);
            points[2] = new Point(width, height);
            points[3] = new Point(0, height);
        }
        return points;
    }

    static enum DragPointType {
        LEFT_TOP,
        RIGHT_TOP,
        RIGHT_BOTTOM,
        LEFT_BOTTOM,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;


        public static boolean isEdgePoint(DragPointType type) {
            return type == TOP || type == RIGHT || type == BOTTOM || type == LEFT;
        }
    }
}

