/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a;

import java.util.ArrayList;
import java.util.List;
import me.pqpo.librarylog4a.appender.AndroidAppender;
import me.pqpo.librarylog4a.appender.Appender;
import me.pqpo.librarylog4a.appender.FileAppender;

public class Logger {
    private List<Appender> appenderList = new ArrayList<Appender>();

    protected Logger() {
    }

    public List<Appender> getAppenderList() {
        return this.appenderList;
    }

    public void addAppender(Appender appender) {
        if (appender != null) {
            this.appenderList.add(appender);
        }
    }

    protected void println(int priority, String tag, String msg) {
        if (this.appenderList == null) {
            return;
        }
        for (Appender appender : this.appenderList) {
            appender.append(priority, tag, msg);
        }
    }

    public void flush() {
        for (Appender appender : this.appenderList) {
            appender.flush();
        }
    }

    public void release() {
        for (Appender appender : this.appenderList) {
            appender.release();
        }
        this.appenderList.clear();
    }

    public static class Builder {
        private Logger logger = new Logger();

        public Builder addAppender(Appender appender) {
            this.logger.addAppender(appender);
            return this;
        }

        public Builder enableAndroidAppender(AndroidAppender.Builder builder) {
            this.logger.addAppender(builder.create());
            return this;
        }

        public Builder enableFileAppender(FileAppender.Builder builder) {
            if (builder != null) {
                this.logger.addAppender(builder.create());
            }
            return this;
        }

        public Logger create() {
            return this.logger;
        }
    }
}

