/*
 * Decompiled with CFR 0.152.
 */
package me.pqpo.librarylog4a.formatter;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import me.pqpo.librarylog4a.Level;
import me.pqpo.librarylog4a.formatter.Formatter;

public class DateFileFormatter
implements Formatter {
    private SimpleDateFormat simpleDateFormat = null;
    private Date mDate;
    private String lastDataFormated = null;
    private StringBuffer mStringBuffer;
    private int mTimeLength = 0;

    public DateFileFormatter() {
        this("yyyy:MM:dd HH:mm:ss");
    }

    public DateFileFormatter(String pattern) {
        this.simpleDateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        this.mStringBuffer = new StringBuffer();
        Calendar instance = Calendar.getInstance();
        instance.set(13, 0);
        this.mDate = instance.getTime();
    }

    @Override
    public synchronized String format(int logLevel, String tag, String msg) {
        if (System.currentTimeMillis() - this.mDate.getTime() > 1000L || this.lastDataFormated == null) {
            this.mDate.setTime(System.currentTimeMillis());
            this.lastDataFormated = this.simpleDateFormat.format(this.mDate);
            this.resetTimePrefix();
            return this.formatString(logLevel, tag, msg);
        }
        return this.formatString(logLevel, tag, msg);
    }

    private void resetTimePrefix() {
        if (this.mStringBuffer.length() > 0) {
            this.mStringBuffer.delete(0, this.mStringBuffer.length());
        }
        this.mTimeLength = this.mStringBuffer.append(this.lastDataFormated).append(' ').length();
    }

    private String formatString(int logLevel, String tag, String msg) {
        if (this.mStringBuffer.length() > this.mTimeLength) {
            this.mStringBuffer.delete(this.mTimeLength, this.mStringBuffer.length());
        }
        return this.mStringBuffer.append(Level.getShortLevelName(logLevel)).append(tag).append(msg).append('\n').toString();
    }
}

