/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.tools.ConversionUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.InvalidScope;
import org.apache.velocity.tools.view.BrowserToolDeprecatedMethods;
import org.apache.velocity.tools.view.UAParser;

@DefaultKey(value="browser")
@InvalidScope(value={"application"})
public class BrowserTool
extends BrowserToolDeprecatedMethods
implements Serializable {
    private static final long serialVersionUID = 1734529350532353339L;
    private String IPAddress = null;
    private String userAgentString = null;
    private String lowercaseUserAgentString = null;
    private UAParser.UserAgent userAgent = null;
    private String acceptLanguage = null;
    private SortedMap<Float, List<String>> languageRangesByQuality = null;
    private String starLanguageRange = null;
    private List<String> languagesFilter = null;
    private String preferredLanguage = null;
    private static Pattern quality = Pattern.compile("^q\\s*=\\s*((?:0|1)(?:.\\d{0,3})?)$");
    private static Set<String> linuxDistros = null;

    public void setRequest(HttpServletRequest request) {
        if (request != null) {
            int coma;
            this.setUserAgentString(request.getHeader("User-Agent"));
            this.setAcceptLanguage(request.getHeader("Accept-Language"));
            this.IPAddress = request.getHeader("X-FORWARDED-FOR");
            if (this.IPAddress == null) {
                this.IPAddress = request.getRemoteAddr();
            }
            if (this.IPAddress != null && (coma = this.IPAddress.indexOf(44)) != -1) {
                this.IPAddress = this.IPAddress.substring(0, coma);
            }
        } else {
            this.setUserAgentString(null);
            this.setAcceptLanguage(null);
        }
    }

    public void setUserAgentString(String ua) {
        this.userAgentString = null;
        this.userAgent = null;
        this.preferredLanguage = null;
        this.acceptLanguage = null;
        this.languageRangesByQuality = null;
        this.starLanguageRange = null;
        if (ua == null) {
            this.lowercaseUserAgentString = "";
        } else {
            this.userAgentString = ua;
            this.lowercaseUserAgentString = ua.toLowerCase();
            this.userAgent = UAParser.parseUserAgent(ua, this.getLog());
        }
    }

    public void setAcceptLanguage(String al) {
        this.acceptLanguage = al == null ? "" : al.toLowerCase();
    }

    public void setLanguagesFilter(String filter) {
        this.languagesFilter = filter == null || filter.length() == 0 ? null : Arrays.asList(filter.split(","));
        this.preferredLanguage = null;
    }

    public String getLanguagesFilter() {
        return this.languagesFilter.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ua=" + this.userAgentString + "]";
    }

    public boolean get(String key) {
        return this.test(key);
    }

    @Override
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public String getDevice() {
        return this.userAgent == null ? null : this.userAgent.getDeviceType().toString().toLowerCase();
    }

    public boolean isRobot() {
        return this.userAgent != null && this.userAgent.getDeviceType() == UAParser.DeviceType.ROBOT;
    }

    public boolean isTablet() {
        return this.userAgent == null && this.userAgent.getDeviceType() == UAParser.DeviceType.TABLET;
    }

    public boolean isMobile() {
        return this.userAgent == null && this.userAgent.getDeviceType() == UAParser.DeviceType.MOBILE;
    }

    public boolean isDesktop() {
        return this.userAgent == null && this.userAgent.getDeviceType() == UAParser.DeviceType.DESKTOP;
    }

    public boolean isTV() {
        return this.userAgent == null && this.userAgent.getDeviceType() == UAParser.DeviceType.TV;
    }

    @Override
    public UAParser.UAEntity getBrowser() {
        return this.userAgent == null ? null : this.userAgent.getBrowser();
    }

    @Override
    public UAParser.UAEntity getRenderingEngine() {
        return this.userAgent == null ? null : this.userAgent.getRenderingEngine();
    }

    @Override
    public UAParser.UAEntity getOperatingSystem() {
        return this.userAgent == null ? null : this.userAgent.getOperatingSystem();
    }

    @Override
    public boolean isGecko() {
        return this.getRenderingEngine() != null && "Gecko".equals(this.getRenderingEngine().getName());
    }

    public boolean isWebKit() {
        return this.getRenderingEngine() != null && "AppleWebKit".equals(this.getRenderingEngine().getName());
    }

    public boolean isKHTML() {
        return this.getRenderingEngine() != null && "KHTML".equals(this.getRenderingEngine().getName());
    }

    public boolean isTrident() {
        return this.getRenderingEngine() != null && "Trident".equals(this.getRenderingEngine().getName());
    }

    public boolean isBlink() {
        return this.getRenderingEngine() != null && "Blink".equals(this.getRenderingEngine().getName());
    }

    public boolean isEdgeHTML() {
        return this.getRenderingEngine() != null && "EdgeHTML".equals(this.getRenderingEngine().getName());
    }

    public boolean isPresto() {
        return this.getRenderingEngine() != null && "Presto".equals(this.getRenderingEngine().getName());
    }

    @Override
    public boolean isChrome() {
        return this.getBrowser() != null && ("Chrome".equals(this.getBrowser().getName()) || "Chromium".equals(this.getBrowser().getName()));
    }

    @Override
    public boolean isMSIE() {
        return this.getBrowser() != null && "MSIE".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isFirefox() {
        return this.getBrowser() != null && ("Firefox".equals(this.getBrowser().getName()) || "Iceweasel".equals(this.getBrowser().getName()));
    }

    @Override
    public boolean isOpera() {
        return this.getBrowser() != null && ("Opera".equals(this.getBrowser().getName()) || "Opera Mobile".equals(this.getBrowser().getName()));
    }

    @Override
    public boolean isSafari() {
        return this.getBrowser() != null && "Safari".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isNetscape() {
        return this.getBrowser() != null && "Netscape".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isKonqueror() {
        return this.getBrowser() != null && "Konqueror".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isLinks() {
        return this.getBrowser() != null && "Links".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isMozilla() {
        return this.getBrowser() != null && "Mozilla".equals(this.getBrowser().getName());
    }

    @Override
    public boolean isWindows() {
        return this.getOperatingSystem() != null && this.getOperatingSystem().getName().startsWith("Windows");
    }

    @Override
    public boolean isOSX() {
        return this.getOperatingSystem() != null && (this.getOperatingSystem().getName().equals("OS X") || this.getOperatingSystem().getName().equals("iOS"));
    }

    @Override
    public boolean isLinux() {
        return this.getOperatingSystem() != null && (this.getOperatingSystem().getName().startsWith("Linux") || linuxDistros.contains(this.getOperatingSystem().getName()));
    }

    public boolean isBSD() {
        return this.getOperatingSystem() != null && this.getOperatingSystem().getName().endsWith("BSD");
    }

    public boolean isUnix() {
        if (this.getOperatingSystem() != null) {
            String osname = this.getOperatingSystem().getName().toLowerCase();
            return osname.indexOf("unix") != -1 || osname.equals("bsd") || osname.equals("sunos");
        }
        return false;
    }

    public boolean isAndroid() {
        return this.getOperatingSystem() != null && this.getOperatingSystem().getName().startsWith("Android");
    }

    public boolean isIOS() {
        if (this.getOperatingSystem() != null) {
            String osName = this.getOperatingSystem().getName();
            return osName.startsWith("iOS") || osName.startsWith("iPhone") || osName.startsWith("iPad");
        }
        return false;
    }

    public boolean isSymbian() {
        return this.getOperatingSystem() != null && this.getOperatingSystem().getName().startsWith("Symb");
    }

    public boolean isBlackberry() {
        return this.getOperatingSystem() != null && (this.getOperatingSystem().getName().startsWith("BlackBerry") || this.getOperatingSystem().getName().equals("PlayBook"));
    }

    public boolean getCss3() {
        return this.isTrident() && this.getRenderingEngine().getMajorVersion() >= 9 || this.isEdgeHTML() || this.isGecko() && (this.getRenderingEngine().getMajorVersion() >= 2 || this.getRenderingEngine().getMinorVersion() >= 9) || this.isWebKit() && this.getRenderingEngine().getMajorVersion() >= 85 || this.isKHTML() && (this.getRenderingEngine().getMajorVersion() >= 4 || this.getRenderingEngine().getMajorVersion() == 3 && this.getRenderingEngine().getMinorVersion() >= 4) || this.isPresto() && this.getRenderingEngine().getMajorVersion() >= 2;
    }

    public boolean getDom3() {
        return this.isEdgeHTML() || this.isTrident() && this.getRenderingEngine().getMajorVersion() >= 9 || this.isGecko() && (this.getRenderingEngine().getMajorVersion() >= 2 || this.getRenderingEngine().getMinorVersion() >= 7) || this.isWebKit() && this.getRenderingEngine().getMajorVersion() >= 601;
    }

    public String getPreferredLanguage() {
        if (this.preferredLanguage != null) {
            return this.preferredLanguage;
        }
        this.parseAcceptLanguage();
        if (this.languageRangesByQuality.size() == 0) {
            this.preferredLanguage = this.starLanguageRange;
        } else {
            ArrayList<List<String>> lists = new ArrayList<List<String>>(this.languageRangesByQuality.values());
            Collections.reverse(lists);
            for (List list : lists) {
                for (String l : list) {
                    this.preferredLanguage = this.filterLanguageTag(l);
                    if (this.preferredLanguage == null) continue;
                    break;
                }
                if (this.preferredLanguage == null) continue;
                break;
            }
        }
        if (this.preferredLanguage == null) {
            this.preferredLanguage = this.filterLanguageTag(this.languagesFilter == null ? this.getLocale().getLanguage() : this.languagesFilter.get(0));
        }
        assert (this.preferredLanguage != null);
        return this.preferredLanguage;
    }

    public Locale getPreferredLocale() {
        return ConversionUtils.toLocale((String)this.getPreferredLanguage());
    }

    @Override
    protected boolean test(String key) {
        return key == null ? null : Boolean.valueOf(this.lowercaseUserAgentString.indexOf(key.toLowerCase()) != -1);
    }

    private void parseAcceptLanguage() {
        if (this.languageRangesByQuality != null) {
            return;
        }
        this.languageRangesByQuality = new TreeMap<Float, List<String>>();
        StringTokenizer languageTokenizer = new StringTokenizer(this.acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            if (qValueIndex == -1) {
                language = language.replace('-', '_');
                ArrayList<String> l = (ArrayList<String>)this.languageRangesByQuality.get(Float.valueOf(1.0f));
                if (l == null) {
                    l = new ArrayList<String>();
                    this.languageRangesByQuality.put(Float.valueOf(1.0f), l);
                }
                l.add(language);
                continue;
            }
            String code = language.substring(0, qValueIndex).trim().replace('-', '_');
            String qval = language.substring(qValueIndex + 1).trim();
            if ("*".equals(qval)) {
                this.starLanguageRange = code;
                continue;
            }
            Matcher m = quality.matcher(qval);
            if (m.matches()) {
                Float q = Float.valueOf(m.group(1));
                ArrayList<String> al = (ArrayList<String>)this.languageRangesByQuality.get(q);
                if (al == null) {
                    al = new ArrayList<String>();
                    this.languageRangesByQuality.put(q, al);
                }
                al.add(code);
                continue;
            }
            this.getLog().error("BrowserTool: could not parse language quality value: {}", (Object)language);
        }
    }

    private String filterLanguageTag(String languageTag) {
        String[] parts;
        languageTag = languageTag.replace('-', '_');
        if (this.languagesFilter == null) {
            return languageTag;
        }
        if (this.languagesFilter.contains(languageTag)) {
            return languageTag;
        }
        if (languageTag.contains("_") && this.languagesFilter.contains((parts = languageTag.split("_"))[0])) {
            return parts[0];
        }
        return null;
    }

    static {
        linuxDistros = new HashSet<String>();
        linuxDistros.add("Ubuntu");
        linuxDistros.add("Debian");
        linuxDistros.add("Red Hat");
        linuxDistros.add("Fedora");
        linuxDistros.add("Slackware");
        linuxDistros.add("SUSE");
        linuxDistros.add("ArchLinux");
        linuxDistros.add("Gentoo");
        linuxDistros.add("openSUSE");
        linuxDistros.add("Manjaro");
        linuxDistros.add("Mandriva");
        linuxDistros.add("PCLinuxOS");
        linuxDistros.add("CentOS");
        linuxDistros.add("Tizen");
        linuxDistros.add("Mint");
        linuxDistros.add("StartOS");
    }
}

