/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import android.widget.ScrollView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.EmptyController;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeController;
import com.powyin.scroll.widget.SwipeControllerStyleNormal;

public class SwipeRefresh
extends ViewGroup
implements NestedScrollingParent,
ISwipe {
    private int mTouchSlop;
    private final NestedScrollingParentHelper mParentHelper;
    private boolean mNestedScrollInProgress = false;
    private int mActivePointerId = -1;
    private float mDragBeginY;
    private float mDragBeginDirect;
    private float mDragLastY;
    private ScrollerCompat mScroller;
    private VelocityTracker mVelocityTracker;
    private boolean mIsTouchEventMode = false;
    private boolean mPreScroll;
    private boolean mDraggedDispatch;
    private boolean mDraggedIntercept;
    private SwipeController mSwipeController;
    private EmptyController mEmptyController;
    private ValueAnimator animationScrollY;
    private boolean mRefreshStatusContinueRunning = false;
    private ISwipe.FreshStatus mFreshStatus = null;
    private boolean mLoadedStatusContinueRunning = false;
    private ISwipe.LoadedStatus mLoadedStatus = null;
    private SwipeController.SwipeModel mModel = SwipeController.SwipeModel.SWIPE_BOTH;
    private ISwipe.OnRefreshListener mOnRefreshListener;
    private View mViewTop;
    private View mViewBottom;
    private View mEmptyView;
    private View mTargetView;
    private boolean mShowEmptyView;
    private int mContentScroll;
    private int mOverScrollTop;
    private int mOverScrollTopMiddle;
    private int mOverScrollBottomMiddle;
    private int mOverScrollBottom;
    private boolean mLoadMoreOverScroll = true;
    private int mMaxFlingDirection = 0;
    private int preScroll = Integer.MIN_VALUE;

    public SwipeRefresh(Context context) {
        this(context, null);
    }

    public SwipeRefresh(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRefresh(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeRefresh);
            int modelIndex = a.getInt(R.styleable.SwipeRefresh_fresh_model, -1);
            if (modelIndex >= 0 && modelIndex < SwipeController.SwipeModel.values().length) {
                this.mModel = SwipeController.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.mScroller = ScrollerCompat.create((Context)this.getContext(), null);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.initSwipeControl();
    }

    private void initSwipeControl() {
        this.mSwipeController = new SwipeControllerStyleNormal(this.getContext());
        this.mViewTop = this.mSwipeController.getSwipeHead();
        this.mViewBottom = this.mSwipeController.getSwipeFoot();
        this.addView(this.mViewTop, 0);
        this.addView(this.mViewBottom, this.getChildCount());
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        ScrollingView scrollingView;
        int range;
        if (!this.mLoadedStatusContinueRunning && this.mOnRefreshListener != null && target instanceof ScrollingView && (range = (scrollingView = (ScrollingView)target).computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent()) < 6 * this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        this.mTargetView = target;
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetScroll(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.tryBackToLoading()) {
            // empty if block
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetScroll(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (velocityY < 0.0f || this.mLoadedStatusContinueRunning || this.mOnRefreshListener == null || !(target instanceof ScrollingView)) {
            return false;
        }
        float radio = velocityY / (float)this.getHeight();
        radio = radio > 1.0f ? radio : 1.0f;
        radio = radio < 10.0f ? radio : 10.0f;
        ScrollingView scrollingView = (ScrollingView)target;
        int range = scrollingView.computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent();
        if ((float)range < radio * (float)this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        int scrollY = this.getScrollY();
        if (scrollY > 0 && scrollY < this.mOverScrollBottomMiddle) {
            this.fling((int)velocityY);
        }
        return scrollY != 0;
    }

    private void fling(int velocityY) {
        if (this.animationScrollY != null && this.animationScrollY.isStarted() || velocityY == 0) {
            return;
        }
        int currentScrollY = this.getScrollY();
        if (this.mContentScroll == 0 && currentScrollY == 0 && velocityY > 0 && !this.canChildScrollDown()) {
            return;
        }
        this.mMaxFlingDirection = velocityY > 0 ? 1 : -1;
        this.mScroller.fling(0, currentScrollY, 0, velocityY, 0, 0, -1000000, 1000000, 0, 0);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int offSetScroll(int deltaOriginY, boolean pre) {
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int currentScrollY = this.getScrollY();
        if (deltaOriginY < 0 && currentScrollY < -this.mOverScrollTopMiddle && this.mOverScrollTop != this.mOverScrollTopMiddle) {
            int n = deltaY = (deltaY = (int)((double)deltaY * Math.pow((float)(-this.mOverScrollTop - currentScrollY) * 1.0f / (float)(this.mOverScrollTop - this.mOverScrollTopMiddle), 3.0))) < 0 ? deltaY : -deltaY;
        }
        if (deltaOriginY > 0 && currentScrollY > this.mOverScrollBottomMiddle + this.mContentScroll && this.mOverScrollBottom != this.mOverScrollBottomMiddle) {
            int n = deltaY = (deltaY = (int)((double)deltaY * Math.pow((float)(this.mOverScrollBottom + this.mContentScroll - currentScrollY) * 1.0f / (float)(this.mOverScrollBottom - this.mOverScrollBottomMiddle), 3.0))) > 0 ? deltaY : -deltaY;
        }
        if (currentScrollY != this.mContentScroll || !pre) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, this.mOverScrollBottom);
            willTo = Math.max(willTo, -this.mOverScrollTop);
            if (currentScrollY > 0 && willTo < 0 || currentScrollY < 0 && willTo > 0) {
                willTo = 0;
            }
            if (currentScrollY > this.mContentScroll && willTo < this.mContentScroll || currentScrollY < this.mContentScroll && willTo > this.mContentScroll) {
                willTo = this.mContentScroll;
            }
            if (this.mDragBeginDirect > 0.0f && willTo > this.mContentScroll) {
                willTo = this.mContentScroll;
            }
            if (this.mDragBeginDirect < 0.0f && willTo < 0) {
                willTo = 0;
            }
            if (willTo > 0 && !this.canChildScrollDown()) {
                willTo = 0;
            }
            if (willTo == currentScrollY) {
                return deltaOriginY;
            }
            this.scrollTo(0, willTo);
            return deltaOriginY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        if (this.mIsTouchEventMode || this.mOverScrollTopMiddle == 0 || this.mFreshStatus == ISwipe.FreshStatus.SUCCESS || this.mFreshStatus == ISwipe.FreshStatus.ERROR || this.mFreshStatus == ISwipe.FreshStatus.ERROR_NET) {
            return false;
        }
        int scrollY = this.getScrollY();
        if (scrollY <= -this.mOverScrollTopMiddle) {
            this.stopAllScroll();
            this.animationScrollY = ValueAnimator.ofInt((int[])new int[]{scrollY, -this.mOverScrollTopMiddle});
            this.animationScrollY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeRefresh.this.getScrollY()) {
                        SwipeRefresh.this.scrollTo(0, value);
                    }
                }
            });
            this.animationScrollY.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        if (SwipeRefresh.this.mFreshStatus == null) {
                            SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, SwipeRefresh.this.mViewTop.getHeight(), SwipeRefresh.this.mViewTop.getHeight());
                        }
                        if (!SwipeRefresh.this.mRefreshStatusContinueRunning) {
                            SwipeRefresh.this.mRefreshStatusContinueRunning = true;
                            if (SwipeRefresh.this.mEmptyController != null) {
                                SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                            }
                            if (SwipeRefresh.this.mOnRefreshListener != null) {
                                SwipeRefresh.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationScrollY.setDuration((long)(50 + Math.abs(500 * (-this.mOverScrollTopMiddle - scrollY) / this.mViewTop.getHeight())));
            this.animationScrollY.start();
            return true;
        }
        return false;
    }

    private boolean tryBackToFreshFinish() {
        int scrollY = this.getScrollY();
        if (this.mIsTouchEventMode || this.mFreshStatus == null && this.mRefreshStatusContinueRunning && scrollY == -this.mOverScrollTopMiddle) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationScrollY = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationScrollY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeRefresh.this.scrollTo(0, value);
                }
            });
            this.animationScrollY.addListener(new Animator.AnimatorListener(){
                boolean isCancel;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, 0, SwipeRefresh.this.mViewTop.getHeight());
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (scrollY == -this.mOverScrollTopMiddle) {
                this.animationScrollY.setDuration((long)Math.abs(550 * (0 - scrollY) / this.mViewTop.getHeight()));
                this.animationScrollY.setStartDelay(650L);
            } else {
                this.animationScrollY.setDuration(320L);
            }
            this.animationScrollY.start();
            return true;
        }
        return false;
    }

    private boolean tryBackToLoading() {
        int scrollY = this.getScrollY();
        if (this.mIsTouchEventMode || this.mOverScrollBottomMiddle == 0 || scrollY < this.mContentScroll + this.mOverScrollBottomMiddle || this.mOverScrollBottomMiddle == this.mOverScrollBottom) {
            return false;
        }
        this.stopAllScroll();
        this.animationScrollY = ValueAnimator.ofInt((int[])new int[]{scrollY, this.mContentScroll + this.mOverScrollBottomMiddle});
        this.animationScrollY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                SwipeRefresh.this.scrollTo(0, value);
            }
        });
        this.animationScrollY.setDuration((long)(50 + (int)((float)(scrollY - this.mContentScroll - this.mOverScrollBottomMiddle) * 250.0f / (float)(this.mOverScrollBottom - this.mOverScrollBottomMiddle))));
        this.animationScrollY.start();
        return true;
    }

    private void stopAllScroll() {
        if (this.animationScrollY != null) {
            this.animationScrollY.cancel();
        }
        this.mScroller.abortAnimation();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthTarget = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightTarget = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidMeasure = View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000);
        int spHei = View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || this.mViewTop == child || this.mViewBottom == child) continue;
            child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0x40000000));
        }
        if (this.mViewTop != null) {
            this.mViewTop.measure(childWidMeasure, spHei);
        }
        if (this.mViewBottom != null) {
            this.mViewBottom.measure(childWidMeasure, spHei);
        }
        this.setMeasuredDimension(widthTarget, heightTarget);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mContentScroll = 0;
        this.mOverScrollTop = this.mViewTop.getMeasuredHeight();
        this.mOverScrollTopMiddle = this.mOverScrollTop != 0 ? this.mOverScrollTop - this.mSwipeController.getOverScrollHei() : 0;
        this.mOverScrollTopMiddle = this.mOverScrollTopMiddle > 0 ? this.mOverScrollTopMiddle : 0;
        this.mOverScrollBottomMiddle = this.mViewBottom.getMeasuredHeight();
        this.mOverScrollBottom = this.mLoadMoreOverScroll ? this.mOverScrollBottomMiddle + (int)((float)(bottom - top) * 0.2f) : this.mOverScrollBottomMiddle;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
            if (this.mShowEmptyView) {
                child.layout(right - left, 0, 2 * (right - left), bottom - top);
                continue;
            }
            child.layout(0, 0, right - left, bottom - top);
        }
        this.mViewTop.layout(left, -this.mViewTop.getMeasuredHeight(), right, 0);
        this.mViewBottom.layout(0, bottom - top, right - left, bottom - top + this.mOverScrollBottomMiddle);
        if (this.mEmptyView != null) {
            if (this.mShowEmptyView) {
                this.mEmptyView.layout(0, 0, right - left, bottom - top);
            } else {
                this.mEmptyView.layout(right - left, 0, 2 * (right - left), bottom - top);
            }
        }
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.mOverScrollTop = 0;
            this.mOverScrollTopMiddle = 0;
        }
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.mOverScrollBottomMiddle = 0;
            this.mOverScrollBottom = 0;
        }
    }

    private View findScrollView(View view, int centerX, int centerY, int direction) {
        if (view.getVisibility() == 4 || view.getVisibility() == 8) {
            return null;
        }
        if (view == this.mViewTop || view == this.mViewBottom || view == this.mEmptyView) {
            return null;
        }
        int[] tem = new int[2];
        view.getLocationInWindow(tem);
        if (tem[0] < centerX && centerX < tem[0] + view.getWidth() && tem[1] < centerY && centerY < tem[1] + view.getHeight()) {
            if (direction == 0) {
                if (view.canScrollVertically(-1) || view.canScrollVertically(1)) {
                    return view;
                }
                if (view instanceof ViewGroup) {
                    ViewGroup group = (ViewGroup)view;
                    for (int i = 0; i < group.getChildCount(); ++i) {
                        View child = this.findScrollView(group.getChildAt(i), centerX, centerY, direction);
                        if (child == null) continue;
                        return child;
                    }
                }
                return null;
            }
            if (view.canScrollVertically(direction)) {
                return view;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    View child = this.findScrollView(group.getChildAt(i), centerX, centerY, direction);
                    if (child == null) continue;
                    return child;
                }
            }
            return null;
        }
        return null;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (ev.getAction() == 0) {
            this.mDraggedIntercept = false;
            this.mPreScroll = false;
            this.mDraggedDispatch = false;
            this.mActivePointerId = ev.getPointerId(0);
            this.mDragBeginY = (int)ev.getY();
            this.mDragBeginDirect = 0.0f;
            this.mIsTouchEventMode = true;
            this.mDragLastY = this.mDragBeginY;
            this.mTargetView = this.findScrollView((View)this, (int)ev.getX(), (int)ev.getY(), 0);
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (action == 0 && this.getScrollY() != 0) {
            this.mPreScroll = true;
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            } else {
                this.mVelocityTracker.clear();
            }
            this.mVelocityTracker.addMovement(ev);
        }
        if (this.mPreScroll) {
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 5: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 2: {
                    float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    float yDiff = this.mDragBeginY - y;
                    if (!this.mDraggedDispatch && Math.abs(yDiff) > (float)(this.mTouchSlop / 2)) {
                        this.mDraggedDispatch = true;
                        this.mDragLastY = y;
                    }
                    if (!this.mDraggedDispatch) break;
                    this.offSetScroll((int)(this.mDragLastY - y), true);
                    if (this.getScrollY() == 0) {
                        this.mPreScroll = false;
                    }
                    this.mDragLastY = y;
                    this.mVelocityTracker.addMovement(ev);
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                    break;
                }
                case 1: 
                case 3: {
                    ev.setAction(3);
                    if (this.mVelocityTracker == null) break;
                    this.mVelocityTracker.addMovement(ev);
                    this.mVelocityTracker.computeCurrentVelocity(1000, 20000.0f);
                    this.mVelocityTracker.getYVelocity();
                    int initialVelocity = (int)this.mVelocityTracker.getYVelocity();
                    this.fling(-initialVelocity);
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.tryBackToLoading() || this.mDraggedDispatch || this.mDraggedIntercept)) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mNestedScrollInProgress || !this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp()) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                float yDiff = this.mDragBeginY - y;
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mDraggedIntercept || !(yDiff > 0.0f && !this.canChildScrollUp()) && (!(yDiff < 0.0f) || this.canChildScrollDown())) break;
                this.mDraggedIntercept = true;
                this.mDragLastY = y;
                this.mDragBeginDirect = -yDiff;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mDraggedIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                this.mDragLastY = (int)ev.getY();
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                int deltaY = (int)this.mDragBeginY - (int)y;
                if (!this.mDraggedIntercept && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mDraggedIntercept = true;
                    this.mDragBeginDirect = -deltaY;
                }
                if (!this.mDraggedIntercept) break;
                this.offSetScroll((int)(this.mDragLastY - y), false);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mDragLastY = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        }
        return true;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() + (this.mEmptyView != null ? -1 : 0) > 3) {
            throw new RuntimeException("only one View is support");
        }
        super.addView(child, index, params);
    }

    public void computeScroll() {
        int scrollY = this.getScrollY();
        if (this.mScroller.computeScrollOffset() && !this.mScroller.isFinished()) {
            int y = this.mScroller.getCurrY();
            if (y < 0 || y > this.mContentScroll + this.mOverScrollBottomMiddle) {
                y = y < 0 ? 0 : y;
                int n = y = y > this.mContentScroll + this.mOverScrollBottomMiddle ? this.mContentScroll + this.mOverScrollBottomMiddle : y;
                if (scrollY != y) {
                    this.scrollTo(0, y);
                }
                int remainVelocity = (int)((float)this.mMaxFlingDirection * this.mScroller.getCurrVelocity());
                if (this.mTargetView != null) {
                    if (this.mTargetView instanceof RecyclerView) {
                        RecyclerView recyclerView = (RecyclerView)this.mTargetView;
                        recyclerView.fling(0, remainVelocity);
                    } else if (this.mTargetView instanceof ListView) {
                        if (Build.VERSION.SDK_INT >= 21) {
                            ListView listView = (ListView)this.mTargetView;
                            listView.fling(remainVelocity);
                        }
                    } else if (this.mTargetView instanceof ScrollView) {
                        ScrollView scrollView = (ScrollView)this.mTargetView;
                        scrollView.fling(remainVelocity);
                    } else if (this.mTargetView instanceof NestedScrollView) {
                        NestedScrollView nestedScrollView = (NestedScrollView)this.mTargetView;
                        nestedScrollView.fling(remainVelocity);
                    }
                }
                this.mScroller.abortAnimation();
            } else if (y == scrollY) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            } else {
                this.scrollTo(0, y);
            }
        }
        if (scrollY != this.preScroll) {
            this.preScroll = scrollY;
            if (!(0 != scrollY || this.mFreshStatus != ISwipe.FreshStatus.ERROR && this.mFreshStatus != ISwipe.FreshStatus.ERROR_NET && this.mFreshStatus != ISwipe.FreshStatus.SUCCESS || this.mRefreshStatusContinueRunning)) {
                this.mFreshStatus = null;
            }
            if (0 > scrollY) {
                int swipeViewVisibilityHei = 0 - scrollY;
                if (this.mFreshStatus == null) {
                    if (this.mRefreshStatusContinueRunning) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mOverScrollTop);
                    } else if (scrollY < -this.mOverScrollTopMiddle) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mOverScrollTop);
                    } else {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mOverScrollTop);
                    }
                } else {
                    switch (this.mFreshStatus) {
                        case SUCCESS: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mOverScrollTop);
                            break;
                        }
                        case ERROR: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, swipeViewVisibilityHei, this.mOverScrollTop);
                            break;
                        }
                        case ERROR_NET: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, swipeViewVisibilityHei, this.mOverScrollTop);
                        }
                    }
                }
            }
            if (scrollY > this.mContentScroll && !this.mLoadedStatusContinueRunning) {
                this.mLoadedStatusContinueRunning = true;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onLoading();
                }
            }
            if (scrollY > this.mContentScroll) {
                if (this.mLoadedStatus == ISwipe.LoadedStatus.NO_MORE) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, scrollY - this.mContentScroll, this.mOverScrollBottomMiddle);
                } else if (this.mLoadedStatus == ISwipe.LoadedStatus.ERROR) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, scrollY - this.mContentScroll, this.mOverScrollBottomMiddle);
                } else if (this.mLoadedStatus == null) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, scrollY - this.mContentScroll, this.mOverScrollBottomMiddle);
                }
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mDragLastY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private boolean canChildScrollDown() {
        return !this.mShowEmptyView && this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    private boolean canChildScrollUp() {
        return !this.mShowEmptyView && this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (this.mShowEmptyView || this.mTargetView == null || this.mTargetView instanceof NestedScrollingChild) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    @Override
    public void setOnRefreshListener(ISwipe.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    @Override
    public void refresh() {
        this.mFreshStatus = null;
        if (this.mEmptyController != null) {
            this.mEmptyController.onSwipeStatue(null);
        }
        this.mRefreshStatusContinueRunning = true;
        this.mLoadedStatus = null;
        this.mLoadedStatusContinueRunning = false;
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, -this.getScrollY(), this.mViewTop.getHeight());
        this.tryBackToRefreshing();
    }

    @Override
    public void setFreshResult(ISwipe.FreshStatus statue) {
        switch (statue) {
            case SUCCESS: {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.SUCCESS;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR_NET: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR_NET;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
            }
        }
    }

    @Override
    public void completeLoadMore() {
        int currentScrollY = this.getScrollY() - this.mContentScroll;
        if (currentScrollY > 0) {
            if ((this.mTargetView instanceof RecyclerView || this.mTargetView instanceof ListView || this.mTargetView instanceof ScrollView || this.mTargetView instanceof NestedScrollView) && this.canChildScrollUp()) {
                this.mTargetView.scrollBy(0, currentScrollY);
            }
            this.stopAllScroll();
            this.scrollTo(0, this.mContentScroll);
        }
        this.mLoadedStatusContinueRunning = false;
        this.mLoadedStatus = null;
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
    }

    @Override
    public void setLoadMoreResult(ISwipe.LoadedStatus status) {
        switch (status) {
            case ERROR: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.ERROR;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case NO_MORE: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.NO_MORE;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
            }
        }
    }

    @Override
    public void setSwipeModel(SwipeController.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    @Override
    public void setSwipeController(SwipeController controller) {
        if (controller != null && this.mSwipeController != controller) {
            this.removeView(this.mViewTop);
            this.removeView(this.mViewBottom);
            this.mSwipeController = controller;
            this.mViewTop = this.mSwipeController.getSwipeHead();
            this.mViewBottom = this.mSwipeController.getSwipeFoot();
            this.addView(this.mViewTop);
            this.addView(this.mViewBottom);
            this.requestLayout();
        }
    }

    @Override
    public void setEmptyController(EmptyController controller) {
        if (controller != null && this.mEmptyController != controller) {
            this.mEmptyController = controller;
            if (this.mEmptyView != null) {
                this.removeView(this.mEmptyView);
            }
            this.mEmptyView = controller.getView();
            this.addView(this.mEmptyView);
            this.requestLayout();
        }
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mShowEmptyView != show) {
            this.mShowEmptyView = show;
            this.requestLayout();
        }
    }

    @Override
    public void enableLoadMoreOverScroll(boolean enable) {
        if (this.mLoadMoreOverScroll != enable) {
            this.mLoadMoreOverScroll = enable;
            this.requestLayout();
        }
    }
}

