/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import android.widget.ScrollView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.EmptyController;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeController;
import com.powyin.scroll.widget.SwipeControllerStyleNormal;

public class SwipeRefresh
extends ViewGroup
implements NestedScrollingParent,
ISwipe {
    private int mTouchSlop;
    private final NestedScrollingParentHelper mParentHelper;
    private boolean mNestedScrollInProgress = false;
    private int mActivePointerId = -1;
    private float mDragBeginY;
    private float mDragBeginDirect;
    private float mDragLastY;
    private boolean mIsTouchEventMode = false;
    private boolean mPreScroll;
    private boolean mDraggedDispatch;
    private boolean mDraggedIntercept;
    private SwipeController mSwipeController;
    private EmptyController mEmptyController;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private boolean mRefreshStatusContinueRunning = false;
    private ISwipe.FreshStatus mFreshStatus = null;
    private boolean mLoadedStatusContinueRunning = false;
    private ISwipe.LoadedStatus mLoadedStatus = null;
    private SwipeController.SwipeModel mModel = SwipeController.SwipeModel.SWIPE_BOTH;
    private ISwipe.OnRefreshListener mOnRefreshListener;
    private View mViewTop;
    private View mViewBottom;
    private View mEmptyView;
    private View mTargetView;
    private View mTargetViewContain;
    private boolean mShowEmptyView;
    private int contentScroll;
    private int overScrollTop;
    private int overScrollBottom;

    public SwipeRefresh(Context context) {
        this(context, null);
    }

    public SwipeRefresh(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRefresh(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeRefresh);
            int modelIndex = a.getInt(R.styleable.SwipeRefresh_fresh_model, -1);
            if (modelIndex >= 0 && modelIndex < SwipeController.SwipeModel.values().length) {
                this.mModel = SwipeController.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.initSwipeControl();
    }

    private void initSwipeControl() {
        this.mSwipeController = new SwipeControllerStyleNormal(this.getContext());
        this.mViewTop = this.mSwipeController.getSwipeHead();
        this.mViewBottom = this.mSwipeController.getSwipeFoot();
        this.addView(this.mViewTop, 0);
        this.addView(this.mViewBottom, this.getChildCount());
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        ScrollingView scrollingView;
        int range;
        if (!this.mLoadedStatusContinueRunning && this.mOnRefreshListener != null && target instanceof ScrollingView && (range = (scrollingView = (ScrollingView)target).computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent()) < 6 * this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        this.mTargetView = target;
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetScroll(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetScroll(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (velocityY < 0.0f || this.mLoadedStatusContinueRunning || this.mOnRefreshListener == null || !(target instanceof ScrollingView)) {
            return false;
        }
        float radio = velocityY / (float)this.getHeight();
        radio = radio > 1.0f ? radio : 1.0f;
        radio = radio < 10.0f ? radio : 10.0f;
        ScrollingView scrollingView = (ScrollingView)target;
        int range = scrollingView.computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent();
        if ((float)range < radio * (float)this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.getScrollY() != 0;
    }

    private int offSetScroll(int deltaOriginY, boolean pre) {
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int middleHei = -this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        int currentScrollY = this.getScrollY();
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeController.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeController.getOverScrollHei(), 2.0));
        }
        if (currentScrollY != 0 && currentScrollY != this.contentScroll || !pre) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, this.overScrollBottom);
            willTo = Math.max(willTo, -this.overScrollTop);
            if (currentScrollY > 0 && willTo < 0 || currentScrollY < 0 && willTo > 0) {
                willTo = 0;
            }
            if (currentScrollY > this.contentScroll && willTo < this.contentScroll || currentScrollY < this.contentScroll && willTo > this.contentScroll) {
                willTo = this.contentScroll;
            }
            if (this.mDragBeginDirect > 0.0f && willTo > this.contentScroll) {
                willTo = this.contentScroll;
            }
            if (this.mDragBeginDirect < 0.0f && willTo < 0) {
                willTo = 0;
            }
            if (willTo > 0 && !this.canChildScrollDown()) {
                willTo = 0;
            }
            if (willTo == currentScrollY) {
                return deltaOriginY;
            }
            this.scrollTo(0, willTo);
            if (!(0 <= willTo || willTo <= middleHei || this.mFreshStatus != ISwipe.FreshStatus.ERROR && this.mFreshStatus != ISwipe.FreshStatus.ERROR_NET && this.mFreshStatus != ISwipe.FreshStatus.SUCCESS || this.mRefreshStatusContinueRunning)) {
                this.mFreshStatus = null;
            }
            if (0 > willTo) {
                int swipeViewVisibilityHei = 0 - willTo;
                if (this.mFreshStatus == null) {
                    if (this.mRefreshStatusContinueRunning) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    } else if (willTo < middleHei) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    } else {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    }
                } else {
                    switch (this.mFreshStatus) {
                        case SUCCESS: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mViewTop.getHeight());
                            break;
                        }
                        case ERROR: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, swipeViewVisibilityHei, this.mViewTop.getHeight());
                            break;
                        }
                        case ERROR_NET: {
                            this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        }
                    }
                }
            }
            if (willTo > this.contentScroll && !this.mLoadedStatusContinueRunning) {
                this.mLoadedStatusContinueRunning = true;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onLoading();
                }
            }
            if (willTo > this.contentScroll) {
                if (this.mLoadedStatus == ISwipe.LoadedStatus.NO_MORE) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, willTo - this.contentScroll, this.mViewBottom.getHeight());
                } else if (this.mLoadedStatus == ISwipe.LoadedStatus.ERROR) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, willTo - this.contentScroll, this.mViewBottom.getHeight());
                } else if (this.mLoadedStatus == null) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, willTo - this.contentScroll, this.mViewBottom.getHeight());
                }
            }
            return deltaOriginY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mFreshStatus == ISwipe.FreshStatus.SUCCESS || this.mFreshStatus == ISwipe.FreshStatus.ERROR || this.mFreshStatus == ISwipe.FreshStatus.ERROR_NET) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.stopAllScroll();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeRefresh.this.getScrollY()) {
                        SwipeRefresh.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        if (SwipeRefresh.this.mFreshStatus == null) {
                            SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, SwipeRefresh.this.mViewTop.getHeight(), SwipeRefresh.this.mViewTop.getHeight());
                        }
                        if (!SwipeRefresh.this.mRefreshStatusContinueRunning) {
                            SwipeRefresh.this.mRefreshStatusContinueRunning = true;
                            if (SwipeRefresh.this.mEmptyController != null) {
                                SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                            }
                            if (SwipeRefresh.this.mOnRefreshListener != null) {
                                SwipeRefresh.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(550 * (middleHei - scrollY) / this.mViewTop.getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        if (this.mFreshStatus == null && this.mRefreshStatusContinueRunning && scrollY == middleHei) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeRefresh.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.addListener(new Animator.AnimatorListener(){
                boolean isCancel;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, 0, SwipeRefresh.this.mViewTop.getHeight());
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(550 * (0 - scrollY) / this.mViewTop.getHeight()));
                this.animationReBackToTop.setStartDelay(650L);
            } else {
                this.animationReBackToTop.setDuration(320L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthTarget = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightTarget = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidMeasure = View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000);
        int spHei = View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || this.mViewTop == child || this.mViewBottom == child) continue;
            child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0x40000000));
        }
        if (this.mViewTop != null) {
            this.mViewTop.measure(childWidMeasure, spHei);
        }
        if (this.mViewBottom != null) {
            this.mViewBottom.measure(childWidMeasure, spHei);
        }
        this.setMeasuredDimension(widthTarget, heightTarget);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.contentScroll = 0;
        this.overScrollTop = this.mViewTop.getMeasuredHeight();
        this.overScrollBottom = this.mViewBottom.getMeasuredHeight();
        this.mTargetViewContain = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
            if (this.mShowEmptyView) {
                child.layout(right - left, 0, 2 * (right - left), bottom - top);
                continue;
            }
            child.layout(0, 0, right - left, bottom - top);
            this.mTargetViewContain = child;
        }
        this.mViewTop.layout(left, -this.mViewTop.getMeasuredHeight(), right, 0);
        this.mViewBottom.layout(0, bottom - top, right - left, bottom - top + this.overScrollBottom);
        if (this.mEmptyView != null) {
            if (this.mShowEmptyView) {
                this.mEmptyView.layout(0, 0, right - left, bottom - top);
            } else {
                this.mEmptyView.layout(right - left, 0, 2 * (right - left), bottom - top);
            }
        }
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.overScrollTop = 0;
        }
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.overScrollBottom = 0;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mDraggedIntercept = false;
            this.mPreScroll = false;
            this.mDraggedDispatch = false;
            this.mActivePointerId = ev.getPointerId(0);
            this.mDragBeginY = (int)ev.getY();
            this.mDragBeginDirect = 0.0f;
            this.mIsTouchEventMode = true;
            this.mDragLastY = this.mDragBeginY;
            this.mTargetView = this.mTargetViewContain;
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (ev.getAction() == 0 && this.getScrollY() != 0) {
            this.mPreScroll = true;
        }
        if (this.mPreScroll) {
            int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 5: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 2: {
                    float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    float yDiff = this.mDragBeginY - y;
                    if (Math.abs(yDiff) > (float)(this.mTouchSlop / 2) && !this.mDraggedDispatch) {
                        this.mDraggedDispatch = true;
                        this.mDragLastY = y;
                    }
                    if (!this.mDraggedDispatch) break;
                    this.offSetScroll((int)(this.mDragLastY - y), true);
                    if (this.getScrollY() == 0) {
                        this.mPreScroll = false;
                    }
                    this.mDragLastY = y;
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.mDraggedDispatch || this.mDraggedIntercept)) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mNestedScrollInProgress || !this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp()) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                float yDiff = this.mDragBeginY - y;
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mDraggedIntercept || !(yDiff > 0.0f && !this.canChildScrollUp()) && (!(yDiff < 0.0f) || this.canChildScrollDown())) break;
                this.mDraggedIntercept = true;
                this.mDragLastY = y;
                this.mDragBeginDirect = -yDiff;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mDraggedIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                this.mDragLastY = (int)ev.getY();
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                int deltaY = (int)this.mDragBeginY - (int)y;
                if (!this.mDraggedIntercept && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mDraggedIntercept = true;
                    this.mDragBeginDirect = -deltaY;
                }
                if (!this.mDraggedIntercept) break;
                this.offSetScroll((int)(this.mDragLastY - y), false);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mDragLastY = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        }
        return true;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() + (this.mEmptyView != null ? -1 : 0) > 3) {
            throw new RuntimeException("only one View is support");
        }
        super.addView(child, index, params);
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mDragLastY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private boolean canChildScrollDown() {
        return !this.mShowEmptyView && this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    private boolean canChildScrollUp() {
        return !this.mShowEmptyView && this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (this.mShowEmptyView || this.mTargetView == null || this.mTargetView instanceof NestedScrollingChild) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    @Override
    public void setOnRefreshListener(ISwipe.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    @Override
    public void refresh() {
        this.mFreshStatus = null;
        if (this.mEmptyController != null) {
            this.mEmptyController.onSwipeStatue(this.mFreshStatus);
        }
        this.mRefreshStatusContinueRunning = true;
        this.mLoadedStatus = null;
        this.mLoadedStatusContinueRunning = false;
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, -this.getScrollY(), this.mViewTop.getHeight());
        this.tryBackToRefreshing();
    }

    @Override
    public void setFreshResult(ISwipe.FreshStatus statue) {
        switch (statue) {
            case SUCCESS: {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.SUCCESS;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR_NET: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR_NET;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeRefresh.this.mFreshStatus = ISwipe.FreshStatus.ERROR;
                        if (SwipeRefresh.this.mEmptyController != null) {
                            SwipeRefresh.this.mEmptyController.onSwipeStatue(SwipeRefresh.this.mFreshStatus);
                        }
                        SwipeRefresh.this.mRefreshStatusContinueRunning = false;
                        SwipeRefresh.this.mLoadedStatus = null;
                        SwipeRefresh.this.mLoadedStatusContinueRunning = false;
                        SwipeRefresh.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, -SwipeRefresh.this.getScrollY(), SwipeRefresh.this.mViewTop.getHeight());
                        SwipeRefresh.this.tryBackToFreshFinish();
                    }
                }, 1000L);
            }
        }
    }

    @Override
    public void clearLoadMore() {
        int currentScrollY = this.getScrollY() - this.contentScroll;
        if (currentScrollY > 0) {
            if ((this.mTargetView instanceof RecyclerView || this.mTargetView instanceof ListView || this.mTargetView instanceof ScrollView || this.mTargetView instanceof NestedScrollView) && this.canChildScrollUp()) {
                this.mTargetView.scrollBy(0, currentScrollY);
            }
            this.stopAllScroll();
            this.scrollTo(0, this.contentScroll);
        }
        this.mLoadedStatusContinueRunning = false;
        this.mLoadedStatus = null;
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
    }

    @Override
    public void setLoadMoreResult(ISwipe.LoadedStatus status) {
        switch (status) {
            case ERROR: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.ERROR;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case NO_MORE: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.NO_MORE;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
            }
        }
    }

    @Override
    public void setSwipeModel(SwipeController.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    @Override
    public void setSwipeController(SwipeController controller) {
        if (controller != null && this.mSwipeController != controller) {
            this.removeView(this.mViewTop);
            this.removeView(this.mViewBottom);
            this.mSwipeController = controller;
            this.mViewTop = this.mSwipeController.getSwipeHead();
            this.mViewBottom = this.mSwipeController.getSwipeFoot();
            this.addView(this.mViewTop);
            this.addView(this.mViewBottom);
            this.requestLayout();
        }
    }

    @Override
    public void setEmptyController(EmptyController controller) {
        if (controller != null && this.mEmptyController != controller) {
            this.mEmptyController = controller;
            if (this.mEmptyView != null) {
                this.removeView(this.mEmptyView);
            }
            this.mEmptyView = controller.getView();
            this.addView(this.mEmptyView);
            this.requestLayout();
        }
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mShowEmptyView != show) {
            this.mShowEmptyView = show;
            this.requestLayout();
        }
    }
}

