/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.powyin.scroll.widget.SwipeControl;
import com.powyin.scroll.widget.SwipeControlStyleNormal;

public class SwipeNest
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private View mTarget;
    private final NestedScrollingParentHelper mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final NestedScrollingChildHelper mChildHelper = new NestedScrollingChildHelper((View)this);
    private boolean isFly = false;
    private SwipeControl mSwipeControl;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private ScrollerCompat mScroller;
    private boolean mIsTouchEventMode = false;
    private boolean mIsFreshContinue = false;
    private boolean mIsFreshComplete = false;
    private int scrollY_Up;
    private int scrollY_Down;
    private OnRefreshListener mOnRefreshListener;

    public SwipeNest(Context context) {
        this(context, null);
    }

    public SwipeNest(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeNest(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setNestedScrollingEnabled(true);
        this.mScroller = ScrollerCompat.create((Context)this.getContext(), (Interpolator)new Interpolator(){

            public float getInterpolation(float input) {
                return input;
            }
        });
        this.initSwipeControl();
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (child == this.mSwipeControl.getSwipeHead() || child == this.mSwipeControl.getSwipeFoot()) continue;
                this.mTarget = child;
                break;
            }
        }
    }

    private void initSwipeControl() {
        this.mSwipeControl = new SwipeControlStyleNormal(this.getContext());
        this.addView(this.mSwipeControl.getSwipeHead(), 0);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mIsTouchEventMode = true;
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
        this.stopAllScroll();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.stopNestedScroll();
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int myConsumed = this.offSetChildrenLocation(dyUnconsumed, false);
        this.dispatchNestedScroll(0, myConsumed, 0, dyUnconsumed -= myConsumed, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetChildrenLocation(dy, true);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return true;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (this.getScrollY() < this.scrollY_Down) {
            if (!this.tryBackToRefreshing() && !this.tryBackToFreshFinish()) {
                this.fling((int)velocityY);
                this.isFly = true;
                return true;
            }
            this.isFly = false;
            return true;
        }
        this.isFly = false;
        return false;
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = SwipeNest.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = SwipeNest.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.ensureTarget();
        int childTop = 0;
        int count = this.getChildCount();
        View swipeView = this.mSwipeControl.getSwipeHead();
        for (int i = 0; i <= count - 1; ++i) {
            View child = this.getChildAt(i);
            if (child == swipeView || child == this.mTarget) continue;
            int childHeight = child.getMeasuredHeight();
            child.layout(0, childTop, right - left, childTop + childHeight);
            childTop += childHeight;
        }
        swipeView.layout(0, -this.mSwipeControl.getSwipeHead().getMeasuredHeight(), right - left, 0);
        this.scrollY_Up = -this.mSwipeControl.getSwipeHead().getMeasuredHeight();
        if (this.mTarget != null) {
            this.mTarget.layout(0, childTop, right - left, childTop + bottom - top);
            childTop += bottom - top;
        }
        this.scrollY_Down = childTop - (bottom - top);
    }

    public void computeScroll() {
        super.computeScroll();
        this.ensureTarget();
        if (this.isFly && this.mScroller.isOverScrolled() && this.mScroller.getFinalY() == this.scrollY_Down) {
            if (this.mTarget instanceof RecyclerView) {
                RecyclerView recyclerView = (RecyclerView)this.mTarget;
                recyclerView.fling(0, (int)(this.mScroller.getCurrVelocity() * 0.7f));
            }
            if (this.mTarget instanceof NestedScrollView) {
                NestedScrollView nestedScrollView = (NestedScrollView)this.mTarget;
                nestedScrollView.fling((int)(this.mScroller.getCurrVelocity() * 0.7f));
            }
        }
        if (this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            this.scrollTo(0, y);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private int offSetChildrenLocation(int deltaOriginY, boolean pre) {
        this.ensureTarget();
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        int currentScrollY = this.getScrollY();
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeControl.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.0));
        }
        if (currentScrollY != this.scrollY_Down || !pre) {
            int swipeViewVisibilityHei;
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, this.scrollY_Down);
            if ((willTo = Math.max(willTo, this.scrollY_Up)) == currentScrollY) {
                return deltaOriginY;
            }
            this.scrollTo(0, willTo);
            if (willTo < 0 && willTo > middleHei && this.mIsFreshComplete && !this.mIsFreshContinue) {
                this.mIsFreshComplete = false;
            }
            if ((swipeViewVisibilityHei = 0 - willTo) > 0) {
                if (this.mIsFreshContinue) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (this.mIsFreshComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (willTo < middleHei) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                }
            }
            return deltaOriginY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mIsFreshComplete) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.stopAllScroll();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeNest.this.getScrollY()) {
                        SwipeNest.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeNest.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, SwipeNest.this.mSwipeControl.getSwipeHead().getHeight(), SwipeNest.this.mSwipeControl.getSwipeHead().getHeight());
                        if (!SwipeNest.this.mIsFreshContinue) {
                            SwipeNest.this.mIsFreshContinue = true;
                            if (SwipeNest.this.mOnRefreshListener != null) {
                                SwipeNest.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(650 * (middleHei - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        if (!this.mIsFreshComplete && scrollY == middleHei) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeNest.this.scrollTo(0, value);
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(900 * (0 - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
                this.animationReBackToTop.setStartDelay(650L);
            } else {
                this.animationReBackToTop.setDuration(460L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void fling(int velocityY) {
        this.stopAllScroll();
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.getScrollY(), 0, (int)((float)velocityY * 0.75f), 0, 0, 0, this.scrollY_Down);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
        if (this.mScroller != null) {
            this.mScroller.abortAnimation();
        }
        this.isFly = false;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public void finishRefresh() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                SwipeNest.this.mIsFreshContinue = false;
                SwipeNest.this.mIsFreshComplete = true;
                SwipeNest.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeNest.this.getScrollY(), SwipeNest.this.mSwipeControl.getSwipeHead().getHeight());
                SwipeNest.this.tryBackToFreshFinish();
            }
        }, 600L);
    }

    public void setSwipeControl(SwipeControl control) {
        if (control != null && this.mSwipeControl != control) {
            this.removeView(this.mSwipeControl.getSwipeHead());
            this.mSwipeControl = control;
            this.addView(this.mSwipeControl.getSwipeHead());
            this.requestLayout();
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

