/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.powyin.scroll.adapter.ViewHolder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiAdapter<T>
implements ListAdapter {
    private ViewHolder[] holderInstances;
    private Class<? extends ViewHolder>[] holderClasses;
    private Class[] holderGenericDataClass;
    private Activity mActivity;
    private List<T> mDataList = new ArrayList<T>();
    private Map<T, ViewHolder> mDataToViewHolder = new HashMap<T, ViewHolder>();
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    @SafeVarargs
    public static <T, N extends T> MultiAdapter<N> getByClass(Activity activity, Class<? extends ViewHolder<? extends T>> ... cla) {
        Class[] arrClass = new Class[cla.length + 1];
        System.arraycopy(cla, 0, arrClass, 0, cla.length);
        arrClass[arrClass.length - 1] = ErrorViewHolder.class;
        return new MultiAdapter<T>(activity, arrClass);
    }

    public MultiAdapter(Activity activity, Class<? extends ViewHolder>[] cla) {
        this.mActivity = activity;
        this.holderClasses = cla;
        this.holderInstances = new ViewHolder[cla.length];
        this.holderGenericDataClass = new Class[cla.length];
        for (int i = 0; i < cla.length; ++i) {
            Type genericType = null;
            Class<? extends ViewHolder> typeClass = this.holderClasses[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != ViewHolder.class && typeClass != Object.class);
            if (typeClass != ViewHolder.class || genericType == ViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            this.holderGenericDataClass[i] = (Class)genericClass;
            try {
                this.holderInstances[i] = this.holderClasses[i].getConstructor(Activity.class).newInstance(this.mActivity);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5");
            }
        }
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        if (position == this.mDataList.size()) {
            return true;
        }
        if (position == this.mDataList.size() + 1) {
            return true;
        }
        int index = this.getItemViewType(position);
        return this.holderInstances[index].isEnabled(this.mDataList.get(position));
    }

    public int getCount() {
        return this.mDataList.size();
    }

    public Object getItem(int position) {
        return this.mDataList.get(position);
    }

    public long getItemId(int position) {
        return this.mDataList.get(position).hashCode();
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            int index = this.getItemViewType(position);
            try {
                holder = this.holderClasses[index].getConstructor(Activity.class).newInstance(this.mActivity);
                convertView = holder.mainView;
                convertView.setTag((Object)holder);
            }
            catch (Exception e) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5");
            }
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        T itemData = this.mDataList.get(position);
        holder.mData = itemData;
        holder.loadData(this, itemData);
        if (itemData != null) {
            this.mDataToViewHolder.remove(itemData);
            this.mDataToViewHolder.put(itemData, holder);
        }
        return holder.mainView;
    }

    public int getItemViewType(int position) {
        if (position == this.mDataList.size()) {
            return this.holderInstances.length;
        }
        for (int i = 0; i < this.holderInstances.length - 1; ++i) {
            T itemData = this.mDataList.get(position);
            if (itemData == null || !this.holderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.holderInstances[i].acceptData(itemData)) continue;
            return i;
        }
        return this.holderInstances.length - 1;
    }

    public int getViewTypeCount() {
        return this.holderClasses.length + 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public void notifyDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    public void deleteFirst() {
        this.mDataList.remove(0);
        this.notifyDataSetChanged();
    }

    public void deleteLast() {
        this.mDataList.remove(this.mDataList.size() - 1);
        this.notifyDataSetChanged();
    }

    public void addFirst(T data) {
        this.mDataList.add(0, data);
        this.notifyDataSetChanged();
    }

    public void addFirst(List<T> datas) {
        this.mDataList.addAll(0, datas);
        this.notifyDataSetChanged();
    }

    public void addLast(T data) {
        this.mDataList.add(this.mDataList.size(), data);
        this.notifyDataSetChanged();
    }

    public void addLast(List<T> dataList) {
        this.mDataList.addAll(this.mDataList.size(), dataList);
        this.notifyDataSetChanged();
    }

    public void notifyDataChange(T data) {
        ViewHolder holder = this.mDataToViewHolder.get(data);
        if (holder != null && holder.mData == data) {
            holder.loadData(this, data);
        }
    }

    public void deleteData(T data) {
        if (this.mDataList.contains(data)) {
            this.mDataList.remove(data);
            this.notifyDataSetChanged();
        }
    }

    private static class ErrorViewHolder
    extends ViewHolder<Object> {
        TextView errorInfo;

        public ErrorViewHolder(Activity activity) {
            super(activity);
        }

        @Override
        protected int getItemViewRes() {
            return 0;
        }

        @Override
        protected View getItemView() {
            FrameLayout frameLayout = new FrameLayout((Context)this.mActivity);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = 17;
            layoutParams.topMargin = 10;
            layoutParams.bottomMargin = 10;
            this.errorInfo = new TextView((Context)this.mActivity);
            this.errorInfo.setMaxLines(2);
            RectShape shape = new RectShape();
            GradientDrawable gradientDrawabled = new GradientDrawable();
            gradientDrawabled.setShape(0);
            gradientDrawabled.setCornerRadius(13.0f);
            gradientDrawabled.setStroke(1, 0x33000000);
            gradientDrawabled.setColor(0x11000000);
            gradientDrawabled.setBounds(20, 20, 20, 20);
            this.errorInfo.setBackgroundDrawable((Drawable)gradientDrawabled);
            frameLayout.addView((View)this.errorInfo, (ViewGroup.LayoutParams)layoutParams);
            return frameLayout;
        }

        @Override
        public void loadData(MultiAdapter<? super Object> adapter, Object data) {
        }
    }
}

