/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.powyin.scroll.widget.DefaultSwipeControl;
import com.powyin.scroll.widget.SwipeControl;

public class SwipeRefresh
extends ViewGroup
implements NestedScrollingParent {
    private View mTarget;
    private int mTouchSlop;
    private final NestedScrollingParentHelper mParentHelper;
    private boolean mNestedScrollInProgress;
    private float mInitialMotionY;
    private float mInitialDownY;
    private boolean mIsBeingDragged;
    private int mActivePointerId = -1;
    private SwipeControl mSwipeControl;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    boolean isFreshContinue = false;
    boolean isFreshComplete = false;
    private int scrollY_Up;
    private int scrollY_Down;

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public SwipeRefresh(Context context) {
        this(context, null);
    }

    public SwipeRefresh(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == this.mSwipeControl.getSwipeView()) continue;
                this.mTarget = child;
            }
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mSwipeControl = new DefaultSwipeControl(this.getContext());
        this.addView(this.mSwipeControl.getSwipeView(), 0);
        View lastView = this.getChildAt(this.getChildCount() - 1);
        if (lastView instanceof AbsListView) {
            AbsListView absListView = (AbsListView)lastView;
            absListView.setOverScrollMode(2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = SwipeRefresh.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = SwipeRefresh.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() > 2) {
            throw new RuntimeException("can not holder only one View");
        }
        int childLeft = this.getPaddingLeft();
        int childRight = right - left - this.getPaddingRight();
        int childTop = 0;
        this.mSwipeControl.getSwipeView().layout(childLeft, -this.mSwipeControl.getSwipeView().getMeasuredHeight(), childRight, 0);
        this.scrollY_Up = -this.mSwipeControl.getSwipeView().getMeasuredHeight();
        if (this.getChildCount() != 2) {
            return;
        }
        this.ensureTarget();
        LayoutParams lp = (LayoutParams)this.mTarget.getLayoutParams();
        this.mTarget.layout(childLeft, childTop, childRight, childTop + bottom);
        this.scrollY_Down = childTop += bottom + lp.bottomMargin;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        System.out.println("-----------------------:onInterceptTouchEvent");
        this.ensureTarget();
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (!this.isEnabled() || this.canChildScrollUp() || this.mNestedScrollInProgress) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialDownY == -1.0f) {
                    return false;
                }
                this.mInitialDownY = initialDownY;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = this.getMotionEventY(ev, this.mActivePointerId);
                if (y == -1.0f) {
                    return false;
                }
                float yDiff = y - this.mInitialDownY;
                if (!(yDiff > (float)this.mTouchSlop) || this.mIsBeingDragged) break;
                this.mIsBeingDragged = true;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
            }
        }
        if (this.mIsBeingDragged) {
            this.mInitialMotionY = 2.1474836E9f;
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        System.out.println("-----------------------:onTouchEvent");
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (!this.isEnabled() || this.canChildScrollUp() || this.mNestedScrollInProgress) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 2: {
                pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (pointerIndex < 0 || !this.mIsBeingDragged) break;
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                if (this.mInitialMotionY == 2.1474836E9f) {
                    this.mInitialMotionY = y;
                    break;
                }
                int off = this.offSetChildrenPreLocation((int)(this.mInitialMotionY - y));
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (pointerIndex < 0) break;
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (!this.tryBackToRefreshing()) {
                    this.tryBackToFreshFinish();
                }
                this.mActivePointerId = -1;
                this.mInitialMotionY = 2.1474836E9f;
                return true;
            }
        }
        pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mInitialMotionY = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        }
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    public boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1) || this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = ev.findPointerIndex(activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return ev.getY(index);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (this.mTarget != null && this.mTarget instanceof NestedScrollingChild) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetChildrenPreLocation(dy);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing() && this.mNestedScrollInProgress) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetChildrenLasLocation(dyUnconsumed);
    }

    public void finishRefresh() {
        this.isFreshContinue = false;
        this.isFreshComplete = true;
        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_COMPLETE, -this.getScrollY(), this.mSwipeControl.getSwipeView().getHeight());
        this.tryBackToFreshFinish();
    }

    private int offSetChildrenPreLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int minScrollY = this.scrollY_Up - this.mSwipeControl.getOverScrollHei();
        int currentScrollY = this.getScrollY();
        if (deltaY < 0 && currentScrollY < this.scrollY_Up && currentScrollY > minScrollY) {
            deltaY = (int)((double)deltaY * Math.pow((float)(currentScrollY - minScrollY) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.5));
        }
        if (currentScrollY >= minScrollY && currentScrollY < maxScrollY || this.getChildCount() == 2 && currentScrollY == 0 && !this.getChildAt(1).canScrollVertically(deltaY)) {
            int swipeViewVisibilityHei;
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            if (willTo < 0 && this.isFreshComplete && !this.isFreshContinue) {
                this.isFreshComplete = false;
            }
            if ((swipeViewVisibilityHei = 0 - willTo) > 0) {
                if (this.isFreshContinue) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOADING, swipeViewVisibilityHei, this.mSwipeControl.getSwipeView().getHeight());
                } else if (this.isFreshComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_COMPLETE, swipeViewVisibilityHei, this.mSwipeControl.getSwipeView().getHeight());
                } else if (willTo < -this.mSwipeControl.getSwipeView().getHeight()) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_OVER, swipeViewVisibilityHei, this.mSwipeControl.getSwipeView().getHeight());
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_TOAST, swipeViewVisibilityHei, this.mSwipeControl.getSwipeView().getHeight());
                }
            }
            return willTo - currentScrollY;
        }
        return 0;
    }

    private int offSetChildrenLasLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int currentScrollY = this.getScrollY();
        if (currentScrollY >= 0) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, 0);
            this.scrollTo(0, willTo);
            System.out.println("wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww:" + (willTo - currentScrollY));
            return willTo - currentScrollY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        int scrollY = this.getScrollY();
        this.stopAllScroll();
        boolean bl = isOverProgress = scrollY < -this.mSwipeControl.getSwipeView().getHeight();
        if (isOverProgress) {
            int animationTarget = -this.mSwipeControl.getSwipeView().getHeight();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, animationTarget});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeRefresh.this.getScrollY()) {
                        SwipeRefresh.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener((Animator.AnimatorListener)new AnimationStatus(){
                boolean isCancel = false;

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeRefresh.this.isFreshContinue = true;
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_LOADING, SwipeRefresh.this.mSwipeControl.getSwipeView().getHeight(), SwipeRefresh.this.mSwipeControl.getSwipeView().getHeight());
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(400 * (animationTarget - scrollY) / this.mSwipeControl.getSwipeView().getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        this.stopAllScroll();
        int scrollY = this.getScrollY();
        if (scrollY < 0) {
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeRefresh.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.setDuration((long)Math.abs(250 * (0 - scrollY) / this.mSwipeControl.getSwipeView().getHeight()));
            if (scrollY <= -this.mSwipeControl.getSwipeView().getHeight() + 10) {
                this.animationReBackToTop.setStartDelay(300L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            this.animationReBackToTop.cancel();
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    class AnimationStatus
    implements Animator.AnimatorListener {
        AnimationStatus() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

