/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

class CircleViewBac
extends View {
    float progress;
    boolean isFreshComplete;
    boolean isFreshing;
    Paint arcPaint;
    RectF arcRectF;
    int padding = 2;

    public CircleViewBac(Context context) {
        super(context);
    }

    public CircleViewBac(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CircleViewBac(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setProgress(float progress, boolean isFreshComplete, boolean isFreshing) {
        this.progress = progress;
        this.isFreshComplete = isFreshComplete;
        this.isFreshing = isFreshing;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircle(canvas);
        this.drawTag(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.arcRectF = new RectF((float)this.padding, (float)this.padding, (float)(w - this.padding), (float)(h - this.padding));
        this.arcPaint = new Paint();
        this.arcPaint.setStrokeWidth(2.0f);
        this.arcPaint.setStyle(Paint.Style.STROKE);
        this.arcPaint.setColor(-65536);
        this.arcPaint.setAntiAlias(true);
    }

    private void drawCircle(Canvas canvas) {
        int sweepAngle = this.progress >= 0.0f && this.progress <= 1.0f ? (int)(360.0f * this.progress) : 360;
        canvas.drawArc(this.arcRectF, 90.0f, (float)sweepAngle, false, this.arcPaint);
        System.out.println(this.progress + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    }

    private void drawTag(Canvas canvas) {
        if (this.progress < 0.9f) {
            return;
        }
    }
}

