/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.powyinScroll;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.powyin.scroll.powyinScroll.edge.EdgeController;
import com.powyin.scroll.powyinScroll.edge.HeaderEdgeController;

public class HeaderLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = HeaderLayout.class.getCanonicalName();
    int[] mChildLocation = new int[2];
    RectF mChildRectF = new RectF();
    private View mChildTouchView;
    private int sumViewHei = 0;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGE = 1;
    public static final int STATE_FLING = 2;
    public static final int STATE_BOUNCE = 3;
    protected EdgeController mHeaderController;
    protected EdgeController mButtonController;
    private VelocityTracker mVelocityTracker;
    private ValueAnimator mBounceAnim;
    private int mPullState = 0;
    private static final int INVALID_POINTER = -1;
    private int mActivePointerId = -1;
    private boolean mIsBeingDragged = false;
    private int mLastMotionY = 0;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mNestedYOffset;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private ScrollerCompat mScroller;
    private OnPullListener mPullListener;
    private ValueAnimator preReBackAnimator;
    private ValueAnimator reBackAnimator;

    public HeaderLayout(Context context) {
        this(context, null);
    }

    public HeaderLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HeaderLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mHeaderController = new HeaderEdgeController(context);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.init();
    }

    private void init() {
        this.mScroller = ScrollerCompat.create((Context)this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = 5;
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.setHeaderEdgeController(new HeaderEdgeController(this.getContext()));
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        Log.i((String)"NestedScrollingParent", (String)"onStartNestedScroll");
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedScrollAccepted");
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
    }

    public void onStopNestedScroll(View target) {
        Log.i((String)"NestedScrollingParent", (String)"onStopNestedScroll");
        this.tryReBack();
        this.stopNestedScroll();
    }

    private void tryReBack() {
        int scrollY = this.getScrollY();
        if (scrollY != 0) {
            if (this.preReBackAnimator != null && this.preReBackAnimator.isRunning()) {
                this.preReBackAnimator.cancel();
            }
            if (this.reBackAnimator != null && this.reBackAnimator.isRunning()) {
                this.reBackAnimator.cancel();
            }
            if (this.mHeaderController.isOverScroll()) {
                this.startPreReBack();
            } else {
                this.startReBack();
            }
        }
    }

    private void doReflush() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                HeaderLayout.this.startReBack();
            }
        }, 600L);
    }

    private void startPreReBack() {
        if (!this.mHeaderController.canScroll()) {
            return;
        }
        int scrollY = this.getScrollY();
        this.preReBackAnimator = ValueAnimator.ofInt((int[])new int[]{scrollY, this.mHeaderController.getShowHeight()});
        this.preReBackAnimator.setDuration((long)((int)Math.abs(300.0f * (1.0f * (float)(scrollY - this.mHeaderController.getShowHeight()) / (float)(this.mHeaderController.getExpandHeight() - this.mHeaderController.getShowHeight())))));
        this.preReBackAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int currentY = (Integer)animation.getAnimatedValue();
                HeaderLayout.this.scrollTo(0, currentY);
                HeaderLayout.this.mHeaderController.setScroll(currentY);
            }
        });
        this.preReBackAnimator.addListener(new Animator.AnimatorListener(){
            boolean cancel = false;

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancel) {
                    HeaderLayout.this.doReflush();
                }
            }

            public void onAnimationCancel(Animator animation) {
                this.cancel = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.preReBackAnimator.start();
    }

    private void startReBack() {
        if (!this.mHeaderController.canScroll()) {
            return;
        }
        if (this.reBackAnimator != null && this.reBackAnimator.isRunning()) {
            this.reBackAnimator.cancel();
        }
        int scrollY = this.getScrollY();
        this.reBackAnimator = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
        this.reBackAnimator.setDuration(200L);
        this.reBackAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int currentY = (Integer)animation.getAnimatedValue();
                HeaderLayout.this.scrollTo(0, currentY);
                HeaderLayout.this.mHeaderController.setScroll(currentY);
            }
        });
        this.reBackAnimator.start();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        Log.i((String)"NestedScrollingParent", (String)("onNestedScroll:  dyConsumed" + dyConsumed + "  dyUnConsumed:" + dyUnconsumed));
        if (dyUnconsumed < 0) {
            int myConsumed = this.moveBy(dyUnconsumed);
            this.dispatchNestedScroll(0, myConsumed, 0, dyUnconsumed -= myConsumed, null);
        } else {
            this.dispatchNestedScroll(0, 0, 0, dyUnconsumed, null);
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        Log.i((String)"NestedScrollingParent", (String)("onNestedPreScroll" + consumed[1] + ":" + dy));
        if (dy > 0) {
            int delta = this.moveBy(dy);
            consumed[0] = 0;
            consumed[1] = delta;
        }
        Log.i((String)"consumedY:", (String)(consumed[1] + ""));
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedFling");
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        int scrollY = this.getScrollY();
        if (scrollY > 0 && scrollY < this.sumViewHei - this.getHeight()) {
            this.fling((int)velocityY);
            return true;
        }
        return false;
    }

    private boolean flingWithNestedDispatch(int velocityY) {
        boolean canFling;
        boolean bl = canFling = this.mHeaderController.canScroll() && velocityY > 0 || this.mHeaderController.canScroll() && velocityY < 0;
        if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
            this.dispatchNestedFling(0.0f, velocityY, canFling);
            if (canFling) {
                this.fling(velocityY);
            }
        }
        return canFling;
    }

    public int getNestedScrollAxes() {
        Log.i((String)"NestedScrollingParent", (String)"getNestedScrollAxes");
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void setOnPullListener(OnPullListener listener) {
        this.mPullListener = listener;
    }

    public void setHeaderEdgeController(EdgeController headController) {
        this.mHeaderController = headController;
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.translate(0.0f, (float)this.getScrollY());
        if (this.mHeaderController != null) {
            this.mHeaderController.onPullProgress(canvas);
        }
        canvas.restore();
        super.dispatchDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int consumeHei = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, consumeHei);
            consumeHei += child.getMeasuredHeight();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutVertical(left, top, right, bottom);
    }

    void layoutVertical(int left, int top, int right, int bottom) {
        View lastIndexView;
        int childLeft = this.getPaddingLeft();
        int childRight = right - left - this.getPaddingRight();
        int childTop = this.getPaddingTop();
        int childSpace = childRight - childLeft;
        int count = this.getChildCount();
        for (int i = 0; i < count - 1; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(childLeft, childTop += lp.topMargin, childRight, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
        View view = lastIndexView = this.getChildCount() > 0 ? this.getChildAt(this.getChildCount() - 1) : null;
        if (lastIndexView instanceof NestedScrollingChild) {
            this.sumViewHei = childTop + bottom;
            lastIndexView.layout(childLeft, childTop, childRight, this.sumViewHei);
        } else if (lastIndexView != null) {
            this.sumViewHei = childTop + lastIndexView.getMeasuredHeight();
            lastIndexView.layout(childLeft, childTop, childRight, this.sumViewHei);
        }
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.releaseVelocityTracker();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii" + ev.getAction());
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action & 0xFF) {
            case 2: {
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::1");
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::2");
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                if (pointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent"));
                    break;
                }
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::3");
                int y = (int)MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                int yDiff = Math.abs(y - this.mLastMotionY);
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::::::" + y);
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::::::    " + (yDiff > this.mTouchSlop));
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::::::    " + this.getNestedScrollAxes());
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::::::    2");
                if (yDiff > this.mTouchSlop && (this.getNestedScrollAxes() & 2) == 0 || yDiff > this.mTouchSlop && !(this.mChildTouchView instanceof NestedScrollingChild)) {
                    this.mIsBeingDragged = true;
                    this.mLastMotionY = y;
                    this.obtainVelocityTracker(ev);
                    this.mNestedYOffset = 0;
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                }
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_MOVE::4");
                break;
            }
            case 0: {
                this.findChildTouchView(ev);
                int y = (int)ev.getY();
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_DOWN::1");
                this.mLastMotionY = y;
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_DOWN::2");
                this.mIsBeingDragged = !this.mScroller.isFinished();
                System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii ACTION_DOWN::" + this.mIsBeingDragged);
                this.startNestedScroll(2);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.endDrag();
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        System.out.println("iiiiiiiiiiiiiiiiiiiiiiiiii       -----------------" + this.mIsBeingDragged);
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        int actionMasked = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                ViewParent parent;
                this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.startNestedScroll(2);
                break;
            }
            case 2: {
                int unconsumedY;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent"));
                    break;
                }
                int y = (int)MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y - this.mScrollOffset[1];
                int scrolledDeltaY = this.moveBy(deltaY);
                if (!this.dispatchNestedScroll(0, scrolledDeltaY, 0, unconsumedY = deltaY - scrolledDeltaY, this.mScrollOffset)) break;
                this.mLastMotionY -= this.mScrollOffset[1];
                vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                this.mNestedYOffset += this.mScrollOffset[1];
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.flingWithNestedDispatch(-initialVelocity);
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void findChildTouchView(MotionEvent event) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.getLocationInWindow(this.mChildLocation);
            this.mChildRectF.left = this.mChildLocation[0];
            this.mChildRectF.right = this.mChildRectF.left + (float)view.getWidth();
            this.mChildRectF.top = this.mChildLocation[1];
            this.mChildRectF.bottom = this.mChildRectF.top + (float)view.getHeight();
            if (!this.mChildRectF.contains(event.getRawX(), event.getRawY())) continue;
            this.mChildTouchView = view;
            return;
        }
        this.mChildTouchView = null;
    }

    public void fling(int velocityY) {
        System.out.println("velocityY" + velocityY);
        this.mPullState = 2;
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.getScrollY(), 0, (int)((float)velocityY * 0.55f), 0, 0, 0, this.sumViewHei - this.getHeight());
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int moveBy(int deltaY) {
        int consumed = 0;
        if (deltaY == 0) {
            return 0;
        }
        int currentScrollY = this.getScrollY();
        int maxScrollY = this.sumViewHei - this.getHeight();
        if (currentScrollY >= 0 && currentScrollY <= maxScrollY) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            this.scrollTo(0, willTo);
            this.mHeaderController.setScroll(willTo);
            consumed = willTo - currentScrollY;
        }
        if (this.mHeaderController.canScroll()) {
            int oldScroll = this.mHeaderController.getScroll();
            int secondConsume = this.mHeaderController.move(deltaY - consumed);
            consumed += secondConsume;
            this.scrollBy(0, secondConsume);
            this.invalidate();
        }
        System.out.println("cp:::" + consumed + "---" + deltaY);
        return consumed;
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
        this.mHeaderController.setScroll(y);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int y;
            int oldY = this.mHeaderController.getScroll();
            if (oldY != (y = this.mScroller.getCurrY())) {
                this.moveBy(y - oldY);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            this.tryBounceBack();
        }
    }

    private void tryBounceBack() {
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info checkLayoutParams");
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        System.out.println("layoutParams info generateDefaultLayoutParams");
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(this.getContext(), attrs);
    }

    public static interface OnPullListener {
        public void onPullProgress(View var1, int var2, float var3);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

