/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.ogm.mappers.scalar;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tinkerpop.gremlin.ogm.mappers.PropertyBiMapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lorg/apache/tinkerpop/gremlin/ogm/mappers/scalar/InstantPropertyMapper;", "Lorg/apache/tinkerpop/gremlin/ogm/mappers/PropertyBiMapper;", "Ljava/time/Instant;", "", "()V", "forwardMap", "from", "inverseMap", "kotlin-gremlin-ogm"})
public final class InstantPropertyMapper
implements PropertyBiMapper<Instant, String> {
    public static final InstantPropertyMapper INSTANCE;

    @Override
    @NotNull
    public String forwardMap(@NotNull Instant from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        return "" + from.getEpochSecond() + ':' + from.getNano();
    }

    @Override
    @NotNull
    public Instant inverseMap(@NotNull String from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        List parts = StringsKt.split$default((CharSequence)from, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
        String string = (String)parts.get(0);
        long epochSecond = Long.parseLong(string);
        String string2 = (String)parts.get(1);
        long nano = Long.parseLong(string2);
        Instant instant = Instant.ofEpochSecond(epochSecond, nano);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochSecond(epochSecond, nano)");
        return instant;
    }

    private InstantPropertyMapper() {
    }

    static {
        InstantPropertyMapper instantPropertyMapper;
        INSTANCE = instantPropertyMapper = new InstantPropertyMapper();
    }
}

