/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import wigzo.android.sdk.Event;

public class WigzoStore {
    private static final String PREFERENCES = "WIGZO_STORE";
    private static final String DELIMITER = ":::";
    private static final String CONNECTIONS_PREFERENCE = "CONNECTIONS";
    private static final String EVENTS_PREFERENCE = "EVENTS";
    private static final String LOCATION_PREFERENCE = "LOCATION";
    private final SharedPreferences preferences_;

    WigzoStore(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("must provide valid context");
        }
        this.preferences_ = context.getSharedPreferences(PREFERENCES, 0);
    }

    public String[] connections() {
        String joinedConnStr = this.preferences_.getString(CONNECTIONS_PREFERENCE, "");
        return joinedConnStr.length() == 0 ? new String[]{} : joinedConnStr.split(DELIMITER);
    }

    public String[] events() {
        String joinedEventsStr = this.preferences_.getString(EVENTS_PREFERENCE, "");
        return joinedEventsStr.length() == 0 ? new String[]{} : joinedEventsStr.split(DELIMITER);
    }

    public List<Event> eventsList() {
        String[] array = this.events();
        ArrayList<Event> events = new ArrayList<Event>(array.length);
        for (String s : array) {
            try {
                Event event = Event.fromJSON(new JSONObject(s));
                if (event == null) continue;
                events.add(event);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event e1, Event e2) {
                return e1.timestamp - e2.timestamp;
            }
        });
        return events;
    }

    public boolean isEmptyConnections() {
        return this.preferences_.getString(CONNECTIONS_PREFERENCE, "").length() == 0;
    }

    public synchronized void addConnection(String str) {
        if (str != null && str.length() > 0) {
            ArrayList<String> connections = new ArrayList<String>(Arrays.asList(this.connections()));
            connections.add(str);
            this.preferences_.edit().putString(CONNECTIONS_PREFERENCE, WigzoStore.join(connections, DELIMITER)).apply();
        }
    }

    public synchronized void removeConnection(String str) {
        ArrayList<String> connections;
        if (str != null && str.length() > 0 && (connections = new ArrayList<String>(Arrays.asList(this.connections()))).remove(str)) {
            this.preferences_.edit().putString(CONNECTIONS_PREFERENCE, WigzoStore.join(connections, DELIMITER)).apply();
        }
    }

    void addEvent(Event event) {
        List<Event> events = this.eventsList();
        events.add(event);
        this.preferences_.edit().putString(EVENTS_PREFERENCE, WigzoStore.joinEvents(events, DELIMITER)).apply();
    }

    void setLocation(double lat, double lon) {
        this.preferences_.edit().putString(LOCATION_PREFERENCE, lat + "," + lon).apply();
    }

    String getAndRemoveLocation() {
        String location = this.preferences_.getString(LOCATION_PREFERENCE, "");
        if (!location.equals("")) {
            this.preferences_.edit().remove(LOCATION_PREFERENCE).apply();
        }
        return location;
    }

    public synchronized void addEvent(String key, Map<String, String> segmentation, int timestamp, int hour, int dow, int count, double sum) {
        Event event = new Event();
        event.key = key;
        event.segmentation = segmentation;
        event.timestamp = timestamp;
        event.hour = hour;
        event.dow = dow;
        event.count = count;
        event.sum = sum;
        this.addEvent(event);
    }

    public synchronized void removeEvents(Collection<Event> eventsToRemove) {
        List<Event> events;
        if (eventsToRemove != null && eventsToRemove.size() > 0 && (events = this.eventsList()).removeAll(eventsToRemove)) {
            this.preferences_.edit().putString(EVENTS_PREFERENCE, WigzoStore.joinEvents(events, DELIMITER)).apply();
        }
    }

    static String joinEvents(Collection<Event> collection, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Event e : collection) {
            strings.add(e.toJSON().toString());
        }
        return WigzoStore.join(strings, delimiter);
    }

    static String join(Collection<String> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String s : collection) {
            builder.append(s);
            if (++i >= collection.size()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public synchronized String getPreference(String key) {
        return this.preferences_.getString(key, null);
    }

    public synchronized void setPreference(String key, String value) {
        if (value == null) {
            this.preferences_.edit().remove(key).apply();
        } else {
            this.preferences_.edit().putString(key, value).apply();
        }
    }

    synchronized void clear() {
        SharedPreferences.Editor prefsEditor = this.preferences_.edit();
        prefsEditor.remove(EVENTS_PREFERENCE);
        prefsEditor.remove(CONNECTIONS_PREFERENCE);
        prefsEditor.apply();
    }
}

