/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import wigzo.android.sdk.AdvertisingIdAdapter;
import wigzo.android.sdk.ConnectionQueue;
import wigzo.android.sdk.CrashDetails;
import wigzo.android.sdk.DeviceId;
import wigzo.android.sdk.EventQueue;
import wigzo.android.sdk.MessagingAdapter;
import wigzo.android.sdk.OpenUDIDAdapter;
import wigzo.android.sdk.ReferrerReceiver;
import wigzo.android.sdk.UserData;
import wigzo.android.sdk.WigzoAppStore;
import wigzo.android.sdk.WigzoStore;

public class Wigzo {
    public static final String WIGZO_SDK_VERSION_STRING = "1.0";
    public static final String DEFAULT_APP_VERSION = "1.0";
    public static final String TAG = "Wigzo";
    private static final int EVENT_QUEUE_SIZE_THRESHOLD = 10;
    private static final long TIMER_DELAY_IN_SECONDS = 60L;
    protected static List<String> publicKeyPinCertificates;
    private ConnectionQueue connectionQueue_ = new ConnectionQueue();
    private ScheduledExecutorService timerService_;
    private EventQueue eventQueue_;
    private EventQueue mobileQueue;
    private long prevSessionDurationStartTime_;
    private int activityCount_;
    private boolean disableUpdateSessionRequests_;
    private boolean enableLogging_;
    private WigzoMessagingMode messagingMode_;
    private Context context_;
    public static UserData userData;
    private String lastView = null;
    private int lastViewStart = 0;
    private boolean firstView = true;
    private boolean autoViewTracker = false;

    public static Wigzo sharedInstance() {
        return SingletonHolder.instance;
    }

    Wigzo() {
        userData = new UserData(this.connectionQueue_);
        this.timerService_ = Executors.newSingleThreadScheduledExecutor();
        this.timerService_.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Wigzo.this.onTimer();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public Wigzo init(Context context, String serverURL, String appKey, String orgId) {
        return this.init(context, serverURL, appKey, null, OpenUDIDAdapter.isOpenUDIDAvailable() ? DeviceId.Type.OPEN_UDID : DeviceId.Type.ADVERTISING_ID, orgId);
    }

    public Wigzo init(Context context, String serverURL, String appKey, String deviceID, String orgId) {
        return this.init(context, serverURL, appKey, deviceID, orgId);
    }

    public synchronized Wigzo init(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode, String orgId) {
        DeviceId deviceIdInstance;
        if (context == null) {
            throw new IllegalArgumentException("valid context is required");
        }
        if (orgId == null || orgId.length() == 0) {
            throw new IllegalArgumentException("Valid Organization Id is required!");
        }
        if (!Wigzo.isValidURL(serverURL)) {
            throw new IllegalArgumentException("valid serverURL is required");
        }
        if (appKey == null || appKey.length() == 0) {
            throw new IllegalArgumentException("valid appKey is required");
        }
        if (deviceID != null && deviceID.length() == 0) {
            throw new IllegalArgumentException("valid deviceID is required");
        }
        if (deviceID == null && idMode == null) {
            if (OpenUDIDAdapter.isOpenUDIDAvailable()) {
                idMode = DeviceId.Type.OPEN_UDID;
            } else if (AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
                idMode = DeviceId.Type.ADVERTISING_ID;
            }
        }
        if (deviceID == null && idMode == DeviceId.Type.OPEN_UDID && !OpenUDIDAdapter.isOpenUDIDAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because OpenUDID is not available");
        }
        if (deviceID == null && idMode == DeviceId.Type.ADVERTISING_ID && !AdvertisingIdAdapter.isAdvertisingIdAvailable()) {
            throw new IllegalArgumentException("valid deviceID is required because Advertising ID is not available (you need to include Google Play services 4.0+ into your project)");
        }
        if (!(this.eventQueue_ == null || this.connectionQueue_.getServerURL().equals(serverURL) && this.connectionQueue_.getAppKey().equals(appKey) && DeviceId.deviceIDEqualsNullSafe(deviceID, idMode, this.connectionQueue_.getDeviceId()))) {
            throw new IllegalStateException("Wigzo cannot be reinitialized with different values");
        }
        if (MessagingAdapter.isMessagingAvailable()) {
            MessagingAdapter.storeConfiguration(context, serverURL, appKey, deviceID, idMode, orgId);
        }
        if (this.eventQueue_ == null) {
            deviceIdInstance = deviceID != null ? new DeviceId(deviceID) : new DeviceId(idMode);
            WigzoStore wigzoStore = new WigzoStore(context);
            deviceIdInstance.init(context, wigzoStore, true);
            this.connectionQueue_.setOrganizationId(orgId);
            this.connectionQueue_.setServerURL(serverURL);
            this.connectionQueue_.setAppKey(appKey);
            this.connectionQueue_.setWigzoStore(wigzoStore);
            this.connectionQueue_.setDeviceId(deviceIdInstance);
            this.eventQueue_ = new EventQueue(wigzoStore);
        }
        if (this.mobileQueue == null) {
            deviceIdInstance = deviceID != null ? new DeviceId(deviceID) : new DeviceId(idMode);
            WigzoAppStore wigzoAppStore = new WigzoAppStore(context);
            deviceIdInstance.init(context, wigzoAppStore, true);
            this.connectionQueue_.setServerURL(serverURL);
            this.connectionQueue_.setAppKey(appKey);
            this.connectionQueue_.setOrganizationId(orgId);
            this.connectionQueue_.setWigzoAppStore(wigzoAppStore);
            this.connectionQueue_.setDeviceId(deviceIdInstance);
            this.mobileQueue = new EventQueue(wigzoAppStore);
        }
        this.context_ = context;
        this.connectionQueue_.setContext(context);
        return this;
    }

    public synchronized boolean isInitialized() {
        return this.eventQueue_ != null;
    }

    public synchronized boolean isInitializedMobile() {
        return this.mobileQueue != null;
    }

    public Wigzo initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, WigzoMessagingMode mode, String orgId) {
        return this.initMessaging(activity, activityClass, projectID, null, mode, orgId);
    }

    public synchronized Wigzo initMessaging(Activity activity, Class<? extends Activity> activityClass, String projectID, String[] buttonNames, WigzoMessagingMode mode, String orgId) {
        if (mode != null && !MessagingAdapter.isMessagingAvailable()) {
            throw new IllegalStateException("you need to include wigzo-messaging-sdk-android library instead of wigzo-sdk-android if you want to use Wigzo Messaging");
        }
        this.messagingMode_ = mode;
        if (!MessagingAdapter.init(activity, activityClass, projectID, buttonNames)) {
            throw new IllegalStateException("couldn't initialize Wigzo Messaging");
        }
        if (MessagingAdapter.isMessagingAvailable()) {
            MessagingAdapter.storeConfiguration(this.connectionQueue_.getContext(), this.connectionQueue_.getServerURL(), this.connectionQueue_.getAppKey(), this.connectionQueue_.getDeviceId().getId(), this.connectionQueue_.getDeviceId().getType(), this.connectionQueue_.getOrganizationId());
        }
        return this;
    }

    public synchronized void halt() {
        this.eventQueue_ = null;
        WigzoStore wigzoStore = this.connectionQueue_.getWigzoStore();
        WigzoAppStore wigzoAppStore = this.connectionQueue_.getWigzoAppStore();
        if (wigzoStore != null) {
            wigzoStore.clear();
        }
        if (wigzoAppStore != null) {
            wigzoAppStore.clear();
        }
        this.connectionQueue_.setOrganizationId(null);
        this.connectionQueue_.setContext(null);
        this.connectionQueue_.setServerURL(null);
        this.connectionQueue_.setAppKey(null);
        this.connectionQueue_.setWigzoStore(null);
        this.connectionQueue_.setWigzoAppStore(null);
        this.prevSessionDurationStartTime_ = 0L;
        this.activityCount_ = 0;
    }

    public synchronized void onStart(Activity activity) {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStart");
        }
        ++this.activityCount_;
        if (this.activityCount_ == 1) {
            this.onStartHelper();
        }
        String referrer = ReferrerReceiver.getReferrer(this.context_);
        if (Wigzo.sharedInstance().isLoggingEnabled()) {
            Log.d((String)TAG, (String)("Checking referrer: " + referrer));
        }
        if (referrer != null) {
            this.connectionQueue_.sendReferrerData(referrer);
            ReferrerReceiver.deleteReferrer(this.context_);
        }
        CrashDetails.inForeground();
        if (this.autoViewTracker) {
            this.recordView(activity.getClass().getName());
        }
    }

    void onStartHelper() {
        this.prevSessionDurationStartTime_ = System.nanoTime();
        this.connectionQueue_.beginSession();
    }

    public synchronized void onStop() {
        if (this.eventQueue_ == null) {
            throw new IllegalStateException("init must be called before onStop");
        }
        if (this.activityCount_ == 0) {
            throw new IllegalStateException("must call onStart before onStop");
        }
        --this.activityCount_;
        if (this.activityCount_ == 0) {
            this.onStopHelper();
        }
        CrashDetails.inBackground();
        this.reportViewDuration();
    }

    void onStopHelper() {
        this.connectionQueue_.endSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        this.prevSessionDurationStartTime_ = 0L;
        if (this.eventQueue_.size() > 0) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
        if (this.mobileQueue.mobilesize() > 0) {
            this.connectionQueue_.recordEvents(this.mobileQueue.mobileEvents());
        }
    }

    public void onRegistrationId(String registrationId) {
        this.connectionQueue_.tokenSession(registrationId, this.messagingMode_);
    }

    public void recordEvent(String key) {
        this.recordEvent(key, null, 1, 0.0);
    }

    public void recordEvent(String key, int count) {
        this.recordEvent(key, null, count, 0.0);
    }

    public void recordEvent(String key, int count, double sum) {
        this.recordEvent(key, null, count, sum);
    }

    public void recordEvent(String key, Map<String, String> segmentation, int count) {
        this.recordEvent(key, segmentation, count, 0.0);
    }

    public synchronized void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        System.out.println("WIGZO OBJECT INSIDE recordEvent:::::::: " + this);
        if (!this.isInitialized()) {
            throw new IllegalStateException("Wigzo.sharedInstance().init must be called before recordEvent");
        }
        if (!this.isInitializedMobile()) {
            throw new IllegalStateException("Mobile.sharedInstance().init must be called before recordEvent");
        }
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Valid Wigzo event key is required");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Wigzo event count should be greater than zero");
        }
        if (segmentation != null) {
            for (String k : segmentation.keySet()) {
                if (k == null || k.length() == 0) {
                    throw new IllegalArgumentException("Wigzo event segmentation key cannot be null or empty");
                }
                if (segmentation.get(k) != null && segmentation.get(k).length() != 0) continue;
                throw new IllegalArgumentException("Wigzo event segmentation value cannot be null or empty");
            }
        }
        this.eventQueue_.recordEvent(key, segmentation, count, sum);
        this.mobileQueue.recordMobileEvent(key, segmentation, count, sum);
        this.sendEventsIfNeeded();
    }

    public synchronized Wigzo setViewTracking(boolean enable) {
        this.autoViewTracker = enable;
        return this;
    }

    public synchronized boolean isViewTrackingEnabled() {
        return this.autoViewTracker;
    }

    public synchronized Wigzo recordView(String viewName) {
        this.reportViewDuration();
        this.lastView = viewName;
        this.lastViewStart = Wigzo.currentTimestamp();
        HashMap<String, String> segments = new HashMap<String, String>();
        segments.put("name", viewName);
        segments.put("visit", "1");
        segments.put("segment", "Android");
        if (this.firstView) {
            this.firstView = false;
            segments.put("start", "1");
        }
        this.recordEvent("[CLY]_view", segments, 1);
        return this;
    }

    public synchronized Wigzo setUserData(Map<String, String> data) {
        return this.setUserData(data, null);
    }

    public synchronized Wigzo setUserData(Map<String, String> data, Map<String, String> customdata) {
        UserData.setData(data);
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        UserData.clear();
        return this;
    }

    public synchronized Wigzo setCustomUserData(Map<String, String> customdata) {
        if (customdata != null) {
            UserData.setCustomData(customdata);
        }
        this.connectionQueue_.sendUserData();
        UserData.clear();
        return this;
    }

    public synchronized Wigzo setLocation(double lat, double lon) {
        this.connectionQueue_.getWigzoStore().setLocation(lat, lon);
        this.connectionQueue_.getWigzoAppStore().setLocation(lat, lon);
        if (this.disableUpdateSessionRequests_) {
            this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
        }
        return this;
    }

    public synchronized Wigzo setCustomCrashSegments(Map<String, String> segments) {
        if (segments != null) {
            CrashDetails.setCustomSegments(segments);
        }
        return this;
    }

    public synchronized Wigzo addCrashLog(String record) {
        CrashDetails.addLog(record);
        return this;
    }

    public synchronized Wigzo logException(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        this.connectionQueue_.sendCrashReport(sw.toString(), true);
        return this;
    }

    public synchronized Wigzo enableCrashReporting() {
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Wigzo.sharedInstance().connectionQueue_.sendCrashReport(sw.toString(), false);
                if (oldHandler != null) {
                    oldHandler.uncaughtException(t, e);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return this;
    }

    public synchronized Wigzo setDisableUpdateSessionRequests(boolean disable) {
        this.disableUpdateSessionRequests_ = disable;
        return this;
    }

    public synchronized Wigzo setLoggingEnabled(boolean enableLogging) {
        this.enableLogging_ = enableLogging;
        return this;
    }

    public synchronized boolean isLoggingEnabled() {
        return this.enableLogging_;
    }

    void reportViewDuration() {
        if (this.lastView != null) {
            HashMap<String, String> segments = new HashMap<String, String>();
            segments.put("name", this.lastView);
            this.lastView = null;
            this.lastViewStart = 0;
        }
    }

    void sendEventsIfNeeded() {
        if (this.eventQueue_.size() >= 10) {
            this.connectionQueue_.recordEvents(this.eventQueue_.events());
        }
        if (this.mobileQueue.mobilesize() >= 10) {
            this.connectionQueue_.recordEvents(this.mobileQueue.mobileEvents());
        }
    }

    synchronized void onTimer() {
        boolean hasActiveSession;
        boolean bl = hasActiveSession = this.activityCount_ > 0;
        if (hasActiveSession) {
            if (!this.disableUpdateSessionRequests_) {
                this.connectionQueue_.updateSession(this.roundedSecondsSinceLastSessionDurationUpdate());
            }
            if (this.eventQueue_.size() > 0) {
                this.connectionQueue_.recordEvents(this.eventQueue_.events());
            }
            if (this.mobileQueue.mobilesize() > 0) {
                this.connectionQueue_.recordEvents(this.mobileQueue.events());
            }
        }
    }

    int roundedSecondsSinceLastSessionDurationUpdate() {
        long currentTimestampInNanoseconds = System.nanoTime();
        long unsentSessionLengthInNanoseconds = currentTimestampInNanoseconds - this.prevSessionDurationStartTime_;
        this.prevSessionDurationStartTime_ = currentTimestampInNanoseconds;
        return (int)Math.round((double)unsentSessionLengthInNanoseconds / 1.0E9);
    }

    public static int currentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static int currentHour() {
        return Calendar.getInstance().get(11);
    }

    static int currentDayOfWeek() {
        int day = Calendar.getInstance().get(7);
        switch (day) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }

    static boolean isValidURL(String urlStr) {
        boolean validURL = false;
        if (urlStr != null && urlStr.length() > 0) {
            try {
                new URL(urlStr);
                validURL = true;
            }
            catch (MalformedURLException e) {
                validURL = false;
            }
        }
        return validURL;
    }

    public static Wigzo enablePublicKeyPinning(List<String> certificates) {
        publicKeyPinCertificates = certificates;
        return Wigzo.sharedInstance();
    }

    ConnectionQueue getConnectionQueue() {
        return this.connectionQueue_;
    }

    void setConnectionQueue(ConnectionQueue connectionQueue) {
        this.connectionQueue_ = connectionQueue;
    }

    ExecutorService getTimerService() {
        return this.timerService_;
    }

    EventQueue getEventQueue() {
        return this.eventQueue_;
    }

    void setEventQueue(EventQueue eventQueue) {
        this.eventQueue_ = eventQueue;
    }

    long getPrevSessionDurationStartTime() {
        return this.prevSessionDurationStartTime_;
    }

    void setPrevSessionDurationStartTime(long prevSessionDurationStartTime) {
        this.prevSessionDurationStartTime_ = prevSessionDurationStartTime;
    }

    int getActivityCount() {
        return this.activityCount_;
    }

    synchronized boolean getDisableUpdateSessionRequests() {
        return this.disableUpdateSessionRequests_;
    }

    public void stackOverflow() {
        this.stackOverflow();
    }

    public synchronized Wigzo crashTest(int crashNumber) {
        if (crashNumber == 1) {
            if (Wigzo.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 1");
            }
            this.stackOverflow();
        } else if (crashNumber == 2) {
            if (Wigzo.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 2");
            }
            int n = 10 / 0;
        } else {
            if (crashNumber == 3) {
                if (Wigzo.sharedInstance().isLoggingEnabled()) {
                    Log.d((String)TAG, (String)"Running crashTest 3");
                }
                Object[] o = null;
                while (true) {
                    o = new Object[]{o};
                }
            }
            if (crashNumber == 4) {
                if (Wigzo.sharedInstance().isLoggingEnabled()) {
                    Log.d((String)TAG, (String)"Running crashTest 4");
                }
                throw new RuntimeException("This is a crash");
            }
            if (Wigzo.sharedInstance().isLoggingEnabled()) {
                Log.d((String)TAG, (String)"Running crashTest 5");
            }
            String test = null;
            test.charAt(1);
        }
        return Wigzo.sharedInstance();
    }

    private static class SingletonHolder {
        static final Wigzo instance = new Wigzo();

        private SingletonHolder() {
        }
    }

    public static enum WigzoMessagingMode {
        TEST,
        PRODUCTION;

    }
}

