/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.net.URLDecoder;

public class ReferrerReceiver
extends BroadcastReceiver {
    private static String key = "referrer";

    public static String getReferrer(Context context) {
        return context.getSharedPreferences(key, 0).getString(key, null);
    }

    public static void deleteReferrer(Context context) {
        context.getSharedPreferences(key, 0).edit().remove(key).commit();
    }

    public void onReceive(Context context, Intent intent) {
        try {
            String rawReferrer;
            if (null != intent && intent.getAction().equals("com.android.vending.INSTALL_REFERRER") && null != (rawReferrer = intent.getStringExtra(key))) {
                String referrer = URLDecoder.decode(rawReferrer, "UTF-8");
                Log.d((String)"Wigzo", (String)("Referrer: " + referrer));
                String[] parts = referrer.split("&");
                String cid = null;
                String uid = null;
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].startsWith("wigzo_cid")) {
                        cid = parts[i].replace("wigzo_cid=", "").trim();
                    }
                    if (!parts[i].startsWith("wigzo_cuid")) continue;
                    uid = parts[i].replace("wigzo_cuid=", "").trim();
                }
                String res = "";
                if (cid != null) {
                    res = res + "&campaign_id=" + cid;
                }
                if (uid != null) {
                    res = res + "&campaign_user=" + uid;
                }
                Log.d((String)"Wigzo", (String)("Processed: " + res));
                if (!res.equals("")) {
                    context.getSharedPreferences(key, 0).edit().putString(key, res).commit();
                }
            }
        }
        catch (Exception e) {
            Log.d((String)"Wigzo", (String)e.toString());
        }
    }
}

