/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import wigzo.android.sdk.Event;
import wigzo.android.sdk.Wigzo;
import wigzo.android.sdk.WigzoAppStore;
import wigzo.android.sdk.WigzoStore;

public class EventQueue {
    private WigzoStore wigzoStore_ = null;
    private WigzoAppStore wigzoAppStore_ = null;

    EventQueue(WigzoStore wigzoStore) {
        this.wigzoStore_ = wigzoStore;
    }

    EventQueue(WigzoAppStore wigzoAppStores) {
        this.wigzoAppStore_ = wigzoAppStores;
    }

    int size() {
        return this.wigzoStore_.events().length;
    }

    int mobilesize() {
        return this.wigzoAppStore_.events().length;
    }

    String events() {
        List<Event> events = this.wigzoStore_.eventsList();
        JSONArray eventArray = new JSONArray();
        JSONArray mobileeventArray = new JSONArray();
        for (Event e : events) {
            eventArray.put((Object)e.toJSON());
        }
        String result = eventArray.toString();
        this.wigzoStore_.removeEvents(events);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    String mobileEvents() {
        List<Event> mobileevent = this.wigzoAppStore_.eventsList();
        JSONArray mobileeventArray = new JSONArray();
        for (Event e : mobileevent) {
            mobileeventArray.put((Object)e.toJSON());
        }
        String mobileResult = mobileevent.toString();
        this.wigzoAppStore_.removeEvents(mobileevent);
        try {
            mobileResult = URLEncoder.encode(mobileResult, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return mobileResult;
    }

    void recordEvent(String key, Map<String, String> segmentation, int count, double sum) {
        int timestamp = Wigzo.currentTimestamp();
        int hour = Wigzo.currentHour();
        int dow = Wigzo.currentDayOfWeek();
        this.wigzoStore_.addEvent(key, segmentation, timestamp, hour, dow, count, sum);
    }

    void recordMobileEvent(String key, Map<String, String> segmentation, int count, double sum) {
        int timestamp = Wigzo.currentTimestamp();
        int hour = Wigzo.currentHour();
        int dow = Wigzo.currentDayOfWeek();
        this.wigzoAppStore_.addEvent(key, segmentation, timestamp, hour, dow, count, sum);
    }

    WigzoStore getWigzoStore() {
        return this.wigzoStore_;
    }

    WigzoAppStore getWigzoAppStore_() {
        return this.wigzoAppStore_;
    }
}

