/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.content.Context;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import wigzo.android.sdk.CertificateTrustManager;
import wigzo.android.sdk.ConnectionProcessor;
import wigzo.android.sdk.ConnectionProcessorWigzoApp;
import wigzo.android.sdk.CrashDetails;
import wigzo.android.sdk.DeviceId;
import wigzo.android.sdk.DeviceInfo;
import wigzo.android.sdk.UserData;
import wigzo.android.sdk.Wigzo;
import wigzo.android.sdk.WigzoAppStore;
import wigzo.android.sdk.WigzoStore;

public class ConnectionQueue {
    private WigzoStore store_;
    private WigzoAppStore wigzoAppStore;
    private ExecutorService executor_;
    private String appKey_;
    private String orgId;
    private Context context_;
    private String serverURL_;
    private Future<?> connectionProcessorFuture_;
    private DeviceId deviceId_;
    private SSLContext sslContext_;

    String getAppKey() {
        return this.appKey_;
    }

    String getOrganizationId() {
        return this.orgId;
    }

    void setOrganizationId(String orgid) {
        this.orgId = orgid;
    }

    void setAppKey(String appKey) {
        this.appKey_ = appKey;
    }

    Context getContext() {
        return this.context_;
    }

    void setContext(Context context) {
        this.context_ = context;
    }

    String getServerURL() {
        return this.serverURL_;
    }

    void setServerURL(String serverURL) {
        this.serverURL_ = serverURL;
        if (Wigzo.publicKeyPinCertificates == null) {
            this.sslContext_ = null;
        } else {
            try {
                TrustManager[] tm = new TrustManager[]{new CertificateTrustManager(Wigzo.publicKeyPinCertificates)};
                this.sslContext_ = SSLContext.getInstance("TLS");
                this.sslContext_.init(null, tm, null);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }

    WigzoStore getWigzoStore() {
        return this.store_;
    }

    WigzoAppStore getWigzoAppStore() {
        return this.wigzoAppStore;
    }

    void setWigzoStore(WigzoStore wigzoStore) {
        this.store_ = wigzoStore;
    }

    void setWigzoAppStore(WigzoAppStore wigzoStore) {
        this.wigzoAppStore = wigzoStore;
    }

    DeviceId getDeviceId() {
        return this.deviceId_;
    }

    public void setDeviceId(DeviceId deviceId) {
        this.deviceId_ = deviceId;
    }

    void checkInternalState() {
        if (this.context_ == null) {
            throw new IllegalStateException("context has not been set");
        }
        if (this.orgId == null || this.orgId.length() == 0) {
            throw new IllegalArgumentException("Organization Id has not been set!");
        }
        if (this.appKey_ == null || this.appKey_.length() == 0) {
            throw new IllegalStateException("app key has not been set");
        }
        if (this.store_ == null) {
            throw new IllegalStateException("wigzo store has not been set");
        }
        if (this.wigzoAppStore == null) {
            throw new IllegalStateException("Mobile store has not been set");
        }
        if (this.serverURL_ == null || !Wigzo.isValidURL(this.serverURL_)) {
            throw new IllegalStateException("server URL is not valid");
        }
        if (Wigzo.publicKeyPinCertificates != null && !this.serverURL_.startsWith("https")) {
            throw new IllegalStateException("server must start with https once you specified public keys");
        }
    }

    void beginSession() {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&sdk_version=" + "1.0" + "&begin_session=1" + "&metrics=" + DeviceInfo.getMetrics(this.context_);
        this.store_.addConnection(data);
        this.wigzoAppStore.addConnection(data);
        this.tick();
    }

    void updateSession(int duration) {
        this.checkInternalState();
        if (duration > 0) {
            String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&session_duration=" + duration + "&location=" + this.getWigzoStore().getAndRemoveLocation();
            String mobileData = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&session_duration=" + duration + "&location=" + this.getWigzoAppStore().getAndRemoveLocation();
            this.store_.addConnection(data);
            this.wigzoAppStore.addConnection(mobileData);
            this.tick();
        }
    }

    public void tokenSession(String token, Wigzo.WigzoMessagingMode mode) {
        this.checkInternalState();
        final String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&" + "timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&" + "token_session=1" + "&" + "android_token=" + token + "&" + "test_mode=" + (mode == Wigzo.WigzoMessagingMode.TEST ? 2 : 0) + "&" + "locale=" + DeviceInfo.getLocale();
        ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
        worker.schedule(new Runnable(){

            @Override
            public void run() {
                ConnectionQueue.this.store_.addConnection(data);
                ConnectionQueue.this.wigzoAppStore.addConnection(data);
                ConnectionQueue.this.tick();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    void endSession(int duration) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&end_session=1";
        if (duration > 0) {
            data = data + "&session_duration=" + duration;
        }
        this.store_.addConnection(data);
        this.wigzoAppStore.addConnection(data);
        this.tick();
    }

    void sendUserData() {
        this.checkInternalState();
        String userdata = UserData.getDataForRequest();
        if (!userdata.equals("")) {
            String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + userdata;
            this.store_.addConnection(data);
            this.wigzoAppStore.addConnection(data);
            this.tick();
        }
    }

    void sendReferrerData(String referrer) {
        this.checkInternalState();
        if (referrer != null) {
            String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + referrer;
            this.store_.addConnection(data);
            this.wigzoAppStore.addConnection(data);
            this.tick();
        }
    }

    void sendCrashReport(String error, boolean nonfatal) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&sdk_version=" + "1.0" + "&crash=" + CrashDetails.getCrashData(this.context_, error, nonfatal);
        this.store_.addConnection(data);
        this.wigzoAppStore.addConnection(data);
        this.tick();
    }

    void recordEvents(String events) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&events=" + events;
        this.store_.addConnection(data);
        this.wigzoAppStore.addConnection(data);
        this.tick();
    }

    void recordLocation(String events) {
        this.checkInternalState();
        String data = "app_key=" + this.appKey_ + "&" + "orgId=" + this.orgId + "&timestamp=" + Wigzo.currentTimestamp() + "&hour=" + Wigzo.currentHour() + "&dow=" + Wigzo.currentDayOfWeek() + "&events=" + events;
        this.store_.addConnection(data);
        this.wigzoAppStore.addConnection(data);
        this.tick();
    }

    void ensureExecutor() {
        if (this.executor_ == null) {
            this.executor_ = Executors.newSingleThreadExecutor();
        }
    }

    void tick() {
        if (!this.store_.isEmptyConnections() && (this.connectionProcessorFuture_ == null || this.connectionProcessorFuture_.isDone())) {
            this.ensureExecutor();
            this.connectionProcessorFuture_ = this.executor_.submit(new ConnectionProcessorWigzoApp(this.serverURL_, this.wigzoAppStore, this.deviceId_, this.sslContext_));
            this.connectionProcessorFuture_ = this.executor_.submit(new ConnectionProcessor(this.serverURL_, this.store_, this.deviceId_, this.sslContext_));
        }
    }

    ExecutorService getExecutor() {
        return this.executor_;
    }

    void setExecutor(ExecutorService executor) {
        this.executor_ = executor;
    }

    Future<?> getConnectionProcessorFuture() {
        return this.connectionProcessorFuture_;
    }

    void setConnectionProcessorFuture(Future<?> connectionProcessorFuture) {
        this.connectionProcessorFuture_ = connectionProcessorFuture;
    }
}

