/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.os.Build;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;
import wigzo.android.sdk.DeviceId;
import wigzo.android.sdk.UserData;
import wigzo.android.sdk.Wigzo;
import wigzo.android.sdk.WigzoAppStore;

public class ConnectionProcessorWigzoApp
implements Runnable {
    private static final int CONNECT_TIMEOUT_IN_MILLISECONDS = 30000;
    private static final int READ_TIMEOUT_IN_MILLISECONDS = 30000;
    private WigzoAppStore wigzoAppStore = null;
    private final DeviceId deviceId_;
    private final String serverURL_;
    private final SSLContext sslContext_;

    ConnectionProcessorWigzoApp(String serverURL, WigzoAppStore store, DeviceId deviceId, SSLContext sslContext) {
        this.serverURL_ = serverURL;
        this.wigzoAppStore = store;
        this.deviceId_ = deviceId;
        this.sslContext_ = sslContext;
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    URLConnection mobileEventData(String eventData) throws IOException {
        String urlStr = "http://vikram.wigzoes.com/mobile/events/i?";
        Log.d((String)"server url: ", (String)urlStr);
        urlStr = urlStr + eventData;
        URL url = new URL(urlStr);
        HttpURLConnection conn = null;
        if (Wigzo.publicKeyPinCertificates == null) {
            conn = (HttpURLConnection)url.openConnection();
        } else {
            HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
            c.setSSLSocketFactory(this.sslContext_.getSocketFactory());
            conn = c;
        }
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "Application/json");
        conn.setDoInput(true);
        String picturePath = UserData.getPicturePathFromQuery(url);
        Log.d((String)"Url : ", (String)("" + url));
        if (!picturePath.equals("")) {
            conn = null;
        } else if (eventData.contains("&crash=")) {
            conn = null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String[] mobileEvents = this.wigzoAppStore.connections();
            Log.d((String)"mobile events size: ", (String)("" + mobileEvents.length));
            if (mobileEvents == null || mobileEvents.length == 0) break;
            if (this.deviceId_.getId() == null) {
                if (!Wigzo.sharedInstance().isLoggingEnabled()) break;
                Log.i((String)"Wigzo", (String)("No Device ID available yet, skipping request " + mobileEvents[0]));
                break;
            }
            String mobileData = mobileEvents[0] + "&device_id=" + this.deviceId_.getId();
            Object conn = null;
            URLConnection mobileconn = null;
            BufferedInputStream responseStream = null;
            BufferedInputStream responseMobile = null;
            try {
                JSONObject responseDict;
                int c;
                mobileconn = this.mobileEventData(mobileData);
                if (null == mobileconn) continue;
                mobileconn.connect();
                responseMobile = new BufferedInputStream(mobileconn.getInputStream());
                if (null == responseMobile) continue;
                ByteArrayOutputStream responseDatas = new ByteArrayOutputStream(256);
                while ((c = responseMobile.read()) != -1) {
                    responseDatas.write(c);
                }
                boolean success = true;
                if (mobileconn instanceof HttpURLConnection) {
                    HttpURLConnection httpConnmobile = (HttpURLConnection)mobileconn;
                    int responseCode = httpConnmobile.getResponseCode();
                    boolean bl = success = responseCode >= 200 && responseCode < 300;
                    if (!success && Wigzo.sharedInstance().isLoggingEnabled()) {
                        Log.w((String)"Wigzo", (String)("HTTP error response code was " + responseCode + " from submitting event data: " + mobileData));
                    }
                }
                if (success && !(success = (responseDict = new JSONObject(responseDatas.toString())).get("result").toString().equalsIgnoreCase("success")) && Wigzo.sharedInstance().isLoggingEnabled()) {
                    Log.w((String)"Wigzo", (String)("Response from Wigzo server did not report success, it was: " + responseDatas.toString("UTF-8")));
                }
                if (!success) break;
                if (Wigzo.sharedInstance().isLoggingEnabled()) {
                    Log.d((String)"Wigzo", (String)("ok ->" + mobileData));
                }
                this.wigzoAppStore.removeConnection(mobileEvents[0]);
                Log.d((String)"response Mobile server", (String)("" + responseDatas.toString()));
                continue;
            }
            catch (Exception e) {
                if (!Wigzo.sharedInstance().isLoggingEnabled()) break;
                Log.w((String)"Wigzo", (String)("Got exception while trying to submit event data: " + mobileData), (Throwable)e);
            }
            finally {
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (conn == null || !(conn instanceof HttpURLConnection)) continue;
                ((HttpURLConnection)conn).disconnect();
                continue;
            }
            break;
        }
    }

    String getServerURL() {
        return this.serverURL_;
    }

    WigzoAppStore getWigzoAppStore() {
        return this.wigzoAppStore;
    }

    DeviceId getDeviceId() {
        return this.deviceId_;
    }
}

