/*
 * Decompiled with CFR 0.152.
 */
package org.openudid;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class OpenUDID_manager
implements ServiceConnection {
    public static final String PREF_KEY = "openudid";
    public static final String PREFS_NAME = "openudid_prefs";
    public static final String TAG = "OpenUDID";
    private static final boolean LOG = true;
    private final Context mContext;
    private List<ResolveInfo> mMatchingIntents;
    private Map<String, Integer> mReceivedOpenUDIDs;
    private final SharedPreferences mPreferences;
    private final Random mRandom;
    private static String OpenUDID = null;
    private static boolean mInitialized = false;

    private OpenUDID_manager(Context context) {
        this.mPreferences = context.getSharedPreferences(PREFS_NAME, 0);
        this.mContext = context;
        this.mRandom = new Random();
        this.mReceivedOpenUDIDs = new HashMap<String, Integer>();
    }

    public void onServiceConnected(ComponentName className, IBinder service) {
        try {
            String _openUDID;
            Parcel data = Parcel.obtain();
            data.writeInt(this.mRandom.nextInt());
            Parcel reply = Parcel.obtain();
            service.transact(1, Parcel.obtain(), reply, 0);
            if (data.readInt() == reply.readInt() && (_openUDID = reply.readString()) != null) {
                Log.d((String)TAG, (String)("Received " + _openUDID));
                if (this.mReceivedOpenUDIDs.containsKey(_openUDID)) {
                    this.mReceivedOpenUDIDs.put(_openUDID, this.mReceivedOpenUDIDs.get(_openUDID) + 1);
                } else {
                    this.mReceivedOpenUDIDs.put(_openUDID, 1);
                }
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.getMessage()));
        }
        this.mContext.unbindService((ServiceConnection)this);
        this.startService();
    }

    public void onServiceDisconnected(ComponentName className) {
    }

    private void storeOpenUDID() {
        SharedPreferences.Editor e = this.mPreferences.edit();
        e.putString(PREF_KEY, OpenUDID);
        e.commit();
    }

    private void generateOpenUDID() {
        Log.d((String)TAG, (String)"Generating openUDID");
        OpenUDID = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        if (OpenUDID == null || OpenUDID.equals("9774d56d682e549c") || OpenUDID.length() < 15) {
            SecureRandom random = new SecureRandom();
            OpenUDID = new BigInteger(64, random).toString(16);
        }
    }

    private void startService() {
        if (this.mMatchingIntents.size() > 0) {
            Log.d((String)TAG, (String)("Trying service " + this.mMatchingIntents.get(0).loadLabel(this.mContext.getPackageManager())));
            ServiceInfo servInfo = this.mMatchingIntents.get((int)0).serviceInfo;
            Intent i = new Intent();
            i.setComponent(new ComponentName(servInfo.applicationInfo.packageName, servInfo.name));
            this.mMatchingIntents.remove(0);
            try {
                this.mContext.bindService(i, (ServiceConnection)this, 1);
            }
            catch (SecurityException e) {
                this.startService();
            }
        } else {
            this.getMostFrequentOpenUDID();
            if (OpenUDID == null) {
                this.generateOpenUDID();
            }
            Log.d((String)TAG, (String)("OpenUDID: " + OpenUDID));
            this.storeOpenUDID();
            mInitialized = true;
        }
    }

    private void getMostFrequentOpenUDID() {
        if (!this.mReceivedOpenUDIDs.isEmpty()) {
            TreeMap<String, Integer> sorted_OpenUDIDS = new TreeMap<String, Integer>(new ValueComparator());
            sorted_OpenUDIDS.putAll(this.mReceivedOpenUDIDs);
            OpenUDID = (String)sorted_OpenUDIDS.firstKey();
        }
    }

    public static String getOpenUDID() {
        if (!mInitialized) {
            Log.e((String)TAG, (String)"Initialisation isn't done");
        }
        return OpenUDID;
    }

    public static boolean isInitialized() {
        return mInitialized;
    }

    public static void sync(Context context) {
        OpenUDID_manager manager = new OpenUDID_manager(context);
        OpenUDID = manager.mPreferences.getString(PREF_KEY, null);
        if (OpenUDID == null) {
            manager.mMatchingIntents = context.getPackageManager().queryIntentServices(new Intent("org.OpenUDID.GETUDID"), 0);
            Log.d((String)TAG, (String)(manager.mMatchingIntents.size() + " services matches OpenUDID"));
            if (manager.mMatchingIntents != null) {
                manager.startService();
            }
        } else {
            Log.d((String)TAG, (String)("OpenUDID: " + OpenUDID));
            mInitialized = true;
        }
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object a, Object b) {
            if ((Integer)OpenUDID_manager.this.mReceivedOpenUDIDs.get(a) < (Integer)OpenUDID_manager.this.mReceivedOpenUDIDs.get(b)) {
                return 1;
            }
            if (OpenUDID_manager.this.mReceivedOpenUDIDs.get(a) == OpenUDID_manager.this.mReceivedOpenUDIDs.get(b)) {
                return 0;
            }
            return -1;
        }
    }
}

