/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.DelegatingXSSFComment;
import com.github.pjfanning.poi.xssf.streaming.SerializableComment;
import com.github.pjfanning.poi.xssf.streaming.TextParser;
import com.microsoft.schemas.vml.CTShape;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFVMLDrawing;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;
import org.slf4j.Logger;

public abstract class CommentsTableBase
extends POIXMLDocumentPart
implements Comments,
AutoCloseable {
    protected Sheet sheet;
    protected boolean ignoreDrawing = false;
    protected final boolean fullFormat;
    protected ConcurrentMap<String, SerializableComment> comments;
    protected ConcurrentMap<Integer, String> authors;
    private static final XmlOptions textSaveOptions = new XmlOptions(Constants.saveOptions);

    protected CommentsTableBase(boolean fullFormat) {
        this.fullFormat = fullFormat;
    }

    protected abstract Logger getLogger();

    protected abstract Iterator<Integer> authorsKeyIterator();

    protected abstract Iterator<String> commentsKeyIterator();

    public void setIgnoreDrawing(boolean ignoreDrawing) {
        this.ignoreDrawing = ignoreDrawing;
    }

    public boolean isIgnoreDrawing() {
        return this.ignoreDrawing;
    }

    @Internal
    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        try (OutputStream out = part.getOutputStream();){
            this.writeTo(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream is) throws IOException {
        try (XMLEventReader xmlEventReader = Constants.XML_INPUT_FACTORY.createXMLEventReader(is);){
            while (xmlEventReader.hasNext()) {
                XSSFRichTextString str;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement se = xmlEvent.asStartElement();
                if (se.getName().getLocalPart().equals("author")) {
                    this.authors.put(this.getNumberOfAuthors(), xmlEventReader.getElementText());
                    continue;
                }
                if (!se.getName().getLocalPart().equals("comment")) continue;
                String ref = se.getAttributeByName(new QName("ref")).getValue();
                String authorId = se.getAttributeByName(new QName("authorId")).getValue();
                if (this.fullFormat) {
                    try {
                        str = this.parseFullComment(xmlEventReader);
                    }
                    catch (XmlException e) {
                        throw new IOException("Failed to parse comment", e);
                    }
                } else {
                    str = new XSSFRichTextString(this.parseSimplifiedComment(xmlEventReader));
                }
                SerializableComment xc = new SerializableComment();
                xc.setAddress(new CellAddress(ref));
                xc.setAuthor((String)this.authors.get(Integer.parseInt(authorId)));
                xc.setString((RichTextString)str);
                this.comments.put(ref, xc);
            }
        }
        catch (XMLStreamException xse) {
            throw new IOException("Failed to parse comments", xse);
        }
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public int getNumberOfAuthors() {
        return this.authors.size();
    }

    public String getAuthor(long authorId) {
        return (String)this.authors.get((int)authorId);
    }

    public int findAuthor(String author) {
        String nullSafeAuthor = author == null ? "" : author;
        Iterator<Integer> authorIdIterator = this.authorsKeyIterator();
        while (authorIdIterator.hasNext()) {
            Integer authorId = authorIdIterator.next();
            String existingAuthor = authorId == null ? null : (String)this.authors.get(authorId);
            if (!nullSafeAuthor.equals(existingAuthor)) continue;
            return authorId;
        }
        int index = this.getNumberOfAuthors();
        if (index == 0 && !nullSafeAuthor.equals("")) {
            this.authors.put(index++, "");
        }
        this.authors.put(index, nullSafeAuthor);
        return index;
    }

    public XSSFComment findCellComment(CellAddress cellAddress) {
        SerializableComment serializableComment = (SerializableComment)this.comments.get(cellAddress.formatAsString());
        if (serializableComment == null) {
            return null;
        }
        XSSFVMLDrawing vml = this.getVMLDrawing(this.sheet, false);
        return new DelegatingXSSFComment(this, serializableComment, vml == null ? null : vml.findCommentShape(cellAddress.getRow(), cellAddress.getColumn()));
    }

    public boolean removeComment(CellAddress cellRef) {
        return this.comments.remove(cellRef.formatAsString()) != null;
    }

    public Iterator<CellAddress> getCellAddresses() {
        final Iterator<String> keyIterator = this.commentsKeyIterator();
        return new Iterator<CellAddress>(){

            @Override
            public boolean hasNext() {
                return keyIterator.hasNext();
            }

            @Override
            public CellAddress next() {
                return new CellAddress((String)keyIterator.next());
            }
        };
    }

    public XSSFComment createNewComment(ClientAnchor clientAnchor) {
        CellAddress ref;
        CTShape vmlShape;
        XSSFVMLDrawing vml = this.getVMLDrawing(this.sheet, true);
        CTShape cTShape = vmlShape = vml == null ? null : vml.newCommentShape();
        if (vmlShape != null && clientAnchor instanceof XSSFClientAnchor && ((XSSFClientAnchor)clientAnchor).isSet()) {
            int dx1Pixels = clientAnchor.getDx1() / 9525;
            int dy1Pixels = clientAnchor.getDy1() / 9525;
            int dx2Pixels = clientAnchor.getDx2() / 9525;
            int dy2Pixels = clientAnchor.getDy2() / 9525;
            String position = clientAnchor.getCol1() + ", " + dx1Pixels + ", " + clientAnchor.getRow1() + ", " + dy1Pixels + ", " + clientAnchor.getCol2() + ", " + dx2Pixels + ", " + clientAnchor.getRow2() + ", " + dy2Pixels;
            vmlShape.getClientDataArray(0).setAnchorArray(0, position);
        }
        if (this.findCellComment(ref = new CellAddress(clientAnchor.getRow1(), (int)clientAnchor.getCol1())) != null) {
            throw new IllegalArgumentException("Multiple cell comments in one cell are not allowed, cell: " + ref);
        }
        String key = ref.formatAsString();
        CTComment ctComment = (CTComment)CTComment.Factory.newInstance();
        ctComment.setRef(key);
        SerializableComment serializableComment = new SerializableComment();
        serializableComment.setAddress(ref);
        this.comments.put(key, serializableComment);
        return new XSSFComment((Comments)this, ctComment, vmlShape);
    }

    public void referenceUpdated(CellAddress oldReference, XSSFComment comment) {
        this.removeComment(oldReference);
        this.addToMap(comment);
    }

    public void commentUpdated(XSSFComment comment) {
        this.removeComment(comment.getAddress());
        this.addToMap(comment);
    }

    private void addToMap(XSSFComment comment) {
        SerializableComment serializableComment = new SerializableComment();
        serializableComment.setAddress(comment.getAddress());
        serializableComment.setString((RichTextString)comment.getString());
        serializableComment.setAuthor(comment.getAuthor());
        serializableComment.setVisible(comment.isVisible());
        this.comments.put(comment.getAddress().formatAsString(), serializableComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<comments xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\"><authors>");
            Iterator<Integer> authorIdIterator = this.authorsKeyIterator();
            while (authorIdIterator.hasNext()) {
                Integer authorId = authorIdIterator.next();
                String author = authorId == null ? null : (String)this.authors.get(authorId);
                writer.write("<author>");
                writer.write(StringEscapeUtils.escapeXml11((String)author));
                writer.write("</author>");
            }
            writer.write("</authors>");
            writer.write("<commentList>");
            Iterator<String> commentsRefIterator = this.commentsKeyIterator();
            while (commentsRefIterator.hasNext()) {
                SerializableComment comment = (SerializableComment)this.comments.get(commentsRefIterator.next());
                if (comment == null) continue;
                writer.write("<comment ref=\"");
                writer.write(StringEscapeUtils.escapeXml11((String)comment.getAddress().formatAsString()));
                String author = comment.getAuthor();
                int authorId = this.findAuthor(author);
                writer.write("\" authorId=\"");
                writer.write(Integer.toString(authorId));
                writer.write("\">");
                XSSFRichTextString rts = comment.getString();
                if (rts != null) {
                    if (rts.getCTRst() != null) {
                        writer.write(rts.getCTRst().xmlText(textSaveOptions));
                    } else {
                        writer.write("<text><t>");
                        writer.write(StringEscapeUtils.escapeXml11((String)comment.getString().getString()));
                        writer.write("</t></text>");
                    }
                }
                writer.write("</comment>");
            }
            writer.write("</commentList>");
            writer.write("</comments>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    private XSSFRichTextString parseFullComment(XMLEventReader xmlEventReader) throws IOException, XmlException, XMLStreamException {
        XMLEvent xmlEvent;
        XSSFRichTextString richTextString = null;
        block6: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            StartElement startElement = xmlEvent.asStartElement();
            QName startTag = startElement.getName();
            switch (startTag.getLocalPart()) {
                case "text": {
                    List<String> tags = Arrays.asList("comments", "commentList", "comment", "text");
                    String text = TextParser.getXMLText(xmlEventReader, startTag, tags);
                    CTCommentList commentsList = ((CommentsDocument)CommentsDocument.Factory.parse(text)).getComments().getCommentList();
                    richTextString = new XSSFRichTextString(commentsList.getCommentArray(0).getText());
                    continue block6;
                }
            }
            this.getLogger().debug("ignoring data inside element {}", (Object)startElement.getName());
        }
        return richTextString;
    }

    private String parseSimplifiedComment(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        String text = null;
        block6: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            StartElement startElement = xmlEvent.asStartElement();
            switch (startElement.getName().getLocalPart()) {
                case "text": {
                    text = TextParser.parseCT_Rst(xmlEventReader);
                    continue block6;
                }
            }
            this.getLogger().debug("ignoring data inside element {}", (Object)startElement.getName());
        }
        return text;
    }

    private XSSFVMLDrawing getVMLDrawing(Sheet sheet, boolean autocreate) {
        if (!this.ignoreDrawing) {
            if (sheet instanceof XSSFSheet) {
                return ((XSSFSheet)sheet).getVMLDrawing(autocreate);
            }
            if (sheet instanceof SXSSFSheet) {
                return ((SXSSFSheet)sheet).getVMLDrawing(autocreate);
            }
        }
        return null;
    }

    static {
        textSaveOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "text"));
    }
}

