/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.microsoft.schemas.vml.CTShape;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;

class SimpleXSSFComment
extends XSSFComment {
    private String author;
    private XSSFRichTextString richTextString;
    private CellAddress address;
    private boolean visible = true;

    public SimpleXSSFComment() {
        super(null, null, null);
    }

    public void setAddress(CellAddress address) {
        this.address = address;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public int getColumn() {
        if (this.address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return this.address.getColumn();
    }

    public int getRow() {
        if (this.address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return this.address.getRow();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public CellAddress getAddress() {
        return this.address;
    }

    public void setAddress(int row, int col) {
        this.setAddress(new CellAddress(row, col));
    }

    public void setColumn(int col) {
        if (this.address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(this.address.getRow(), col);
    }

    public void setRow(int row) {
        if (this.address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(row, this.address.getColumn());
    }

    public XSSFRichTextString getString() {
        return this.richTextString;
    }

    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this.richTextString = (XSSFRichTextString)string;
    }

    public void setString(String text) {
        XSSFRichTextString rts = new XSSFRichTextString();
        rts.setString(text);
        this.richTextString = rts;
    }

    public ClientAnchor getClientAnchor() {
        throw new RuntimeException("Not Implemented");
    }

    protected CTComment getCTComment() {
        throw new RuntimeException("Not Implemented");
    }

    protected CTShape getCTShape() {
        throw new RuntimeException("Not Implemented");
    }
}

