/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.xlsx.exceptions.ReadException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class OoXmlStrictConverterUtils {
    private OoXmlStrictConverterUtils() {
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !OoXmlStrictConverterUtils.isBlank(str);
    }

    public static Properties readMappings() throws ReadException {
        Properties props = new Properties();
        try (InputStream is = OoXmlStrictConverterUtils.class.getResourceAsStream("/ooxml-strict-mappings.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] vals = line.split("=");
                if (vals.length >= 2) {
                    props.setProperty(vals[0], vals[1]);
                    continue;
                }
                if (vals.length != 1) continue;
                props.setProperty(vals[0], "");
            }
        }
        catch (IOException e) {
            throw new ReadException("Failed to read mappings", e);
        }
        return props;
    }
}

