/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx;

import com.github.pjfanning.poi.xssf.streaming.TempFileSharedStringsTable;
import com.github.pjfanning.xlsx.XmlUtils;
import com.github.pjfanning.xlsx.exceptions.MissingSheetException;
import com.github.pjfanning.xlsx.exceptions.OpenException;
import com.github.pjfanning.xlsx.exceptions.ParseException;
import com.github.pjfanning.xlsx.exceptions.ReadException;
import com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import com.github.pjfanning.xlsx.impl.StreamingWorkbook;
import com.github.pjfanning.xlsx.impl.StreamingWorkbookReader;
import com.github.pjfanning.xlsx.impl.TempFileUtil;
import com.github.pjfanning.xlsx.impl.WorkbookUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StreamingReader
implements Iterable<Row>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingReader.class);
    private File tmp;
    private final StreamingWorkbookReader workbook;

    public StreamingReader(StreamingWorkbookReader workbook) {
        this.workbook = workbook;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.workbook.first().iterator();
    }

    @Override
    public void close() throws IOException {
        try {
            this.workbook.close();
        }
        finally {
            if (this.tmp != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting tmp file [" + this.tmp.getAbsolutePath() + "]");
                }
                this.tmp.delete();
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int rowCacheSize = 10;
        private int bufferSize = 1024;
        private int sheetIndex = 0;
        private boolean useSstTempFile = false;
        private boolean encryptSstTempFile = false;
        private boolean readCoreProperties = false;
        private String sheetName;
        private String password;
        private boolean convertFromOoXmlStrict;

        public int getRowCacheSize() {
            return this.rowCacheSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean useSstTempFile() {
            return this.useSstTempFile;
        }

        public boolean encryptSstTempFile() {
            return this.encryptSstTempFile;
        }

        public boolean readCoreProperties() {
            return this.readCoreProperties;
        }

        public boolean convertFromOoXmlStrict() {
            return this.convertFromOoXmlStrict;
        }

        public Builder rowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder sheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
            return this;
        }

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder convertFromOoXmlStrict(boolean convertFromOoXmlStrict) {
            this.convertFromOoXmlStrict = convertFromOoXmlStrict;
            return this;
        }

        public Builder setUseSstTempFile(boolean useSstTempFile) {
            this.useSstTempFile = useSstTempFile;
            return this;
        }

        public Builder setEncryptSstTempFile(boolean encryptSstTempFile) {
            this.encryptSstTempFile = encryptSstTempFile;
            return this;
        }

        public Builder setReadCoreProperties(boolean readCoreProperties) {
            this.readCoreProperties = readCoreProperties;
            return this;
        }

        public Workbook open(InputStream is) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(is);
            return new StreamingWorkbook(workbook);
        }

        public Workbook open(File file) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(file);
            return new StreamingWorkbook(workbook);
        }

        public StreamingReader read(InputStream is) {
            File f = null;
            try {
                f = TempFileUtil.writeInputStreamToFile(is, this.bufferSize);
                log.debug("Created temp file [" + f.getAbsolutePath() + "]");
                StreamingReader r = this.read(f);
                r.tmp = f;
                return r;
            }
            catch (IOException e) {
                throw new ReadException("Unable to read input stream", e);
            }
            catch (RuntimeException e) {
                if (f != null) {
                    f.delete();
                }
                throw e;
            }
        }

        public StreamingReader read(File f) {
            try {
                SharedStringsTable sst;
                OPCPackage pkg;
                if (this.password != null) {
                    POIFSFileSystem poifs = new POIFSFileSystem(f);
                    EncryptionInfo info = new EncryptionInfo(poifs);
                    Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                    d.verifyPassword(this.password);
                    pkg = OPCPackage.open((InputStream)d.getDataStream(poifs));
                } else {
                    pkg = OPCPackage.open((File)f);
                }
                boolean use1904Dates = false;
                XSSFReader reader = new XSSFReader(pkg);
                if (this.useSstTempFile) {
                    log.debug("Created sst cache file");
                    sst = new TempFileSharedStringsTable(pkg, this.encryptSstTempFile);
                } else {
                    sst = reader.getSharedStringsTable();
                }
                StylesTable styles = reader.getStylesTable();
                use1904Dates = WorkbookUtil.use1904Dates(reader);
                InputStream sheet = this.findSheet(reader);
                if (sheet == null) {
                    throw new MissingSheetException("Unable to find sheet at index [" + this.sheetIndex + "]");
                }
                XMLEventReader parser = XMLHelper.newXMLInputFactory().createXMLEventReader(sheet);
                return new StreamingReader(new StreamingWorkbookReader(sst, pkg, new StreamingSheetReader(sst, styles, parser, use1904Dates, this.rowCacheSize), this));
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new ParseException("Failed to parse file", e);
            }
            catch (IOException e) {
                throw new OpenException("Failed to open file", e);
            }
            catch (XMLStreamException | OpenXML4JException e) {
                throw new ReadException("Unable to read workbook", (Exception)e);
            }
            catch (GeneralSecurityException e) {
                throw new ReadException("Unable to read workbook - Decryption failed", e);
            }
        }

        private InputStream findSheet(XSSFReader reader) throws IOException, InvalidFormatException {
            int index = this.sheetIndex;
            if (this.sheetName != null) {
                index = -1;
                try {
                    NodeList nl = XmlUtils.searchForNodeList(XmlUtils.readDocument(reader.getWorkbookData()), "/ss:workbook/ss:sheets/ss:sheet");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (!Objects.equals(nl.item(i).getAttributes().getNamedItem("name").getTextContent(), this.sheetName)) continue;
                        index = i;
                    }
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new ParseException("Failed to parse file", e);
                }
                if (index < 0) {
                    return null;
                }
            }
            Iterator iter = reader.getSheetsData();
            InputStream sheet = null;
            int i = 0;
            while (iter.hasNext()) {
                InputStream is = (InputStream)iter.next();
                if (i++ != index) continue;
                sheet = is;
                log.debug("Found sheet at index [" + this.sheetIndex + "]");
                break;
            }
            return sheet;
        }
    }
}

