/*
 * Decompiled with CFR 0.152.
 */
package com.zhouwei.mzbanner.transformer;

import android.support.v4.view.ViewPager;
import android.view.View;

public class CoverModeTransformer
implements ViewPager.PageTransformer {
    private float reduceX = 0.0f;
    private float itemWidth = 0.0f;
    private float offsetPosition = 0.0f;
    private int mCoverWidth;
    private float mScaleMax = 1.0f;
    private float mScaleMin = 0.9f;
    private ViewPager mViewPager;

    public CoverModeTransformer(ViewPager pager) {
        this.mViewPager = pager;
    }

    public void transformPage(View view, float position) {
        if (this.offsetPosition == 0.0f) {
            float paddingLeft = this.mViewPager.getPaddingLeft();
            float paddingRight = this.mViewPager.getPaddingRight();
            float width = this.mViewPager.getMeasuredWidth();
            this.offsetPosition = paddingLeft / (width - paddingLeft - paddingRight);
        }
        float currentPos = position - this.offsetPosition;
        if (this.itemWidth == 0.0f) {
            this.itemWidth = view.getWidth();
            this.reduceX = (2.0f - this.mScaleMax - this.mScaleMin) * this.itemWidth / 2.0f;
        }
        if (currentPos <= -1.0f) {
            view.setTranslationX(this.reduceX + (float)this.mCoverWidth);
            view.setScaleX(this.mScaleMin);
            view.setScaleY(this.mScaleMin);
        } else if ((double)currentPos <= 1.0) {
            float scale = (this.mScaleMax - this.mScaleMin) * Math.abs(1.0f - Math.abs(currentPos));
            float translationX = currentPos * -this.reduceX;
            if ((double)currentPos <= -0.5) {
                view.setTranslationX(translationX + (float)this.mCoverWidth * Math.abs(Math.abs(currentPos) - 0.5f) / 0.5f);
            } else if (currentPos <= 0.0f) {
                view.setTranslationX(translationX);
            } else if ((double)currentPos >= 0.5) {
                view.setTranslationX(translationX - (float)this.mCoverWidth * Math.abs(Math.abs(currentPos) - 0.5f) / 0.5f);
            } else {
                view.setTranslationX(translationX);
            }
            view.setScaleX(scale + this.mScaleMin);
            view.setScaleY(scale + this.mScaleMin);
        } else {
            view.setScaleX(this.mScaleMin);
            view.setScaleY(this.mScaleMin);
            view.setTranslationX(-this.reduceX - (float)this.mCoverWidth);
        }
    }
}

