/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.rxandroidaudio;

import android.media.MediaRecorder;
import android.util.Log;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AudioRecorder {
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BIT_RATE = 44100;
    public static final int ERROR_SDCARD_ACCESS = 1;
    public static final int ERROR_INTERNAL = 2;
    public static final int ERROR_NOT_PREPARED = 3;
    private static final String TAG = "AudioRecorder";
    private static final int STOP_AUDIO_RECORD_DELAY_MILLIS = 300;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARED = 1;
    private static final int STATE_RECORDING = 2;
    private int mState = 0;
    private OnErrorListener mOnErrorListener;
    private long mSampleStart = 0L;
    private MediaRecorder mRecorder;
    private boolean mStarted = false;

    private AudioRecorder() {
    }

    public static AudioRecorder getInstance() {
        return RxAndroidAudioHolder.INSTANCE;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public synchronized int getMaxAmplitude() {
        if (this.mState != 2) {
            return 0;
        }
        return this.mRecorder.getMaxAmplitude();
    }

    public int progress() {
        if (this.mState == 2) {
            return (int)((System.currentTimeMillis() - this.mSampleStart) / 1000L);
        }
        return 0;
    }

    @WorkerThread
    public synchronized boolean startRecord(int audioSource, int outputFormat, int audioEncoder, int sampleRate, int bitRate, File outputFile) {
        this.stopRecord();
        this.mRecorder = new MediaRecorder();
        this.mRecorder.setAudioSource(audioSource);
        this.mRecorder.setOutputFormat(outputFormat);
        this.mRecorder.setAudioSamplingRate(sampleRate);
        this.mRecorder.setAudioEncodingBitRate(bitRate);
        this.mRecorder.setAudioEncoder(audioEncoder);
        this.mRecorder.setOutputFile(outputFile.getAbsolutePath());
        try {
            this.mRecorder.prepare();
        }
        catch (IOException | RuntimeException exception) {
            Log.w((String)TAG, (String)("startRecord fail, prepare fail: " + exception.getMessage()));
            this.setError(2);
            this.mRecorder.reset();
            this.mRecorder.release();
            this.mRecorder = null;
            return false;
        }
        try {
            this.mRecorder.start();
            this.mStarted = true;
        }
        catch (RuntimeException exception) {
            Log.w((String)TAG, (String)("startRecord fail, start fail: " + exception.getMessage()));
            this.setError(2);
            this.mRecorder.reset();
            this.mRecorder.release();
            this.mRecorder = null;
            this.mStarted = false;
            return false;
        }
        this.mSampleStart = System.currentTimeMillis();
        this.mState = 2;
        return true;
    }

    @WorkerThread
    public synchronized boolean prepareRecord(int audioSource, int outputFormat, int audioEncoder, File outputFile) {
        return this.prepareRecord(audioSource, outputFormat, audioEncoder, 44100, 44100, outputFile);
    }

    @WorkerThread
    public synchronized boolean prepareRecord(int audioSource, int outputFormat, int audioEncoder, int sampleRate, int bitRate, File outputFile) {
        this.stopRecord();
        this.mRecorder = new MediaRecorder();
        this.mRecorder.setAudioSource(audioSource);
        this.mRecorder.setOutputFormat(outputFormat);
        this.mRecorder.setAudioSamplingRate(sampleRate);
        this.mRecorder.setAudioEncodingBitRate(bitRate);
        this.mRecorder.setAudioEncoder(audioEncoder);
        this.mRecorder.setOutputFile(outputFile.getAbsolutePath());
        try {
            this.mRecorder.prepare();
        }
        catch (IOException exception) {
            Log.w((String)TAG, (String)("startRecord fail, prepare fail: " + exception.getMessage()));
            this.setError(2);
            this.mRecorder.reset();
            this.mRecorder.release();
            this.mRecorder = null;
            return false;
        }
        this.mState = 1;
        return true;
    }

    @WorkerThread
    public synchronized boolean startRecord() {
        if (this.mRecorder == null || this.mState != 1) {
            this.setError(3);
            return false;
        }
        try {
            this.mRecorder.start();
            this.mStarted = true;
        }
        catch (RuntimeException exception) {
            Log.w((String)TAG, (String)("startRecord fail, start fail: " + exception.getMessage()));
            this.setError(2);
            this.mRecorder.reset();
            this.mRecorder.release();
            this.mRecorder = null;
            this.mStarted = false;
            return false;
        }
        this.mSampleStart = System.currentTimeMillis();
        this.mState = 2;
        return true;
    }

    @WorkerThread
    public synchronized int stopRecord() {
        if (this.mRecorder == null) {
            this.mState = 0;
            return -1;
        }
        int length = -1;
        switch (this.mState) {
            case 2: {
                try {
                    Thread.sleep(300L);
                    this.mRecorder.stop();
                    this.mStarted = false;
                    length = (int)((System.currentTimeMillis() - this.mSampleStart) / 1000L);
                    break;
                }
                catch (RuntimeException e) {
                    Log.w((String)TAG, (String)("stopRecord fail, stop fail(no audio data recorded): " + e.getMessage()));
                    break;
                }
                catch (InterruptedException e) {
                    Log.w((String)TAG, (String)("stopRecord fail, stop fail(InterruptedException): " + e.getMessage()));
                }
            }
        }
        try {
            this.mRecorder.reset();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)("stopRecord fail, reset fail " + e.getMessage()));
        }
        this.mRecorder.release();
        this.mRecorder = null;
        this.mState = 0;
        return length;
    }

    private void setError(int error) {
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onError(error);
        }
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    private static class RxAndroidAudioHolder {
        private static final AudioRecorder INSTANCE = new AudioRecorder();

        private RxAndroidAudioHolder() {
        }
    }

    public static interface OnErrorListener {
        @WorkerThread
        public void onError(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

